/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.ndk;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.io.IOException;
import paycardscanner.ndk.DisplayConfiguration;
import paycardscanner.ndk.RecognitionCoreDummy;
import paycardscanner.ndk.RecognitionCoreImpl;
import paycardscanner.ndk.RecognitionCoreNdk;
import paycardscanner.ndk.RecognitionStatusListener;
import paycardscanner.ndk.TorchStatusListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecognitionCore {
    private static volatile RecognitionCore sInstance;
    private static volatile RecognitionCoreImpl sImpl;

    /*
     * WARNING - void declaration
     */
    public static RecognitionCore getInstance(Context context) {
        block3: {
            void var0_3;
            try {
                RecognitionCore.deploy(context);
                break block3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Log.e((String)"RecognitionCore", (String)"initialization failed", (Throwable)var0_3);
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deploy(Context context) throws IOException, UnsatisfiedLinkError {
        if (sInstance != null) return;
        Class<RecognitionCore> clazz = RecognitionCore.class;
        synchronized (RecognitionCore.class) {
            if (sInstance != null) return;
            RecognitionCoreNdk recognitionCoreNdk = RecognitionCoreNdk.getInstance(context.getApplicationContext());
            recognitionCoreNdk.deploy();
            sImpl = recognitionCoreNdk;
            {
                catch (Throwable throwable) {
                    sInstance = new RecognitionCore();
                    throw throwable;
                }
            }
            sInstance = new RecognitionCore();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Class<RecognitionCore> clazz = RecognitionCore.class;
        synchronized (RecognitionCore.class) {
            boolean bl = sInstance != null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return bl;
        }
    }

    static {
        sImpl = new RecognitionCoreDummy();
    }

    public boolean isDeviceSupported() {
        return sImpl instanceof RecognitionCoreDummy ^ true;
    }

    public void setStatusListener(@Nullable RecognitionStatusListener recognitionStatusListener2) {
        sImpl.setStatusListener(recognitionStatusListener2);
    }

    public void setTorchStatus(boolean bl) {
        sImpl.setTorchStatus(bl);
    }

    public void setTorchListener(@Nullable TorchStatusListener torchStatusListener) {
        sImpl.setTorchListener(torchStatusListener);
    }

    public void setRecognitionMode(int n) {
        sImpl.setRecognitionMode(n);
    }

    public void setDisplayConfiguration(@NonNull DisplayConfiguration displayConfiguration) {
        sImpl.setDisplayConfiguration(displayConfiguration);
    }

    public Rect getCardFrameRect() {
        return sImpl.getCardFrameRect();
    }

    public int processFrameYV12(int n, int n2, byte[] byArray) {
        return sImpl.processFrameYV12(n, n2, byArray);
    }

    public void resetResult() {
        sImpl.resetResult();
    }

    public void setIdle(boolean bl) {
        sImpl.setIdle(bl);
    }

    public boolean isIdle() {
        return sImpl.isIdle();
    }
}

