/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.ndk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import java.io.IOException;
import paycardscanner.ndk.DisplayConfiguration;
import paycardscanner.ndk.DisplayConfigurationImpl;
import paycardscanner.ndk.NeuroDataHelper;
import paycardscanner.ndk.RecognitionCoreImpl;
import paycardscanner.ndk.RecognitionResult;
import paycardscanner.ndk.RecognitionStatusListener;
import paycardscanner.ndk.TorchStatusListener;

final class RecognitionCoreNdk
implements RecognitionCoreImpl {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile RecognitionCoreNdk sInstance;
    private final Context mAppContext;
    private final Handler mMainThreadHandler;
    private final Rect mCardFrameRect = new Rect(30, 432, 690, 848);
    private DisplayConfiguration mDisplayConfiguration = new DisplayConfigurationImpl();
    @Nullable
    private RecognitionStatusListener mStatusListener;
    @Nullable
    private TorchStatusListenerHandler mTorchStatusListener;

    public static RecognitionCoreNdk getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new RecognitionCoreNdk(context.getApplicationContext());
        }
        return sInstance;
    }

    private RecognitionCoreNdk(Context context) {
        Handler handler;
        RecognitionCoreNdk.nativeInit();
        recognitionCoreNdk3.mAppContext = context.getApplicationContext();
        try {
            recognitionCoreNdk3.deploy();
        }
        catch (IOException iOException) {
            Log.e((String)"CardRecognizerCore", (String)"initialization failed", (Throwable)iOException);
        }
        RecognitionCoreNdk recognitionCoreNdk = recognitionCoreNdk3;
        context = handler;
        RecognitionCoreNdk recognitionCoreNdk2 = recognitionCoreNdk3;
        RecognitionCoreNdk recognitionCoreNdk3 = Looper.getMainLooper();
        handler = new Handler((Looper)recognitionCoreNdk3, message -> {
            Object object;
            int n = message.what;
            if (n != 1) {
                if (n != 2) {
                    return false;
                }
                object = ((RecognitionCoreNdk)object).mStatusListener;
                if (object != null) {
                    object.onCardImageReceived((Bitmap)message.obj);
                }
                return true;
            }
            object = ((RecognitionCoreNdk)object).mStatusListener;
            if (object != null) {
                object.onRecognitionComplete((RecognitionResult)message.obj);
            }
            return true;
        });
        recognitionCoreNdk.mMainThreadHandler = context;
    }

    @Keep
    @WorkerThread
    private static void onRecognitionResultReceived(boolean bl, boolean bl2, String string, String string2, String string3, String string4, Bitmap bitmap, int n, int n2, int n3, int n4) {
        Rect rect;
        if (sInstance == null) {
            return;
        }
        if (n3 != 0 && n4 != 0) {
            Rect rect2;
            rect = rect2;
            n3 = n + n3;
            n4 = n2 + n4;
            rect2 = new Rect(n, n2, n3, n4);
        } else {
            rect = null;
        }
        RecognitionResult recognitionResult = new RecognitionResult.Builder().setIsFirst(bl).setIsFinal(bl2).setNumber(string).setName(string3).setDate(string2).setNameRaw(string4).setNumberImageRect(rect).setCardImage(bitmap).build();
        Message.obtain((Handler)RecognitionCoreNdk.sInstance.mMainThreadHandler, (int)1, (Object)recognitionResult).sendToTarget();
    }

    @Keep
    @WorkerThread
    private static void onCardImageReceived(Bitmap bitmap) {
        Message.obtain((Handler)RecognitionCoreNdk.sInstance.mMainThreadHandler, (int)2, (Object)bitmap).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Keep
    @WorkerThread
    private static void onTorchStatusChanged(boolean bl) {
        Class<RecognitionCoreNdk> clazz = RecognitionCoreNdk.class;
        // MONITORENTER : paycardscanner.ndk.RecognitionCoreNdk.class
        if (sInstance == null) {
            // MONITOREXIT : clazz
            return;
        }
        RecognitionCoreNdk recognitionCoreNdk = sInstance;
        if (RecognitionCoreNdk.sInstance.mTorchStatusListener != null) {
            RecognitionCoreNdk.sInstance.mTorchStatusListener.sendStatusChanged(bl);
        }
        Class<RecognitionCoreNdk> clazz2 = clazz;
        // MONITOREXIT : recognitionCoreNdk
        {
            catch (Throwable throwable) {
                // MONITOREXIT : recognitionCoreNdk
                throw throwable;
            }
        }
        // MONITOREXIT : clazz2
    }

    static native void nativeInit();

    static native void nativeDestroy();

    static {
        System.loadLibrary("c++_shared");
        System.loadLibrary("data");
    }

    public void deploy() throws IOException {
        RecognitionCoreNdk recognitionCoreNdk = this;
        NeuroDataHelper neuroDataHelper = new NeuroDataHelper(this.mAppContext);
        neuroDataHelper.unpackAssets();
        recognitionCoreNdk.nativeSetDataPath(neuroDataHelper.getDataBasePath().getAbsolutePath());
        recognitionCoreNdk.nativeDeploy();
    }

    @Override
    public void setStatusListener(@Nullable RecognitionStatusListener recognitionStatusListener2) {
        this.mStatusListener = recognitionStatusListener2;
    }

    @Override
    public void setTorchStatus(boolean bl) {
        this.nativeSetTorchStatus(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTorchListener(@Nullable TorchStatusListener torchStatusListener) {
        RecognitionCoreNdk recognitionCoreNdk = this;
        synchronized (recognitionCoreNdk) {
            TorchStatusListenerHandler torchStatusListenerHandler = recognitionCoreNdk.mTorchStatusListener;
            if (torchStatusListenerHandler != null && torchStatusListenerHandler.mListener == torchStatusListener) {
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            if (torchStatusListenerHandler != null) {
                torchStatusListenerHandler.stop();
                this.mTorchStatusListener = null;
            }
            if (torchStatusListener != null) {
                this.mTorchStatusListener = new TorchStatusListenerHandler(Looper.myLooper(), torchStatusListener);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void setRecognitionMode(int n) {
        this.nativeSetRecognitionMode(n);
    }

    @Override
    public synchronized void setDisplayConfiguration(@NonNull DisplayConfiguration displayConfiguration) {
        RecognitionCoreNdk recognitionCoreNdk = recognitionCoreNdk2;
        recognitionCoreNdk2.mDisplayConfiguration = displayConfiguration;
        recognitionCoreNdk.nativeSetOrientation(displayConfiguration.getNativeDisplayRotation());
        RecognitionCoreNdk recognitionCoreNdk2 = recognitionCoreNdk.mCardFrameRect;
        recognitionCoreNdk.nativeCalcWorkingArea(1280, 720, 32, (Rect)recognitionCoreNdk2);
    }

    @Override
    public Rect getCardFrameRect() {
        return this.mCardFrameRect;
    }

    @Override
    public synchronized int processFrameYV12(int n, int n2, byte[] byArray) {
        int n3 = this.mDisplayConfiguration.getPreprocessFrameRotation(n, n2);
        if (n3 == -1) {
            return 0;
        }
        return this.nativeProcessFrameYV12(n, n2, n3, byArray);
    }

    @Override
    public void resetResult() {
        this.nativeResetResult();
    }

    @Override
    public void setIdle(boolean bl) {
        this.nativeSetIdle(bl);
    }

    @Override
    public boolean isIdle() {
        return this.nativeIsIdle();
    }

    protected void finalize() throws Throwable {
        RecognitionCoreNdk.nativeDestroy();
        super.finalize();
    }

    native void nativeSetDataPath(String var1);

    native void nativeDeploy();

    native void nativeSetRecognitionMode(int var1);

    native void nativeSetIdle(boolean var1);

    native void nativeSetTorchStatus(boolean var1);

    native boolean nativeIsIdle();

    native void nativeCalcWorkingArea(int var1, int var2, int var3, Rect var4);

    native void nativeSetOrientation(int var1);

    native void nativeResetResult();

    native int nativeProcessFrameYV12(int var1, int var2, int var3, byte[] var4);

    private static class TorchStatusListenerHandler
    extends Handler {
        private final TorchStatusListener mListener;

        public TorchStatusListenerHandler(Looper looper, TorchStatusListener torchStatusListener) {
            super(looper);
            this.mListener = torchStatusListener;
        }

        public TorchStatusListenerHandler(TorchStatusListener torchStatusListener) {
            this.mListener = torchStatusListener;
        }

        public void sendStatusChanged(boolean bl) {
            TorchStatusListenerHandler torchStatusListenerHandler = this;
            torchStatusListenerHandler.removeMessages(3);
            torchStatusListenerHandler.sendMessage(Message.obtain((Handler)torchStatusListenerHandler, (int)3, (int)(bl ? 1 : 0), (int)0));
        }

        public void stop() {
            this.removeMessages(3);
        }

        public void handleMessage(Message message) {
            if (message.what == 3) {
                TorchStatusListener torchStatusListener = this.mListener;
                boolean bl = message.arg1 != 0;
                torchStatusListener.onTorchStatusChanged(bl);
            }
            super.handleMessage(message);
        }
    }
}

