/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;
import paycardscanner.camera.RecognitionAvailabilityChecker;
import paycardscanner.camera.RecognitionCoreUtils;
import paycardscanner.camera.RecognitionUnavailableException;
import paycardscanner.camera.widget.CameraPreviewLayout;
import paycardscanner.ndk.RecognitionCore;
import paycardscanner.sdk.R;
import paycardscanner.ui.ScanCardFragment;
import paycardscanner.ui.ScanCardRequest;
import paycardscanner.ui.views.ProgressBarIndeterminate;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class InitLibraryFragment
extends Fragment {
    private InteractionListener mListener;
    private ProgressBarIndeterminate mProgressBar;
    private CameraPreviewLayout mCameraPreviewLayout;
    private ViewGroup mMainContent;
    private Button bEnterManually;
    private DeployCoreTask mDeployCoreTask;
    private ScanCardRequest mScanCardRequest;

    public InitLibraryFragment() {
        this.mScanCardRequest = ScanCardRequest.getDefault();
    }

    public InitLibraryFragment(ScanCardRequest scanCardRequest) {
        this.mScanCardRequest = scanCardRequest;
    }

    private void showLoader(boolean bl) {
        if (bl) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.hideSlow();
        }
    }

    private void subscribeToInitCore(Context object) {
        DeployCoreTask deployCoreTask;
        InitLibraryFragment initLibraryFragment = this;
        initLibraryFragment.showLoader(true);
        object = initLibraryFragment.mDeployCoreTask;
        if (object != null) {
            object.cancel(false);
        }
        object = deployCoreTask;
        object(this);
        this.mDeployCoreTask = object;
        deployCoreTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public void onAttach(@NonNull Context context) {
        InitLibraryFragment initLibraryFragment = this;
        super.onAttach(context);
        try {
            initLibraryFragment.mListener = (InteractionListener)initLibraryFragment.getActivity();
            return;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Parent must implement " + ScanCardFragment.InteractionListener.class.getSimpleName());
        }
    }

    @NonNull
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.paycardscanner_fragment_scan_card, viewGroup, false);
        InitLibraryFragment initLibraryFragment = this;
        this.mMainContent = (ViewGroup)layoutInflater.findViewById(R.id.payCardScanner_main_content);
        this.mProgressBar = (ProgressBarIndeterminate)layoutInflater.findViewById(R.id.payCardScanner_progress_bar);
        this.mCameraPreviewLayout = (CameraPreviewLayout)layoutInflater.findViewById(R.id.card_recognition_view);
        initLibraryFragment.bEnterManually = (Button)layoutInflater.findViewById(R.id.payCardScanner_bManual);
        initLibraryFragment.mProgressBar.setColor(this.mScanCardRequest.getMainColor());
        initLibraryFragment.bEnterManually.setOnClickListener(view -> {
            InteractionListener interactionListener = ((InitLibraryFragment)((Object)((Object)interactionListener))).mListener;
            if (interactionListener != null) {
                interactionListener.onScanCardCanceled(2);
            }
        });
        return layoutInflater;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        InitLibraryFragment initLibraryFragment = this;
        super.onViewCreated(view, bundle);
        initLibraryFragment.showLoader(false);
        initLibraryFragment.mMainContent.setVisibility(0);
        initLibraryFragment.mCameraPreviewLayout.setVisibility(0);
        initLibraryFragment.mCameraPreviewLayout.getSurfaceView().setVisibility(8);
        initLibraryFragment.mCameraPreviewLayout.setBackgroundColor(-16777216);
        initLibraryFragment.mCameraPreviewLayout.setMainColor(this.mScanCardRequest.getMainColor());
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        if (RecognitionAvailabilityChecker.doCheck(stringArray3.getContext()).isFailedOnCameraPermission()) {
            if (bundle == null) {
                String[] stringArray = stringArray3;
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                stringArray2[0] = "android.permission.CAMERA";
                stringArray.requestPermissions(stringArray3, 1);
            }
        } else {
            stringArray3.subscribeToInitCore((Context)stringArray3.getActivity());
        }
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        if (n == 1) {
            if (nArray.length > 0 && nArray[0] == 0) {
                Object object = object;
                ((InitLibraryFragment)((Object)object)).subscribeToInitCore((Context)object.getActivity());
            } else {
                Object object = ((InitLibraryFragment)((Object)object)).mListener;
                if (object != null) {
                    RecognitionUnavailableException recognitionUnavailableException;
                    Object object2 = object;
                    object = recognitionUnavailableException;
                    recognitionUnavailableException = new RecognitionUnavailableException(4);
                    object2.onInitLibraryFailed((Throwable)object);
                }
            }
        }
    }

    public void onStop() {
        InitLibraryFragment initLibraryFragment = this;
        super.onStop();
        DeployCoreTask deployCoreTask = initLibraryFragment.mDeployCoreTask;
        if (deployCoreTask != null) {
            deployCoreTask.cancel(false);
            this.mDeployCoreTask = null;
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mProgressBar = null;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    private static class DeployCoreTask
    extends AsyncTask<Void, Void, Throwable> {
        private final WeakReference<InitLibraryFragment> fragmentRef;
        @SuppressLint(value={"StaticFieldLeak"})
        private final Context appContext;

        DeployCoreTask(InitLibraryFragment initLibraryFragment) {
            this.fragmentRef = new WeakReference<InitLibraryFragment>(initLibraryFragment);
            this.appContext = initLibraryFragment.getContext().getApplicationContext();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Throwable doInBackground(Void ... voidArray) {
            block4: {
                try {
                    if (RecognitionAvailabilityChecker.doCheck(this.appContext).isFailed()) throw new RecognitionUnavailableException();
                }
                catch (RecognitionUnavailableException recognitionUnavailableException) {
                    return recognitionUnavailableException;
                }
                DeployCoreTask deployCoreTask = this;
                RecognitionCoreUtils.deployRecognitionCoreSync(deployCoreTask.appContext);
                if (!RecognitionCore.getInstance(deployCoreTask.appContext).isDeviceSupported()) break block4;
                return null;
            }
            throw new RecognitionUnavailableException();
        }

        protected void onPostExecute(@Nullable Throwable throwable) {
            DeployCoreTask deployCoreTask = initLibraryFragment;
            super.onPostExecute((Object)throwable);
            InitLibraryFragment initLibraryFragment = (InitLibraryFragment)((Object)deployCoreTask.fragmentRef.get());
            if (initLibraryFragment != null && initLibraryFragment.mProgressBar != null && initLibraryFragment.mListener != null) {
                initLibraryFragment.showLoader(false);
                if (throwable == null) {
                    initLibraryFragment.mListener.onInitLibraryComplete();
                } else {
                    initLibraryFragment.mListener.onInitLibraryFailed(throwable);
                }
                return;
            }
        }
    }

    public static interface InteractionListener {
        public void onScanCardCanceled(int var1);

        public void onInitLibraryFailed(Throwable var1);

        public void onInitLibraryComplete();
    }
}

