/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.TextUtils;
import android.transition.Fade;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import paycardscanner.camera.ScanManager;
import paycardscanner.camera.widget.CameraPreviewLayout;
import paycardscanner.intent.Card;
import paycardscanner.ndk.RecognitionResult;
import paycardscanner.sdk.R;
import paycardscanner.ui.ScanCardRequest;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ScanCardFragment
extends Fragment {
    private CameraPreviewLayout mCameraPreviewLayout;
    private Button bManual;
    private ViewGroup mMainContent;
    @Nullable
    private Menu toolbarMenu;
    boolean isFlashSupported = false;
    @Nullable
    private ScanManager mScanManager;
    private InteractionListener mListener;
    private ScanCardRequest mRequest;

    private void initView(View view2) {
        Button button;
        ScanCardFragment scanCardFragment = this;
        this.bManual = button = (Button)view2.findViewById(R.id.payCardScanner_bManual);
        button.setOnClickListener(view -> {
            if (view.isEnabled()) {
                view.setEnabled(false);
                if (this.mListener != null) {
                    ScanCardFragment scanCardFragment = this;
                    scanCardFragment.hide((View)scanCardFragment.bManual);
                    scanCardFragment.mListener.onScanCardCanceled(2);
                }
            }
        });
        scanCardFragment.bManual.setTextColor(this.mRequest.getMainColor());
        button = scanCardFragment.bManual;
        int n = scanCardFragment.mRequest.getManualInputButtonLabel() == null ? 8 : 0;
        ScanCardFragment scanCardFragment2 = this;
        button.setVisibility(n);
        scanCardFragment2.bManual.setText((CharSequence)this.mRequest.getManualInputButtonLabel());
        scanCardFragment2.bManual.setEnabled(true);
        button = (TextView)view2.findViewById(R.id.tvHint);
        button.setText((CharSequence)this.mRequest.getHint());
        n = this.mRequest.getHint() != null ? 0 : 8;
        button.setVisibility(n);
        button = (TextView)view2.findViewById(R.id.tvBottomHint);
        button.setText((CharSequence)this.mRequest.getBottomHint());
        n = this.mRequest.getBottomHint() != null ? 0 : 8;
        button.setVisibility(n);
        this.initToolbar(view2);
    }

    private void initToolbar(View view) {
        view = (Toolbar)view.findViewById(R.id.payCardScanner_toolbar);
        String string = this.mRequest.getTitle() == null ? "" : this.mRequest.getTitle();
        view.setTitle((CharSequence)string);
        AppCompatActivity appCompatActivity = (AppCompatActivity)this.getActivity();
        appCompatActivity.setSupportActionBar((Toolbar)view);
        appCompatActivity.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        appCompatActivity.getSupportActionBar().setDisplayShowHomeEnabled(true);
        view.setNavigationIcon(R.drawable.paycardscanner_ic_close);
        view.setNavigationOnClickListener(object -> {
            object = this.mListener;
            if (object != null) {
                object.onScanCardCanceled(1);
            }
            this.getActivity().onBackPressed();
        });
        view.setOnMenuItemClickListener(menuItem -> {
            if (menuItem.getItemId() == R.id.flash && (this = ((ScanCardFragment)((Object)((Object)this))).mScanManager) != null) {
                ((ScanManager)this).toggleFlash();
            }
            return false;
        });
    }

    private void showMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(0);
        scanCardFragment.mCameraPreviewLayout.setVisibility(0);
    }

    private void hideMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(4);
        scanCardFragment.mCameraPreviewLayout.setVisibility(4);
    }

    private void finishWithError(Exception exception) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFailed(exception);
        }
    }

    private void finishWithResult(Card card, @Nullable byte[] byArray) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFinished(card, byArray);
        }
    }

    private void vibrate() {
        if ((scanCardFragment = scanCardFragment.getContext()) == null) {
            return;
        }
        ScanCardFragment scanCardFragment = (Vibrator)scanCardFragment.getSystemService("vibrator");
        if (Build.VERSION.SDK_INT >= 26) {
            scanCardFragment.vibrate(VibrationEffect.createOneShot((long)200L, (int)-1));
        } else {
            scanCardFragment.vibrate(200L);
        }
    }

    private void hide(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            Fade fade;
            View view2 = view;
            ScanCardFragment scanCardFragment = this = fade;
            scanCardFragment();
            scanCardFragment.setDuration(900L);
            fade.addTarget(view);
            TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)view2.getParent()), (Transition)this);
            view2.setVisibility(8);
        } else {
            view.animate().alpha(0.0f).withEndAction(() -> view.setVisibility(8)).setDuration(900L).start();
        }
    }

    public void onAttach(@NonNull Context context) {
        ScanCardFragment scanCardFragment = this;
        super.onAttach(context);
        try {
            scanCardFragment.mListener = (InteractionListener)scanCardFragment.getActivity();
            return;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Parent must implement " + InteractionListener.class.getSimpleName());
        }
    }

    public void onCreate(Bundle bundle) {
        ScanCardFragment scanCardFragment = this;
        super.onCreate(bundle);
        scanCardFragment.mRequest = null;
        if (scanCardFragment.getArguments() != null) {
            this.mRequest = (ScanCardRequest)this.getArguments().getParcelable("payCardScanner.ui.ScanCardActivity.SCAN_CARD_REQUEST");
        }
        if (this.mRequest == null) {
            this.mRequest = ScanCardRequest.getDefault();
        }
    }

    public Animation onCreateAnimation(int n, boolean bl, int n2) {
        Animation animation = new Animation(){};
        animation.setDuration(0L);
        return animation;
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.paycardscanner_fragment_scan_card, viewGroup, false);
        ScanCardFragment scanCardFragment = this;
        this.mCameraPreviewLayout = (CameraPreviewLayout)layoutInflater.findViewById(R.id.card_recognition_view);
        this.mMainContent = (ViewGroup)layoutInflater.findViewById(R.id.payCardScanner_main_content);
        scanCardFragment.initView((View)layoutInflater);
        scanCardFragment.showMainContent();
        return layoutInflater;
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        ScanManager.Callbacks callbacks;
        ScanManager scanManager;
        ScanCardFragment scanCardFragment = this;
        super.onActivityCreated(bundle);
        int n = 1;
        if (scanCardFragment.mRequest.isScanCardHolderEnabled()) {
            n = 5;
        }
        if (this.mRequest.isScanExpirationDateEnabled()) {
            n |= 2;
        }
        if (this.mRequest.isGrabCardImageEnabled()) {
            n |= 8;
        }
        ScanManager scanManager2 = scanManager;
        ScanCardFragment scanCardFragment2 = this;
        FragmentActivity fragmentActivity = scanCardFragment2.getActivity();
        CameraPreviewLayout cameraPreviewLayout = scanCardFragment2.mCameraPreviewLayout;
        ScanManager.Callbacks callbacks2 = callbacks;
        callbacks = new ScanManager.Callbacks(){
            static final /* synthetic */ boolean $assertionsDisabled;
            private byte[] mLastCardImage = null;

            @Nullable
            private byte[] compressCardImage(Bitmap bitmap) {
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                return bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)byteArrayOutputStream2) ? byteArrayOutputStream2.toByteArray() : null;
            }

            /*
             * WARNING - void declaration
             */
            private /* synthetic */ void lambda$onTorchStatusChanged$0(MenuItem menuItem, boolean bl) {
                void var2_5;
                2 this_;
                this_ = this_.ScanCardFragment.this.getContext();
                if (bl) {
                    int n = R.drawable.paycardscanner_ic_flash_on;
                } else {
                    int n = R.drawable.paycardscanner_ic_flash_off;
                }
                menuItem.setIcon(ContextCompat.getDrawable((Context)this_, (int)var2_5));
            }

            static {
                $assertionsDisabled = ScanCardFragment.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public void onCameraOpened(Camera.Parameters parameters) {
                ScanCardFragment scanCardFragment = ScanCardFragment.this;
                boolean bl = parameters.getSupportedFlashModes() != null && !parameters.getSupportedFlashModes().isEmpty();
                scanCardFragment.isFlashSupported = bl;
                if (ScanCardFragment.this.getView() == null) {
                    return;
                }
                2 v0 = this;
                v0.ScanCardFragment.this.mCameraPreviewLayout.setBackgroundDrawable(null);
                ScanCardFragment scanCardFragment2 = v0.ScanCardFragment.this;
                scanCardFragment2.setHasOptionsMenu(scanCardFragment2.isFlashSupported);
            }

            @Override
            public void onOpenCameraError(Exception exception) {
                2 v0 = this;
                v0.ScanCardFragment.this.hideMainContent();
                v0.ScanCardFragment.this.finishWithError(exception);
            }

            @Override
            public void onRecognitionComplete(RecognitionResult object) {
                Object object2;
                if (((RecognitionResult)object).isFirst()) {
                    object2 = card2.ScanCardFragment.this.mScanManager;
                    if (object2 != null) {
                        ((ScanManager)object2).freezeCameraPreview();
                    }
                    if (card2.ScanCardFragment.this.mRequest.isVibrationEnabled()) {
                        card2.ScanCardFragment.this.vibrate();
                    }
                }
                if (((RecognitionResult)object).isFinal()) {
                    Card card;
                    if (TextUtils.isEmpty((CharSequence)((RecognitionResult)object).getDate())) {
                        object2 = null;
                    } else {
                        if (!$assertionsDisabled && ((RecognitionResult)object).getDate() == null) {
                            throw new AssertionError();
                        }
                        object2 = ((RecognitionResult)object).getDate().substring(0, 2) + '/' + ((RecognitionResult)object).getDate().substring(2);
                    }
                    2 v0 = card2;
                    Card card2 = card;
                    RecognitionResult recognitionResult = object;
                    object = recognitionResult.getNumber();
                    card = new Card((String)object, recognitionResult.getName(), (String)object2);
                    object = v0.mLastCardImage;
                    v0.mLastCardImage = null;
                    v0.ScanCardFragment.this.finishWithResult(card2, (byte[])object);
                }
            }

            @Override
            public void onCardImageReceived(Bitmap bitmap) {
                this.mLastCardImage = this.compressCardImage(bitmap);
            }

            @Override
            public void onFpsReport(String string) {
            }

            @Override
            public void onAutoFocusMoving(boolean bl, String string) {
            }

            @Override
            public void onAutoFocusComplete(boolean bl, String string) {
            }

            @Override
            public void onTorchStatusChanged(boolean bl) {
                Object object = ScanCardFragment.this.toolbarMenu;
                object = object != null ? object.findItem(R.id.flash) : null;
                if (ScanCardFragment.this.getContext() != null && object != null) {
                    Handler handler;
                    Handler handler2 = handler;
                    handler2(Looper.getMainLooper());
                    handler.post(() -> this.lambda$onTorchStatusChanged$0((MenuItem)object, bl));
                }
            }
        };
        scanManager = new ScanManager(n, (Context)fragmentActivity, cameraPreviewLayout, callbacks2);
        this.mScanManager = scanManager2;
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
    }

    public void onDetach() {
        super.onDetach();
    }

    public void onResume() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onResume();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onResume();
        }
    }

    public void onPause() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onPause();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onPause();
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater menuInflater) {
        menuInflater.inflate(R.menu.paycardscanner_menu, menu2);
        this.toolbarMenu = menu2;
        super.onCreateOptionsMenu(menu2, menuInflater);
    }

    public static interface InteractionListener {
        public void onScanCardCanceled(int var1);

        public void onScanCardFailed(Exception var1);

        public void onScanCardFinished(Card var1, byte[] var2);
    }
}

