/*
 * Decompiled with CFR 0.152.
 */
package paycardscanner.utils;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CardUtils {
    public static String prettyPrintCardNumber(@Nullable CharSequence charSequence) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(20);
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (n == 16) {
                if (i != 0 && i % 4 == 0) {
                    stringBuilder2.append('\u00a0');
                }
            } else if (n == 15 && (i == 4 || i == 10)) {
                stringBuilder2.append('\u00a0');
            }
            stringBuilder2.append(charSequence.charAt(i));
        }
        return stringBuilder2.toString();
    }

    public static String getCardNumberRedacted(@Nullable String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 16) {
            String string2 = string;
            string = string2.substring(0, 6);
            String string3 = string2.substring(string2.length() - 2);
            StringBuilder stringBuilder = new StringBuilder(string + "********" + string3);
            stringBuilder.insert(4, " ");
            stringBuilder.insert(9, " ");
            stringBuilder.insert(14, " ");
            return stringBuilder.toString();
        }
        if (string.length() == 15) {
            String string4 = string;
            string = string4.substring(0, 6);
            String string5 = string4.substring(string4.length() - 1);
            StringBuilder stringBuilder = new StringBuilder(string + "********" + string5);
            stringBuilder.insert(4, " ");
            stringBuilder.insert(11, " ");
            return stringBuilder.toString();
        }
        return "";
    }
}

