/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.DSLKt;
import com.almasb.fxgl.core.util.Predicate;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.Spawns;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.IDComponent;
import com.almasb.fxgl.entity.components.IrremovableComponent;
import com.almasb.fxgl.entity.components.TimeComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 _2\u00020\u0001:\u0001_B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001f\u0010\u001d\u001a\u00020\u001b2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001f\"\u00020\u0005\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0019J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0006\u0010*\u001a\u00020\u001bJ\b\u0010+\u001a\u00020\u001bH\u0002J\u0016\u0010,\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0005002\u0006\u0010\u001c\u001a\u00020\u00052\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u001c\u001a\u00020\u0005J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u00105\u001a\u000206J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09J-\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u001a\u0010<\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030=0\u001f\"\u0006\u0012\u0002\b\u00030=\u00a2\u0006\u0002\u0010>J\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000502J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010B\u001a\u00020CJ\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0005002\u0006\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020GJ\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\u0005002\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000502J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020\u0005002\n\u00108\u001a\u0006\u0012\u0002\b\u00030=J\u0014\u0010I\u001a\u00020\u00052\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000502J\u0012\u0010I\u001a\u00020\u00052\n\u00108\u001a\u0006\u0012\u0002\b\u00030=J\u001a\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0005002\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000502J\u0018\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0005002\n\u00108\u001a\u0006\u0012\u0002\b\u00030=J1\u0010K\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u00052\u001a\u0010<\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030=0\u001f\"\u0006\u0012\u0002\b\u00030=H\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020\u0005H\u0002J\u0010\u0010O\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020\u0005H\u0002J\u000e\u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020RJ\u001f\u0010S\u001a\u00020\u001b2\u0012\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001f\"\u00020\u0005\u00a2\u0006\u0002\u0010 J\u0014\u0010S\u001a\u00020\u001b2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00050UJ\u000e\u0010V\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010W\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000fJ\u000e\u0010X\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010Y\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020[J\u000e\u0010\\\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0010J\u0016\u0010\\\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.J\u0016\u0010\\\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00102\u0006\u00105\u001a\u000206J\u001e\u0010\\\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00102\u0006\u0010]\u001a\u00020R2\u0006\u0010^\u001a\u00020RR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR6\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\u000ej\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000ej\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/almasb/fxgl/entity/GameWorld;", "", "()V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "getEntities", "()Ljava/util/ArrayList;", "entitiesCopy", "", "getEntitiesCopy", "()Ljava/util/List;", "entityFactories", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/EntityFactory;", "", "Lkotlin/collections/HashMap;", "entitySpawners", "Lcom/almasb/fxgl/entity/EntitySpawner;", "updateList", "Lcom/almasb/fxgl/core/collection/Array;", "waitingList", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "worldListeners", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "add", "", "entity", "addEntities", "entitiesToAdd", "", "([Lcom/almasb/fxgl/entity/Entity;)V", "addEntity", "addEntityFactory", "entityFactory", "addWorldListener", "listener", "canRemove", "", "checkDuplicateSpawners", "entityName", "clear", "clearLevel", "create", "data", "Lcom/almasb/fxgl/entity/SpawnData;", "getClosestEntity", "Ljava/util/Optional;", "filter", "Lcom/almasb/fxgl/core/util/Predicate;", "getCollidingEntities", "getEntitiesAt", "position", "Ljavafx/geometry/Point2D;", "getEntitiesByComponent", "type", "Ljava/lang/Class;", "Lcom/almasb/fxgl/entity/component/Component;", "getEntitiesByType", "types", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "getEntityByID", "name", "id", "", "getRandom", "getSingleton", "getSingletonOptional", "isOneOfTypes", "(Lcom/almasb/fxgl/entity/Entity;[Ljava/lang/Enum;)Z", "notifyEntityAdded", "e", "notifyEntityRemoved", "onUpdate", "tpf", "", "removeEntities", "entitiesToRemove", "", "removeEntity", "removeEntityFactory", "removeWorldListener", "setLevel", "level", "Lcom/almasb/fxgl/entity/level/Level;", "spawn", "x", "y", "Companion", "fxgl-entity"})
public final class GameWorld {
    private final Array<Entity> updateList = new Array();
    private final UnorderedArray<Entity> waitingList = new UnorderedArray(0, 1, null);
    @NotNull
    private final ArrayList<Entity> entities = new ArrayList();
    private final Array<EntityWorldListener> worldListeners;
    private final HashMap<EntityFactory, List<String>> entityFactories;
    private final HashMap<String, EntitySpawner> entitySpawners;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ArrayList<Entity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final List<Entity> getEntitiesCopy() {
        return new ArrayList(this.entities);
    }

    public final void addEntity(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        boolean bl = !entity.isActive();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Entity is already attached to world";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.waitingList.add((Object)entity);
        this.entities.add(entity);
        this.add(entity);
    }

    public final void addEntities(Entity ... entitiesToAdd) {
        Intrinsics.checkParameterIsNotNull((Object)entitiesToAdd, (String)"entitiesToAdd");
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    private final void add(Entity entity) {
        entity.init(this);
        this.notifyEntityAdded(entity);
    }

    public final void removeEntity(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!entity.isActive()) {
            log.warning("Attempted to remove entity which is not active");
            return;
        }
        if (!this.canRemove(entity)) {
            return;
        }
        boolean bl = entity.getWorld() == this;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Attempted to remove entity not attached to this world";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.entities.remove(entity);
        entity.markForRemoval();
        this.notifyEntityRemoved(entity);
    }

    public final void removeEntities(Entity ... entitiesToRemove) {
        Intrinsics.checkParameterIsNotNull((Object)entitiesToRemove, (String)"entitiesToRemove");
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    public final void removeEntities(@NotNull Collection<? extends Entity> entitiesToRemove) {
        Intrinsics.checkParameterIsNotNull(entitiesToRemove, (String)"entitiesToRemove");
        for (Entity entity : entitiesToRemove) {
            this.removeEntity(entity);
        }
    }

    private final boolean canRemove(Entity entity) {
        return !entity.hasComponent(IrremovableComponent.class);
    }

    public final void onUpdate(double tpf) {
        this.updateList.addAll((Array)this.waitingList);
        this.waitingList.clear();
        Iterator iterator = this.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Double tpfRatio2;
            Entity e;
            Entity entity = e = (Entity)it.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"e");
            if (!entity.isActive()) {
                e.clean();
                it.remove();
                continue;
            }
            Double d = tpfRatio2 = e.getComponentOptional(TimeComponent.class).map(onUpdate.tpfRatio.1.INSTANCE).orElse(1.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"tpfRatio");
            e.update(tpf * d);
        }
    }

    public final void clear() {
        log.debug("Clearing game world");
        this.waitingList.clear();
        GameWorld gameWorld = this;
        boolean bl = false;
        boolean bl2 = false;
        GameWorld $this$run = gameWorld;
        boolean bl3 = false;
        Iterator iterator = $this$run.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Entity e;
            Entity entity = e = (Entity)it.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"e");
            if (!entity.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterable $this$forEach$iv = this.getEntitiesCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity e = (Entity)element$iv;
            boolean bl4 = false;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
        }
        this.entities.clear();
        this.entityFactories.clear();
        this.entitySpawners.clear();
    }

    public final void addWorldListener(@NotNull EntityWorldListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.worldListeners.add((Object)listener);
    }

    public final void removeWorldListener(@NotNull EntityWorldListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.worldListeners.removeValueByIdentity((Object)listener);
    }

    private final void notifyEntityAdded(Entity e) {
        Iterable $this$forEach$iv = (Iterable)this.worldListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityAdded(e);
        }
    }

    private final void notifyEntityRemoved(Entity e) {
        Iterable $this$forEach$iv = (Iterable)this.worldListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityRemoved(e);
        }
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        this.clearLevel();
        log.debug("Setting level: " + level);
        Iterable $this$forEach$iv = level.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            this.addEntity(it);
        }
    }

    private final void clearLevel() {
        log.debug("Clearing removable entities");
        this.waitingList.clear();
        GameWorld gameWorld = this;
        boolean bl = false;
        boolean bl2 = false;
        GameWorld $this$run = gameWorld;
        boolean bl3 = false;
        Iterator iterator = $this$run.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Entity e;
            Entity entity = e = (Entity)it.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"e");
            if (!$this$run.canRemove(entity)) continue;
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterator<Entity> iterator2 = this.entities.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, (String)"entities.iterator()");
        Iterator<Entity> it2 = iterator2;
        while (it2.hasNext()) {
            Entity e;
            Intrinsics.checkExpressionValueIsNotNull((Object)it2.next(), (String)"it.next()");
            if (!this.canRemove(e)) continue;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
            it2.remove();
        }
    }

    public final void addEntityFactory(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull((Object)entityFactory, (String)"entityFactory");
        boolean bl = false;
        ArrayList entityNames = new ArrayList();
        ReflectionUtils.findMethodsMapToFunctions((Object)entityFactory, Spawns.class, EntitySpawner.class).forEach((BiConsumer)new BiConsumer<Spawns, EntitySpawner>(this, entityFactory, entityNames){
            final /* synthetic */ GameWorld this$0;
            final /* synthetic */ EntityFactory $entityFactory;
            final /* synthetic */ ArrayList $entityNames;

            public final void accept(Spawns annotation, EntitySpawner entitySpawner) {
                CharSequence charSequence = annotation.value();
                String string = ",";
                int n = 0;
                string = new Regex(string);
                n = 0;
                boolean bl = false;
                List entityAliases = string.split(charSequence, n);
                Iterable $this$forEach$iv = entityAliases;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String entityName = (String)element$iv;
                    boolean bl2 = false;
                    GameWorld.access$checkDuplicateSpawners(this.this$0, this.$entityFactory, entityName);
                    GameWorld.access$getEntitySpawners$p(this.this$0).put(entityName, entitySpawner);
                    this.$entityNames.add(entityName);
                }
            }
            {
                this.this$0 = gameWorld;
                this.$entityFactory = entityFactory;
                this.$entityNames = arrayList;
            }
        });
        this.entityFactories.put(entityFactory, entityNames);
    }

    private final void checkDuplicateSpawners(EntityFactory entityFactory, String entityName) {
        if (this.entitySpawners.containsKey(entityName)) {
            Object v1;
            block2: {
                Set<Map.Entry<EntityFactory, List<String>>> set = this.entityFactories.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"entityFactories.entries");
                Iterable iterable = set;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl3 = false;
                    if (!((List)it.getValue()).contains(entityName)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            Map.Entry factory = v1;
            throw (Throwable)new IllegalArgumentException("Duplicated @Spawns(" + entityName + ") in " + entityFactory + ". Already exists in " + factory);
        }
    }

    public final void removeEntityFactory(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull((Object)entityFactory, (String)"entityFactory");
        List<String> list = this.entityFactories.remove(entityFactory);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.entitySpawners.remove(it);
            }
        }
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        return this.spawn(entityName, 0.0, 0.0);
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull Point2D position) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.spawn(entityName, position.getX(), position.getY());
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, double x, double y) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        return this.spawn(entityName, new SpawnData(x, y));
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Entity entity = this.create(entityName, data);
        this.addEntity(entity);
        return entity;
    }

    @NotNull
    public final Entity create(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Map map = this.entityFactories;
        boolean bl = false;
        boolean bl2 = !map.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "No EntityFactory was added! Call gameWorld.addEntityFactory()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntitySpawner entitySpawner = this.entitySpawners.get(entityName);
        if (entitySpawner == null) {
            throw (Throwable)new IllegalArgumentException("No EntityFactory has a method annotated @Spawns(" + entityName + ')');
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)entitySpawner, (String)"entitySpawners.get(entit\u2026ed @Spawns($entityName)\")");
        EntitySpawner spawner = entitySpawner;
        if (!data.hasKey("type")) {
            data.put("type", entityName);
        }
        Object object = DSLKt.tryCatchRoot((Function0)((Function0)new Function0<Entity>(spawner, data){
            final /* synthetic */ EntitySpawner $spawner;
            final /* synthetic */ SpawnData $data;

            public final Entity invoke() {
                Object object = this.$spawner.apply(this.$data);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"spawner.apply(data)");
                return (Entity)object;
            }
            {
                this.$spawner = entitySpawner;
                this.$data = spawnData;
                super(0);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tryCatchRoot { spawner.apply(data) }");
        return (Entity)object;
    }

    @NotNull
    public final Entity getSingleton(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return this.getSingleton((Predicate<Entity>)((Predicate)new Predicate<Entity>(type){
            final /* synthetic */ Enum $type;

            public final boolean test(Entity it) {
                return it.isType(this.$type);
            }
            {
                this.$type = enum_;
            }
        }));
    }

    @NotNull
    public final Entity getSingleton(@NotNull Predicate<Entity> predicate) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable iterable = this.entities;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Entity it = (Entity)t;
                boolean bl3 = false;
                if (!predicate.test((Object)it)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Entity entity = v0;
        if (entity == null) {
            throw (Throwable)new NoSuchElementException("No entity found satisfying the predicate");
        }
        return entity;
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return this.getSingletonOptional((Predicate<Entity>)((Predicate)new Predicate<Entity>(type){
            final /* synthetic */ Enum $type;

            public final boolean test(Entity it) {
                return it.isType(this.$type);
            }
            {
                this.$type = enum_;
            }
        }));
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Predicate<Entity> predicate) {
        Object t;
        block1: {
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable iterable = this.entities;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Entity it = (Entity)t2;
                boolean bl3 = false;
                if (!predicate.test((Object)it)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(enti\u2026d { predicate.test(it) })");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Optional optional = FXGLMath.random(this.getEntitiesByType(type));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"FXGLMath.random(getEntitiesByType(type))");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Predicate<Entity> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Optional optional = FXGLMath.random(this.getEntitiesFiltered(predicate));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"FXGLMath.random(getEntitiesFiltered(predicate))");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByComponent(@NotNull Class<? extends Component> type) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.hasComponent(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!predicate.test((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Enum<?>[] enumArray = types;
        boolean bl = false;
        if (enumArray.length == 0) {
            return this.getEntitiesCopy();
        }
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl2 = false;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        boolean bl;
        block1: {
            Enum<?>[] $this$any$iv = types;
            boolean $i$f$any = false;
            Enum<?>[] enumArray = $this$any$iv;
            int n = enumArray.length;
            for (int i = 0; i < n; ++i) {
                Enum<?> element$iv;
                Enum<?> it = element$iv = enumArray[i];
                boolean bl2 = false;
                if (!entity.isType(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.getBoundingBoxComponent().isWithin(selection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(it.isColliding(entity) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesAt(@NotNull Point2D position) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPosition(), (Object)position)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<Entity> getClosestEntity(@NotNull Entity entity, @NotNull Predicate<Entity> filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(filter.test((Object)it) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(entity){
            final /* synthetic */ Entity $entity$inlined;
            {
                this.$entity$inlined = entity;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Entity it = (Entity)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(this.$entity$inlined.distance(it));
                it = (Entity)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = this.$entity$inlined.distance(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        Optional<Object> optional = Optional.ofNullable(CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(\n   \u2026 .firstOrNull()\n        )");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getEntityByID(@NotNull String name, int id) {
        Object t;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable iterable = this.getEntitiesByComponent(IDComponent.class);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Entity it = (Entity)t2;
                boolean bl3 = false;
                IDComponent idComponent = it.getComponent(IDComponent.class);
                if (!(Intrinsics.areEqual((Object)idComponent.getName(), (Object)name) && idComponent.getId() == id)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(\n   \u2026              }\n        )");
        return optional;
    }

    public GameWorld() {
        log.debug("Game world initialized");
        this.worldListeners = new Array();
        GameWorld gameWorld = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        gameWorld.entityFactories = hashMap;
        gameWorld = this;
        bl = false;
        hashMap = new HashMap();
        gameWorld.entitySpawners = hashMap;
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("GameWorld");
    }

    public static final /* synthetic */ void access$checkDuplicateSpawners(GameWorld $this, EntityFactory entityFactory, String entityName) {
        $this.checkDuplicateSpawners(entityFactory, entityName);
    }

    public static final /* synthetic */ HashMap access$getEntitySpawners$p(GameWorld $this) {
        return $this.entitySpawners;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/entity/GameWorld$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl-entity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

