/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.components;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.SerializableComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.SAT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@CoreComponent
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000eJ\u0018\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J8\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020#H\u0002J\u0006\u00106\u001a\u00020*J\b\u00107\u001a\u00020\u0015H\u0002J\b\u00108\u001a\u00020\u0015H\u0002J\b\u00109\u001a\u00020\u0015H\u0002J\b\u0010:\u001a\u00020\u0015H\u0002J\u0006\u0010;\u001a\u00020\u0015J\u0006\u0010<\u001a\u00020\u0015J\u0006\u0010=\u001a\u00020\u0015J\u0006\u0010>\u001a\u00020\u0015J\u0006\u0010?\u001a\u00020\u0015J\u0006\u0010@\u001a\u00020\u0015J\u0006\u0010A\u001a\u00020\u0015J\u0006\u0010B\u001a\u00020\u0015J\u0006\u0010C\u001a\u00020DJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012J\u000e\u0010F\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020IJ&\u0010G\u001a\u00020-2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u0015J\u000e\u0010N\u001a\u00020-2\u0006\u0010H\u001a\u00020IJ&\u0010N\u001a\u00020-2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u0015J\u0006\u0010O\u001a\u00020DJ\u0006\u0010P\u001a\u00020DJ\u0006\u0010Q\u001a\u00020DJ\u0006\u0010R\u001a\u00020DJ\u0006\u0010S\u001a\u00020DJ\u0006\u0010T\u001a\u00020DJ\b\u0010U\u001a\u00020*H\u0016J\b\u0010V\u001a\u00020*H\u0016J\u0016\u0010W\u001a\u00020I2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0015J\u0010\u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020ZH\u0016J\u000e\u0010[\u001a\u00020*2\u0006\u0010\\\u001a\u00020]J\b\u0010^\u001a\u00020]H\u0016J\u0006\u0010_\u001a\u00020DJ\u0010\u0010`\u001a\u00020*2\u0006\u0010Y\u001a\u00020ZH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/SerializableComponent;", "boxes", "", "Lcom/almasb/fxgl/physics/HitBox;", "([Lcom/almasb/fxgl/physics/HitBox;)V", "centerLocal", "Ljavafx/geometry/Point2D;", "getCenterLocal", "()Ljavafx/geometry/Point2D;", "centerWorld", "getCenterWorld", "dummy", "Lcom/almasb/fxgl/physics/CollisionResult;", "height", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "hitBoxes", "Ljavafx/collections/ObservableList;", "kotlin.jvm.PlatformType", "maxXLocal", "", "getMaxXLocal", "()D", "maxXWorld", "maxYLocal", "getMaxYLocal", "maxYWorld", "minXLocal", "minXWorld", "minYLocal", "minYWorld", "onHitBoxChange", "Ljavafx/collections/ListChangeListener;", "transform", "Lcom/almasb/fxgl/entity/components/TransformComponent;", "getTransform", "()Lcom/almasb/fxgl/entity/components/TransformComponent;", "setTransform", "(Lcom/almasb/fxgl/entity/components/TransformComponent;)V", "width", "addHitBox", "", "hitBox", "checkCollision", "", "other", "result", "box1", "box2", "angle1", "angle2", "t1", "t2", "clearHitBoxes", "computeHeight", "computeMinXLocal", "computeMinYLocal", "computeWidth", "getHeight", "getMaxXWorld", "getMaxYWorld", "getMinXLocal", "getMinXWorld", "getMinYLocal", "getMinYWorld", "getWidth", "heightProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "hitBoxesProperty", "isCollidingWith", "isOutside", "bounds", "Ljavafx/geometry/Rectangle2D;", "minX", "minY", "maxX", "maxY", "isWithin", "maxXWorldProperty", "maxYWorldProperty", "minXLocalProperty", "minXWorldProperty", "minYLocalProperty", "minYWorldProperty", "onAdded", "onRemoved", "range", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "removeHitBox", "name", "", "toString", "widthProperty", "write", "fxgl-entity"})
public final class BoundingBoxComponent
extends Component
implements SerializableComponent {
    @NotNull
    public TransformComponent transform;
    private final ObservableList<HitBox> hitBoxes;
    private final ReadOnlyDoubleWrapper width;
    private final ReadOnlyDoubleWrapper height;
    private final ReadOnlyDoubleWrapper minXLocal;
    private final ReadOnlyDoubleWrapper minYLocal;
    private final ReadOnlyDoubleWrapper minXWorld;
    private final ReadOnlyDoubleWrapper minYWorld;
    private final ReadOnlyDoubleWrapper maxXWorld;
    private final ReadOnlyDoubleWrapper maxYWorld;
    private final ListChangeListener<HitBox> onHitBoxChange;
    private final CollisionResult dummy;

    @NotNull
    public final TransformComponent getTransform() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        return transformComponent;
    }

    public final void setTransform(@NotNull TransformComponent transformComponent) {
        Intrinsics.checkParameterIsNotNull((Object)transformComponent, (String)"<set-?>");
        this.transform = transformComponent;
    }

    public final double getMaxXLocal() {
        return this.getWidth();
    }

    public final double getMaxYLocal() {
        return this.getHeight();
    }

    @NotNull
    public final Point2D getCenterLocal() {
        return new Point2D(this.getWidth() / (double)2, this.getHeight() / (double)2);
    }

    @NotNull
    public final Point2D getCenterWorld() {
        Point2D point2D = this.getCenterLocal().add(this.getMinXWorld(), this.getMinYWorld());
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"centerLocal.add(getMinXWorld(), getMinYWorld())");
        return point2D;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minXLocalProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minXLocal.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"minXLocal.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinXLocal() {
        Double d = this.minXLocal.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"minXLocal.value");
        return d;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minYLocalProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minYLocal.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"minYLocal.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinYLocal() {
        Double d = this.minYLocal.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"minYLocal.value");
        return d;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minXWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minXWorld.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"minXWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minYWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minYWorld.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"minYWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty maxXWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.maxXWorld.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"maxXWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty maxYWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.maxYWorld.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"maxYWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinXWorld() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        return transformComponent.getX() + this.getMinXLocal();
    }

    public final double getMinYWorld() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        return transformComponent.getY() + this.getMinYLocal();
    }

    public final double getMaxXWorld() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        return transformComponent.getX() + this.getMinXLocal() + this.getWidth();
    }

    public final double getMaxYWorld() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        return transformComponent.getY() + this.getMinYLocal() + this.getHeight();
    }

    @Override
    public void onAdded() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        this.minXWorld.bind((ObservableValue)this.minXLocal.add((ObservableNumberValue)transformComponent.xProperty()));
        TransformComponent transformComponent2 = this.transform;
        if (transformComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        this.minYWorld.bind((ObservableValue)this.minYLocal.add((ObservableNumberValue)transformComponent2.yProperty()));
        this.maxXWorld.bind((ObservableValue)this.minXWorld.add((ObservableNumberValue)this.width));
        this.maxYWorld.bind((ObservableValue)this.minYWorld.add((ObservableNumberValue)this.height));
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            TransformComponent transformComponent3 = this.transform;
            if (transformComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
            }
            it.bindXY(transformComponent3);
        }
    }

    @Override
    public void onRemoved() {
        this.hitBoxes.removeListener(this.onHitBoxChange);
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            it.unbind();
        }
        this.minXWorld.unbind();
        this.minYWorld.unbind();
        this.maxXWorld.unbind();
        this.maxYWorld.unbind();
    }

    @NotNull
    public final ObservableList<HitBox> hitBoxesProperty() {
        ObservableList observableList = FXCollections.unmodifiableObservableList(this.hitBoxes);
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"FXCollections.unmodifiableObservableList(hitBoxes)");
        return observableList;
    }

    public final void addHitBox(@NotNull HitBox hitBox) {
        Intrinsics.checkParameterIsNotNull((Object)hitBox, (String)"hitBox");
        this.hitBoxes.add((Object)hitBox);
    }

    public final void removeHitBox(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.hitBoxes.removeIf((Predicate)new Predicate<HitBox>(name){
            final /* synthetic */ String $name;

            public final boolean test(HitBox h) {
                HitBox hitBox = h;
                Intrinsics.checkExpressionValueIsNotNull((Object)hitBox, (String)"h");
                return Intrinsics.areEqual((Object)hitBox.getName(), (Object)this.$name);
            }
            {
                this.$name = string;
            }
        });
    }

    public final void clearHitBoxes() {
        this.hitBoxes.clear();
    }

    public final double getWidth() {
        Double d = this.width.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"width.value");
        return d;
    }

    @NotNull
    public final ReadOnlyDoubleProperty widthProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.width.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"width.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getHeight() {
        Double d = this.height.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"height.value");
        return d;
    }

    @NotNull
    public final ReadOnlyDoubleProperty heightProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.height.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"height.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeWidth() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Bounds bounds = v1.getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"it.bounds");
            Double d = bounds.getMaxX() - this.getMinXLocal();
            collection.add(d);
        }
        Double d = CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return d != null ? d : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeHeight() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Bounds bounds = v1.getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"it.bounds");
            Double d = bounds.getMaxY() - this.getMinYLocal();
            collection.add(d);
        }
        Double d = CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return d != null ? d : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeMinXLocal() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Double d = v1.getMinX();
            collection.add(d);
        }
        Double d = CollectionsKt.min((Iterable)((List)destination$iv$iv));
        return d != null ? d : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeMinYLocal() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Double d = v1.getMinY();
            collection.add(d);
        }
        Double d = CollectionsKt.min((Iterable)((List)destination$iv$iv));
        return d != null ? d : 0.0;
    }

    public final boolean isCollidingWith(@NotNull BoundingBoxComponent other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.checkCollision(other, this.dummy);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkCollision(@NotNull BoundingBoxComponent other, @NotNull CollisionResult result) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        int n = 0;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"hitBoxes");
        int n2 = ((Collection)observableList).size();
        while (n < n2) {
            void i;
            HitBox box1 = (HitBox)this.hitBoxes.get((int)i);
            int n3 = 0;
            ObservableList<HitBox> observableList2 = other.hitBoxes;
            Intrinsics.checkExpressionValueIsNotNull(observableList2, (String)"other.hitBoxes");
            int n4 = ((Collection)observableList2).size();
            while (n3 < n4) {
                void j;
                HitBox box2 = (HitBox)other.hitBoxes.get((int)j);
                boolean collision = false;
                Entity entity = this.getEntity();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"getEntity()");
                double angle1 = entity.getRotation();
                Entity entity2 = other.getEntity();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"other.getEntity()");
                double angle2 = entity2.getRotation();
                if (angle1 == 0.0 && angle2 == 0.0) {
                    HitBox hitBox = box1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hitBox, (String)"box1");
                    HitBox hitBox2 = box2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hitBox2, (String)"box2");
                    collision = this.checkCollision(hitBox, hitBox2);
                } else {
                    HitBox hitBox = box1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hitBox, (String)"box1");
                    HitBox hitBox3 = box2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hitBox3, (String)"box2");
                    TransformComponent transformComponent = this.transform;
                    if (transformComponent == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
                    }
                    TransformComponent transformComponent2 = other.transform;
                    if (transformComponent2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
                    }
                    collision = this.checkCollision(hitBox, hitBox3, angle1, angle2, transformComponent, transformComponent2);
                }
                if (collision) {
                    result.init(box1, box2);
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private final boolean checkCollision(HitBox box1, HitBox box2) {
        return box2.getMaxXWorld() >= box1.getMinXWorld() && box2.getMaxYWorld() >= box1.getMinYWorld() && box2.getMinXWorld() <= box1.getMaxXWorld() && box2.getMinYWorld() <= box1.getMaxYWorld();
    }

    private final boolean checkCollision(HitBox box1, HitBox box2, double angle1, double angle2, TransformComponent t1, TransformComponent t2) {
        return SAT.isColliding(box1, box2, angle1, angle2, t1, t2);
    }

    public final boolean isWithin(@NotNull Rectangle2D bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        return this.isWithin(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public final boolean isWithin(double minX, double minY, double maxX, double maxY) {
        return !this.isOutside(minX, minY, maxX, maxY);
    }

    public final boolean isOutside(@NotNull Rectangle2D bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        return this.isOutside(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOutside(double minX, double minY, double maxX, double maxY) {
        TransformComponent transformComponent = this.transform;
        if (transformComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        if (transformComponent.getX() + this.getMinXLocal() + this.getWidth() <= minX) return true;
        TransformComponent transformComponent2 = this.transform;
        if (transformComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        if (transformComponent2.getX() + this.getMinXLocal() >= maxX) return true;
        TransformComponent transformComponent3 = this.transform;
        if (transformComponent3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        if (transformComponent3.getY() + this.getMinYLocal() + this.getHeight() <= minY) return true;
        TransformComponent transformComponent4 = this.transform;
        if (transformComponent4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        }
        if (!(transformComponent4.getY() + this.getMinYLocal() >= maxY)) return false;
        return true;
    }

    @NotNull
    public final Rectangle2D range(double width, double height) {
        double minX = this.getMinXWorld() - width;
        double minY = this.getMinYWorld() - height;
        double maxX = this.getMaxXWorld() + width;
        double maxY = this.getMaxYWorld() + height;
        return new Rectangle2D(minX, minY, maxX - minX, maxY - minY);
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        bundle.put("hitBoxes", (Serializable)new ArrayList((Collection)this.hitBoxes));
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.hitBoxes.addAll((Collection)bundle.get("hitBoxes"));
    }

    @Override
    @NotNull
    public String toString() {
        return "bbox(" + this.hitBoxes + ')';
    }

    public BoundingBoxComponent(HitBox ... boxes) {
        Intrinsics.checkParameterIsNotNull((Object)boxes, (String)"boxes");
        this.hitBoxes = FXCollections.observableArrayList();
        this.width = new ReadOnlyDoubleWrapper();
        this.height = new ReadOnlyDoubleWrapper();
        this.minXLocal = new ReadOnlyDoubleWrapper();
        this.minYLocal = new ReadOnlyDoubleWrapper();
        this.minXWorld = new ReadOnlyDoubleWrapper();
        this.minYWorld = new ReadOnlyDoubleWrapper();
        this.maxXWorld = new ReadOnlyDoubleWrapper();
        this.maxYWorld = new ReadOnlyDoubleWrapper();
        this.onHitBoxChange = (ListChangeListener)new ListChangeListener<HitBox>(this){
            final /* synthetic */ BoundingBoxComponent this$0;

            public final void onChanged(ListChangeListener.Change<? extends HitBox> c) {
                BoundingBoxComponent.access$getMinXLocal$p(this.this$0).set(BoundingBoxComponent.access$computeMinXLocal(this.this$0));
                BoundingBoxComponent.access$getMinYLocal$p(this.this$0).set(BoundingBoxComponent.access$computeMinYLocal(this.this$0));
                BoundingBoxComponent.access$getWidth$p(this.this$0).set(BoundingBoxComponent.access$computeWidth(this.this$0));
                BoundingBoxComponent.access$getHeight$p(this.this$0).set(BoundingBoxComponent.access$computeHeight(this.this$0));
                while (c.next()) {
                    HitBox it;
                    boolean $i$f$forEach;
                    Iterable $this$forEach$iv;
                    if (c.wasAdded()) {
                        ListChangeListener.Change<? extends HitBox> change = c;
                        Intrinsics.checkExpressionValueIsNotNull(change, (String)"c");
                        List list = change.getAddedSubList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"c.addedSubList");
                        $this$forEach$iv = list;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (HitBox)element$iv;
                            boolean bl = false;
                            it.bindXY(this.this$0.getTransform());
                        }
                        continue;
                    }
                    if (!c.wasRemoved()) continue;
                    ListChangeListener.Change<? extends HitBox> change = c;
                    Intrinsics.checkExpressionValueIsNotNull(change, (String)"c");
                    List list = change.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"c.removed");
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (HitBox)element$iv;
                        boolean bl = false;
                        it.unbind();
                    }
                }
            }
            {
                this.this$0 = boundingBoxComponent;
            }
        };
        this.hitBoxes.addAll((Object[])Arrays.copyOf(boxes, boxes.length));
        this.minXLocal.set(this.computeMinXLocal());
        this.minYLocal.set(this.computeMinYLocal());
        this.width.set(this.computeWidth());
        this.height.set(this.computeHeight());
        this.hitBoxes.addListener(this.onHitBoxChange);
        this.dummy = new CollisionResult();
    }

    public static final /* synthetic */ ReadOnlyDoubleWrapper access$getMinXLocal$p(BoundingBoxComponent $this) {
        return $this.minXLocal;
    }

    public static final /* synthetic */ double access$computeMinXLocal(BoundingBoxComponent $this) {
        return $this.computeMinXLocal();
    }

    public static final /* synthetic */ ReadOnlyDoubleWrapper access$getMinYLocal$p(BoundingBoxComponent $this) {
        return $this.minYLocal;
    }

    public static final /* synthetic */ double access$computeMinYLocal(BoundingBoxComponent $this) {
        return $this.computeMinYLocal();
    }

    public static final /* synthetic */ ReadOnlyDoubleWrapper access$getWidth$p(BoundingBoxComponent $this) {
        return $this.width;
    }

    public static final /* synthetic */ double access$computeWidth(BoundingBoxComponent $this) {
        return $this.computeWidth();
    }

    public static final /* synthetic */ ReadOnlyDoubleWrapper access$getHeight$p(BoundingBoxComponent $this) {
        return $this.height;
    }

    public static final /* synthetic */ double access$computeHeight(BoundingBoxComponent $this) {
        return $this.computeHeight();
    }
}

