/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.components;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.SerializableComponent;
import java.io.Serializable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@CoreComponent
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010:\u001a\u00020\u0018J\u000e\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u0000J\u0006\u0010=\u001a\u00020\u001aJ\u0006\u0010>\u001a\u00020\u001aJ\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\u000e\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020\bJ\u000e\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020\u0004J\u0006\u0010G\u001a\u00020\u001aJ\u0006\u0010H\u001a\u00020\u001aJ\u0006\u0010I\u001a\u00020\u001aJ\u0006\u0010J\u001a\u00020\u001aJ\u0006\u0010K\u001a\u00020\u0018J\u0006\u0010L\u001a\u00020\u0018J\u0016\u0010\u0016\u001a\u00020@2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\b\u0010M\u001a\u00020NH\u0016J\u000e\u0010O\u001a\u00020@2\u0006\u0010F\u001a\u00020\u0004J\u0016\u0010O\u001a\u00020@2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010P\u001a\u00020@2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\bJ\u000e\u0010Q\u001a\u00020@2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010R\u001a\u00020@2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010S\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\u0006\u0010T\u001a\u00020\u0018J\u0006\u0010U\u001a\u00020\u0018J\u0006\u0010V\u001a\u00020%R$\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0005R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0005R$\u0010)\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u0015\"\u0004\b+\u0010\u0005R$\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u0010\"\u0004\b-\u0010\u0012R$\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0010\"\u0004\b/\u0010\u0012R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u0010\"\u0004\b1\u0010\u0012R$\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0012R$\u00105\u001a\u0002042\u0006\u0010\u000e\u001a\u0002048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006W"}, d2={"Lcom/almasb/fxgl/entity/components/TransformComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/SerializableComponent;", "p", "Ljavafx/geometry/Point2D;", "(Ljavafx/geometry/Point2D;)V", "()V", "x", "", "y", "angle", "scaleX", "scaleY", "(DDDDD)V", "value", "getAngle", "()D", "setAngle", "(D)V", "position", "getPosition", "()Ljavafx/geometry/Point2D;", "setPosition", "propAngle", "Ljavafx/beans/property/DoubleProperty;", "propPositionOriginX", "Ljavafx/beans/property/SimpleDoubleProperty;", "propPositionOriginY", "propRotationOriginX", "propRotationOriginY", "propScaleOriginX", "propScaleOriginY", "propScaleX", "propScaleY", "propX", "propY", "propZ", "Ljavafx/beans/property/IntegerProperty;", "rotationOrigin", "getRotationOrigin", "setRotationOrigin", "scaleOrigin", "getScaleOrigin", "setScaleOrigin", "getScaleX", "setScaleX", "getScaleY", "setScaleY", "getX", "setX", "getY", "setY", "", "z", "getZ", "()I", "setZ", "(I)V", "angleProperty", "distance", "other", "positionOriginXProperty", "positionOriginYProperty", "read", "", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "rotateBy", "byAngle", "rotateToVector", "vector", "rotationOriginXProperty", "rotationOriginYProperty", "scaleOriginXProperty", "scaleOriginYProperty", "scaleXProperty", "scaleYProperty", "toString", "", "translate", "translateTowards", "translateX", "translateY", "write", "xProperty", "yProperty", "zProperty", "fxgl-entity"})
public final class TransformComponent
extends Component
implements SerializableComponent {
    private final DoubleProperty propX;
    private final DoubleProperty propY;
    private final IntegerProperty propZ;
    private final DoubleProperty propAngle;
    private final DoubleProperty propScaleX;
    private final DoubleProperty propScaleY;
    private final SimpleDoubleProperty propPositionOriginX;
    private final SimpleDoubleProperty propPositionOriginY;
    private final SimpleDoubleProperty propScaleOriginX;
    private final SimpleDoubleProperty propScaleOriginY;
    private final SimpleDoubleProperty propRotationOriginX;
    private final SimpleDoubleProperty propRotationOriginY;

    public final double getX() {
        Double d = this.propX.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propX.value");
        return d;
    }

    public final void setX(double value) {
        this.propX.setValue((Number)value);
    }

    public final double getY() {
        Double d = this.propY.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propY.value");
        return d;
    }

    public final void setY(double value) {
        this.propY.setValue((Number)value);
    }

    public final int getZ() {
        Integer n = this.propZ.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"propZ.value");
        return n;
    }

    public final void setZ(int value) {
        this.propZ.setValue((Number)value);
    }

    public final double getAngle() {
        Double d = this.propAngle.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propAngle.value");
        return d;
    }

    public final void setAngle(double value) {
        this.propAngle.setValue((Number)value);
    }

    public final double getScaleX() {
        Double d = this.propScaleX.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propScaleX.value");
        return d;
    }

    public final void setScaleX(double value) {
        this.propScaleX.setValue((Number)value);
    }

    public final double getScaleY() {
        Double d = this.propScaleY.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propScaleY.value");
        return d;
    }

    public final void setScaleY(double value) {
        this.propScaleY.setValue((Number)value);
    }

    @NotNull
    public final Point2D getPosition() {
        return new Point2D(this.getX(), this.getY());
    }

    public final void setPosition(@NotNull Point2D value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.setPosition(value.getX(), value.getY());
    }

    @NotNull
    public final Point2D getScaleOrigin() {
        Double d = this.propScaleOriginX.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propScaleOriginX.value");
        double d2 = d;
        Double d3 = this.propScaleOriginY.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"propScaleOriginY.value");
        return new Point2D(d2, d3.doubleValue());
    }

    public final void setScaleOrigin(@NotNull Point2D value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.propScaleOriginX.setValue((Number)value.getX());
        this.propScaleOriginY.setValue((Number)value.getY());
    }

    @NotNull
    public final Point2D getRotationOrigin() {
        Double d = this.propRotationOriginX.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"propRotationOriginX.value");
        double d2 = d;
        Double d3 = this.propRotationOriginY.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"propRotationOriginY.value");
        return new Point2D(d2, d3.doubleValue());
    }

    public final void setRotationOrigin(@NotNull Point2D value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.propRotationOriginX.setValue((Number)value.getX());
        this.propRotationOriginY.setValue((Number)value.getY());
    }

    @NotNull
    public final DoubleProperty xProperty() {
        return this.propX;
    }

    @NotNull
    public final DoubleProperty yProperty() {
        return this.propY;
    }

    @NotNull
    public final IntegerProperty zProperty() {
        return this.propZ;
    }

    @NotNull
    public final DoubleProperty scaleXProperty() {
        return this.propScaleX;
    }

    @NotNull
    public final DoubleProperty scaleYProperty() {
        return this.propScaleY;
    }

    @NotNull
    public final DoubleProperty angleProperty() {
        return this.propAngle;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginXProperty() {
        return this.propPositionOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginYProperty() {
        return this.propPositionOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginXProperty() {
        return this.propScaleOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginYProperty() {
        return this.propScaleOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginXProperty() {
        return this.propRotationOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginYProperty() {
        return this.propRotationOriginY;
    }

    public final void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public final void translateX(double x) {
        TransformComponent transformComponent = this;
        transformComponent.setX(transformComponent.getX() + x);
    }

    public final void translateY(double y) {
        TransformComponent transformComponent = this;
        transformComponent.setY(transformComponent.getY() + y);
    }

    public final void translate(double x, double y) {
        this.translateX(x);
        this.translateY(y);
    }

    public final void translate(@NotNull Point2D vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        this.translate(vector.getX(), vector.getY());
    }

    public final void translateTowards(@NotNull Point2D position, double distance) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Point2D point2D = position.subtract(this.getX(), this.getY()).normalize().multiply(distance);
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"position.subtract(x, y).\u2026lize().multiply(distance)");
        this.translate(point2D);
    }

    public final double distance(@NotNull TransformComponent other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.getPosition().distance(other.getPosition());
    }

    public final void rotateBy(double byAngle) {
        DoubleProperty doubleProperty = this.propAngle;
        doubleProperty.setValue((Number)(doubleProperty.getValue() + byAngle));
    }

    public final void rotateToVector(@NotNull Point2D vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        this.propAngle.setValue((Number)Math.toDegrees(Math.atan2(vector.getY(), vector.getX())));
    }

    @Override
    @NotNull
    public String toString() {
        return "Transform(" + this.getX() + ", " + this.getY() + ", " + this.getAngle() + ", " + this.getScaleX() + ", " + this.getScaleY() + ')';
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        bundle.put("propX", (Serializable)Double.valueOf(this.getX()));
        bundle.put("propY", (Serializable)Double.valueOf(this.getY()));
        bundle.put("angle", (Serializable)Double.valueOf(this.getAngle()));
        bundle.put("scaleX", (Serializable)Double.valueOf(this.getScaleX()));
        bundle.put("scaleY", (Serializable)Double.valueOf(this.getScaleY()));
        bundle.put("scaleOriginX", (Serializable)Double.valueOf(this.getScaleOrigin().getX()));
        bundle.put("scaleOriginY", (Serializable)Double.valueOf(this.getScaleOrigin().getY()));
        bundle.put("rotationOriginX", (Serializable)Double.valueOf(this.getRotationOrigin().getX()));
        bundle.put("rotationOriginY", (Serializable)Double.valueOf(this.getRotationOrigin().getY()));
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.setPosition(((Number)bundle.get("propX")).doubleValue(), ((Number)bundle.get("propY")).doubleValue());
        this.setScaleOrigin(new Point2D(((Number)bundle.get("scaleOriginX")).doubleValue(), ((Number)bundle.get("scaleOriginY")).doubleValue()));
        this.setRotationOrigin(new Point2D(((Number)bundle.get("rotationOriginX")).doubleValue(), ((Number)bundle.get("rotationOriginY")).doubleValue()));
        this.setAngle(((Number)bundle.get("angle")).doubleValue());
        this.setScaleX(((Number)bundle.get("scaleX")).doubleValue());
        this.setScaleY(((Number)bundle.get("scaleY")).doubleValue());
    }

    public TransformComponent(double x, double y, double angle, double scaleX, double scaleY) {
        this.propX = (DoubleProperty)new SimpleDoubleProperty(x);
        this.propY = (DoubleProperty)new SimpleDoubleProperty(y);
        this.propZ = (IntegerProperty)new SimpleIntegerProperty(0);
        this.propAngle = (DoubleProperty)new SimpleDoubleProperty(angle);
        this.propScaleX = (DoubleProperty)new SimpleDoubleProperty(scaleX);
        this.propScaleY = (DoubleProperty)new SimpleDoubleProperty(scaleY);
        this.propPositionOriginX = new SimpleDoubleProperty(0.0);
        this.propPositionOriginY = new SimpleDoubleProperty(0.0);
        this.propScaleOriginX = new SimpleDoubleProperty(0.0);
        this.propScaleOriginY = new SimpleDoubleProperty(0.0);
        this.propRotationOriginX = new SimpleDoubleProperty(0.0);
        this.propRotationOriginY = new SimpleDoubleProperty(0.0);
    }

    public TransformComponent(@NotNull Point2D p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        this(p.getX(), p.getY(), 0.0, 1.0, 1.0);
    }

    public TransformComponent() {
        this(0.0, 0.0, 0.0, 1.0, 1.0);
    }
}

