/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.entity.level.LevelLoadingException;
import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.TMXLevelLoaderKt;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.TiledObject;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.entity.level.tiled.TilesetLoader;
import com.almasb.sslogger.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javafx.scene.shape.Polygon;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TMXLevelLoader;", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "()V", "log", "Lcom/almasb/sslogger/Logger;", "createObjectLayerEntities", "", "Lcom/almasb/fxgl/entity/Entity;", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "tilesetLoader", "Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "world", "Lcom/almasb/fxgl/entity/GameWorld;", "createTileLayerEntities", "load", "Lcom/almasb/fxgl/entity/level/Level;", "url", "Ljava/net/URL;", "parse", "inputStream", "Ljava/io/InputStream;", "parseData", "", "layer", "Lcom/almasb/fxgl/entity/level/tiled/Layer;", "data", "", "start", "Ljavax/xml/stream/events/StartElement;", "parseImage", "tileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "parseMap", "parseMapProperty", "parseObject", "obj", "Lcom/almasb/fxgl/entity/level/tiled/TiledObject;", "parseObjectGroupLayer", "parseObjectPolygon", "parseObjectProperty", "parseTileLayer", "parseTileset", "fxgl-entity"})
public final class TMXLevelLoader
implements LevelLoader {
    private final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Level load(@NotNull URL url, @NotNull GameWorld world) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        try {
            Closeable closeable = url.openStream();
            boolean bl = false;
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                it = this.parse(inputStream);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object map = it;
            this.log.debug("Parsed raw map: " + map);
            TilesetLoader tilesetLoader = new TilesetLoader((TiledMap)map, url);
            List<Entity> tileLayerEntities = this.createTileLayerEntities((TiledMap)map, tilesetLoader);
            List<Entity> objectEntities = this.createObjectLayerEntities((TiledMap)map, tilesetLoader, world);
            Level level = new Level(((TiledMap)map).getWidth() * ((TiledMap)map).getTilewidth(), ((TiledMap)map).getHeight() * ((TiledMap)map).getTileheight(), CollectionsKt.plus((Collection)tileLayerEntities, (Iterable)objectEntities));
            ((TiledMap)map).getProperties().forEach(new BiConsumer<String, Object>(level){
                final /* synthetic */ Level $level;

                public final void accept(@NotNull String key, @NotNull Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    if (value instanceof Float) {
                        this.$level.getProperties().setValue(key, (Object)((Number)value).floatValue());
                    } else {
                        this.$level.getProperties().setValue(key, value);
                    }
                }
                {
                    this.$level = level;
                }
            });
            return level;
        }
        catch (Exception e) {
            this.log.warning("Parse error", (Throwable)e);
            e.printStackTrace();
            throw (Throwable)new LevelLoadingException(String.valueOf(e.getMessage()), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createTileLayerEntities(TiledMap map, TilesetLoader tilesetLoader) {
        void $this$mapTo$iv$iv;
        Layer it;
        Iterable $this$filterTo$iv$iv;
        this.log.debug("Creating tile layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"tilelayer")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void layer;
            it = (Layer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entity entity = new Entity();
            boolean bl2 = false;
            boolean bl3 = false;
            Entity it2 = entity;
            boolean bl4 = false;
            ViewComponent.addChild$default(it2.getViewComponent(), tilesetLoader.loadView(layer.getName()), false, 2, null);
            Entity entity2 = entity;
            collection.add(entity2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createObjectLayerEntities(TiledMap map, TilesetLoader tilesetLoader, GameWorld world) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Layer it;
        Iterable $this$filterTo$iv$iv;
        this.log.debug("Creating object layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"objectgroup")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getObjects();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry<String, Object> it2;
            Map.Entry<String, Object> element$iv;
            void tiledObject;
            list$iv$iv = (TiledObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpawnData data = new SpawnData(tiledObject.getX(), tiledObject.getY() - (tiledObject.getGid() == 0 ? 0 : tiledObject.getHeight()));
            Object object = data;
            boolean bl2 = false;
            boolean bl3 = false;
            SpawnData $this$run = object;
            boolean bl4 = false;
            $this$run.put("name", tiledObject.getName());
            $this$run.put("type", tiledObject.getType());
            $this$run.put("width", tiledObject.getWidth());
            $this$run.put("height", tiledObject.getHeight());
            $this$run.put("rotation", Float.valueOf(tiledObject.getRotation()));
            $this$run.put("id", tiledObject.getId());
            $this$run.put("gid", tiledObject.getGid());
            Map $this$forEach$iv = tiledObject.getProperties();
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl5 = false;
            Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                it2 = element$iv = iterator.next();
                boolean bl6 = false;
                $this$run.put(it2.getKey(), it2.getValue());
            }
            object = world.create(tiledObject.getType(), data);
            bl2 = false;
            bl3 = false;
            Object e = object;
            boolean bl7 = false;
            $this$forEach$iv = data.getData();
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl5 = false;
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                it2 = element$iv = iterator.next();
                boolean bl8 = false;
                ((Entity)e).setProperty(it2.getKey(), it2.getValue());
            }
            ((Entity)e).setPosition(data.getX(), data.getY());
            ((Entity)e).setRotation(tiledObject.getRotation());
            if (tiledObject.getGid() != 0) {
                ViewComponent.addChild$default(((Entity)e).getViewComponent(), tilesetLoader.loadView(tiledObject.getGid(), tiledObject.isFlippedHorizontal(), tiledObject.isFlippedVertical()), false, 2, null);
            }
            Object object2 = object;
            collection.add(object2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TiledMap parse(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream, "UTF-8");
        TiledMap map = new TiledMap(0, 0, 0, 0, null, null, null, null, null, 0, 0, null, null, false, null, null, 65535, null);
        boolean bl = false;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        boolean bl2 = false;
        ArrayList<Tileset> tilesets = new ArrayList<Tileset>();
        Layer currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
        Tileset currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
        TiledObject currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, 16383, null);
        boolean mapPropertiesFinished = false;
        while (eventReader.hasNext()) {
            EndElement endElement;
            String string;
            int n;
            XMLEvent event;
            XMLEvent xMLEvent = event = eventReader.nextEvent();
            Intrinsics.checkExpressionValueIsNotNull((Object)xMLEvent, (String)"event");
            if (xMLEvent.isStartElement()) {
                StartElement start;
                StartElement startElement = start = event.asStartElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)startElement, (String)"start");
                QName qName = startElement.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)qName, (String)"start.name");
                if (qName.getLocalPart() != null) {
                    n = -1;
                    switch (string.hashCode()) {
                        case 100313435: {
                            if (!string.equals("image")) break;
                            n = 1;
                            break;
                        }
                        case 3076010: {
                            if (!string.equals("data")) break;
                            n = 2;
                            break;
                        }
                        case -397519558: {
                            if (!string.equals("polygon")) break;
                            n = 3;
                            break;
                        }
                        case -1314831628: {
                            if (!string.equals("tileset")) break;
                            n = 4;
                            break;
                        }
                        case -993141291: {
                            if (!string.equals("property")) break;
                            n = 5;
                            break;
                        }
                        case 107868: {
                            if (!string.equals("map")) break;
                            n = 6;
                            break;
                        }
                        case 102749521: {
                            if (!string.equals("layer")) break;
                            n = 7;
                            break;
                        }
                        case -1269857632: {
                            if (!string.equals("objectgroup")) break;
                            n = 8;
                            break;
                        }
                        case -1023368385: {
                            if (!string.equals("object")) break;
                            n = 9;
                            break;
                        }
                    }
                    switch (n) {
                        case 6: {
                            this.parseMap(map, start);
                            break;
                        }
                        case 4: {
                            currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
                            this.parseTileset(currentTileset, start);
                            break;
                        }
                        case 1: {
                            this.parseImage(currentTileset, start);
                            break;
                        }
                        case 7: {
                            currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                            this.parseTileLayer(currentLayer, start);
                            break;
                        }
                        case 2: {
                            XMLEventReader xMLEventReader = eventReader;
                            Intrinsics.checkExpressionValueIsNotNull((Object)xMLEventReader, (String)"eventReader");
                            String string2 = xMLEventReader.getElementText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"eventReader.elementText");
                            this.parseData(currentLayer, string2, start);
                            break;
                        }
                        case 8: {
                            currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                            this.parseObjectGroupLayer(currentLayer, start);
                            break;
                        }
                        case 9: {
                            mapPropertiesFinished = true;
                            currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, 16383, null);
                            this.parseObject(currentLayer, currentObject, start);
                            break;
                        }
                        case 5: {
                            if (mapPropertiesFinished) {
                                this.parseObjectProperty(currentObject, start);
                                break;
                            }
                            this.parseMapProperty(map, start);
                            break;
                        }
                        case 3: {
                            this.parseObjectPolygon(currentObject, start);
                        }
                    }
                }
            }
            if (!event.isEndElement()) continue;
            EndElement endElement2 = endElement = event.asEndElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)endElement2, (String)"endElement");
            QName qName = endElement2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)qName, (String)"endElement.name");
            if (qName.getLocalPart() == null) continue;
            tmp = -1;
            switch (string.hashCode()) {
                case -1314831628: {
                    if (!string.equals("tileset")) break;
                    tmp = 1;
                    break;
                }
                case 102749521: {
                    if (!string.equals("layer")) break;
                    tmp = 2;
                    break;
                }
                case -1269857632: {
                    if (!string.equals("objectgroup")) break;
                    tmp = 2;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    tilesets.add(currentTileset);
                    break;
                }
                case 2: {
                    layers.add(currentLayer);
                }
            }
        }
        map.setLayers((List<Layer>)layers);
        map.setTilesets((List<Tileset>)tilesets);
        return map;
    }

    private final void parseMap(TiledMap map, StartElement start) {
        map.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        map.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        map.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        map.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        map.setNextobjectid(TMXLevelLoaderKt.access$getInt(start, "nextobjectid"));
        map.setType("map");
        map.setVersion(1);
        map.setInfinite(TMXLevelLoaderKt.access$getInt(start, "infinite") == 1);
        map.setBackgroundcolor(TMXLevelLoaderKt.access$getString(start, "backgroundcolor"));
        map.setOrientation(TMXLevelLoaderKt.access$getString(start, "orientation"));
        map.setRenderorder(TMXLevelLoaderKt.access$getString(start, "renderorder"));
        map.setTiledversion(TMXLevelLoaderKt.access$getString(start, "tiledversion"));
        if (Intrinsics.areEqual((Object)map.getTiledversion(), (Object)"1.2.3") ^ true) {
            this.log.warning("TiledMap generated from " + map.getTiledversion() + ". Supported version: 1.2.3. Some features may not be parsed fully.");
        }
    }

    private final void parseTileset(Tileset tileset, StartElement start) {
        tileset.setFirstgid(TMXLevelLoaderKt.access$getInt(start, "firstgid"));
        tileset.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        tileset.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        tileset.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        tileset.setSpacing(TMXLevelLoaderKt.access$getInt(start, "spacing"));
        tileset.setTilecount(TMXLevelLoaderKt.access$getInt(start, "tilecount"));
        tileset.setColumns(TMXLevelLoaderKt.access$getInt(start, "columns"));
    }

    private final void parseImage(Tileset tileset, StartElement start) {
        tileset.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tileset.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tileset.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tileset.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseTileLayer(Layer layer, StartElement start) {
        layer.setType("tilelayer");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        layer.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        layer.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        layer.setOpacity(TMXLevelLoaderKt.access$getFloat(start, "opacity"));
        layer.setVisible(TMXLevelLoaderKt.access$getInt(start, "visible") == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseData(Layer layer, String data, StartElement start) {
        switch (TMXLevelLoaderKt.access$getString(start, "encoding")) {
            case "csv": {
                Collection<Integer> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)data, (String)"\n", (String)"", (boolean)false, (int)4, null), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                Layer layer2 = layer;
                boolean $i$f$map = false;
                void var7_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void var15_38 = it;
                    boolean bl2 = false;
                    Integer n = Integer.parseInt((String)var15_38);
                    collection.add(n);
                }
                collection = (List)destination$iv$iv;
                layer2.setData((List<Integer>)collection);
                break;
            }
            case "base64": {
                String $i$f$map = data;
                Base64.Decoder decoder = Base64.getDecoder();
                boolean $this$mapTo$iv$iv = false;
                String string = $i$f$map;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                byte[] bytes = decoder.decode(string2);
                switch (TMXLevelLoaderKt.access$getString(start, "compression")) {
                    case "zlib": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
                        Object object = bytes;
                        boolean bl = false;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        InputStream inputStream = byteArrayInputStream;
                        object = new InflaterInputStream(inputStream);
                        bl = false;
                        Throwable throwable = null;
                        try {
                            InflaterInputStream it22 = (InflaterInputStream)object;
                            boolean bl3 = false;
                            long it22 = ByteStreamsKt.copyTo$default((InputStream)it22, (OutputStream)baos, (int)0, (int)2, null);
                        }
                        catch (Throwable it22) {
                            throwable = it22;
                            throw it22;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                        bytes = baos.toByteArray();
                        break;
                    }
                    case "gzip": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
                        Object object = bytes;
                        boolean bl = false;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        InputStream inputStream = byteArrayInputStream;
                        object = new GZIPInputStream(inputStream);
                        bl = false;
                        Throwable throwable = null;
                        try {
                            GZIPInputStream it = (GZIPInputStream)object;
                            boolean bl4 = false;
                            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)baos, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                        bytes = baos.toByteArray();
                    }
                }
                IntBuffer ints = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                int[] intArray = new int[ints.limit()];
                ints.get(intArray);
                layer.setData(ArraysKt.toList((int[])intArray));
            }
        }
    }

    private final void parseObjectGroupLayer(Layer layer, StartElement start) {
        layer.setType("objectgroup");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
    }

    private final void parseObject(Layer layer, TiledObject obj, StartElement start) {
        obj.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        obj.setType(TMXLevelLoaderKt.access$getString(start, "type"));
        obj.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
        obj.setX(TMXLevelLoaderKt.access$getInt(start, "x"));
        obj.setY(TMXLevelLoaderKt.access$getInt(start, "y"));
        obj.setRotation(TMXLevelLoaderKt.access$getFloat(start, "rotation"));
        obj.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        obj.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        int gidUInt = TMXLevelLoaderKt.access$getUInt(start, "gid");
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        int FLIPPED_HORIZONTALLY_FLAG = UInt.constructor-impl((int)n);
        n2 = 0x40000000;
        int n3 = 0;
        int FLIPPED_VERTICALLY_FLAG = UInt.constructor-impl((int)n2);
        n3 = 0x20000000;
        int n4 = 0;
        int FLIPPED_DIAGONALLY_FLAG = UInt.constructor-impl((int)n3);
        n3 = gidUInt;
        TiledObject tiledObject = obj;
        n4 = 0;
        int n5 = UInt.constructor-impl((int)(n3 & FLIPPED_HORIZONTALLY_FLAG));
        n3 = 0;
        n4 = 0;
        int n6 = UInt.constructor-impl((int)n3);
        tiledObject.setFlippedHorizontal(n5 != n6);
        n3 = gidUInt;
        tiledObject = obj;
        n4 = 0;
        n5 = UInt.constructor-impl((int)(n3 & FLIPPED_VERTICALLY_FLAG));
        n3 = 0;
        n4 = 0;
        n6 = UInt.constructor-impl((int)n3);
        tiledObject.setFlippedVertical(n5 != n6);
        n4 = gidUInt;
        int n7 = FLIPPED_HORIZONTALLY_FLAG;
        boolean bl = false;
        n7 = UInt.constructor-impl((int)(n7 | FLIPPED_VERTICALLY_FLAG));
        bl = false;
        n7 = UInt.constructor-impl((int)(n7 | FLIPPED_DIAGONALLY_FLAG));
        bl = false;
        n7 = UInt.constructor-impl((int)(~n7));
        bl = false;
        n4 = UInt.constructor-impl((int)(n4 & n7));
        n7 = 0;
        int gid = n4;
        obj.setGid(gid);
        List<TiledObject> list = layer.getObjects();
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<com.almasb.fxgl.entity.level.tiled.TiledObject>");
        }
        TypeIntrinsics.asMutableList(list).add(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseObjectProperty(TiledObject obj, StartElement start) {
        Object object;
        Map map;
        String propName;
        block13: {
            String propType;
            block11: {
                block10: {
                    block12: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map2 = obj.getPropertytypes();
                        if (map2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        }
                        TypeIntrinsics.asMutableMap(map2).put(propName, propType);
                        Map<String, Object> map3 = obj.getProperties();
                        if (map3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        }
                        map = TypeIntrinsics.asMutableMap(map3);
                        String string = propType;
                        switch (string.hashCode()) {
                            case 0: {
                                if (!string.equals("")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 3029738: {
                                if (!string.equals("bool")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break;
                            }
                            case -891985903: {
                                if (!string.equals("string")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 94842723: {
                                if (!string.equals("color")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block11;
                            }
                            case 97526364: {
                                if (!string.equals("float")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block12;
                            }
                            case 104431: {
                                if (!string.equals("int")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block13;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block13;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block13;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block13;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block13;
            throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        map.put(propName, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseMapProperty(TiledMap map, StartElement start) {
        Object object;
        Map map2;
        String propName;
        block13: {
            String propType;
            block11: {
                block10: {
                    block12: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map3 = map.getPropertytypes();
                        if (map3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        }
                        TypeIntrinsics.asMutableMap(map3).put(propName, propType);
                        Map<String, Object> map4 = map.getProperties();
                        if (map4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        }
                        map2 = TypeIntrinsics.asMutableMap(map4);
                        String string = propType;
                        switch (string.hashCode()) {
                            case 0: {
                                if (!string.equals("")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 3029738: {
                                if (!string.equals("bool")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break;
                            }
                            case -891985903: {
                                if (!string.equals("string")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 94842723: {
                                if (!string.equals("color")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block11;
                            }
                            case 97526364: {
                                if (!string.equals("float")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block12;
                            }
                            case 104431: {
                                if (!string.equals("int")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block13;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block13;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block13;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block13;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block13;
            throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        map2.put(propName, object);
    }

    /*
     * WARNING - void declaration
     */
    private final void parseObjectPolygon(TiledObject obj, StartElement start) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        String data = TMXLevelLoaderKt.access$getString(start, "points");
        CharSequence charSequence = data;
        String string = " +";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        Iterable $this$flatMap$iv = string.split(charSequence, n);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string2 = it;
            boolean bl4 = false;
            Double d = Double.parseDouble(string2);
            collection.add(d);
        }
        double[] points = CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
        Polygon polygon = new Polygon(Arrays.copyOf(points, points.length));
        Map<String, Object> map = obj.getProperties();
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        TypeIntrinsics.asMutableMap(map).put("polygon", polygon);
    }

    public TMXLevelLoader() {
        Logger logger;
        Logger.Companion this_$iv = Logger.Companion;
        TMXLevelLoader tMXLevelLoader = this;
        boolean $i$f$get = false;
        tMXLevelLoader.log = logger = this_$iv.get(TMXLevelLoader.class);
    }
}

