/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.texture.Texture;
import com.almasb.sslogger.Logger;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\tR*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "mapURL", "Ljava/net/URL;", "(Lcom/almasb/fxgl/entity/level/tiled/TiledMap;Ljava/net/URL;)V", "imageCache", "Ljava/util/HashMap;", "", "Ljavafx/scene/image/Image;", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/sslogger/Logger;", "findTileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "gid", "", "tilesets", "", "loadTilesetImage", "tileset", "loadView", "Ljavafx/scene/Node;", "gidArg", "isFlippedHorizontal", "", "isFlippedVertical", "layerName", "fxgl-entity"})
public final class TilesetLoader {
    private final Logger log;
    private final HashMap<String, Image> imageCache;
    private final TiledMap map;
    private final URL mapURL;

    @NotNull
    public final Node loadView(int gidArg, boolean isFlippedHorizontal, boolean isFlippedVertical) {
        int gid = gidArg;
        Tileset tileset = this.findTileset(gid, this.map.getTilesets());
        int tilex = (gid -= tileset.getFirstgid()) % tileset.getColumns();
        int tiley = gid / tileset.getColumns();
        int w = this.map.getTilewidth();
        int h = this.map.getTileheight();
        WritableImage buffer = new WritableImage(w, h);
        Image sourceImage = this.loadTilesetImage(tileset);
        buffer.getPixelWriter().setPixels(0, 0, w, h, sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing());
        ImageView imageView = new ImageView((Image)buffer);
        boolean bl = false;
        boolean bl2 = false;
        ImageView it = imageView;
        boolean bl3 = false;
        it.setScaleX(isFlippedHorizontal ? -1.0 : 1.0);
        it.setScaleY(isFlippedVertical ? -1.0 : 1.0);
        return (Node)imageView;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Node loadView(@NotNull String layerName) {
        Intrinsics.checkParameterIsNotNull((Object)layerName, (String)"layerName");
        this.log.debug("Loading view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage buffer = new WritableImage(layer.getWidth() * this.map.getTilewidth(), layer.getHeight() * this.map.getTileheight());
        this.log.debug("Created buffer with size " + buffer.getWidth() + 'x' + buffer.getHeight());
        int n = 0;
        int n2 = layer.getData().size();
        while (n < n2) {
            void i;
            int gid = ((Number)layer.getData().get((int)i)).intValue();
            if (gid != 0) {
                Tileset tileset = this.findTileset(gid, this.map.getTilesets());
                int tilex = (gid -= tileset.getFirstgid()) % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                void x = i % layer.getWidth();
                void y = i / layer.getWidth();
                int w = this.map.getTilewidth();
                int h = this.map.getTileheight();
                Image sourceImage = this.loadTilesetImage(tileset);
                int srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                int srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
                this.log.debug("Writing to buffer: dst=" + (int)(x * w) + ',' + (int)(y * h) + ", w=" + w + ",h=" + h + ", src=" + srcx + ',' + srcy);
                buffer.getPixelWriter().setPixels((int)(x * w), (int)(y * h), w, h, sourceImage.getPixelReader(), srcx, srcy);
            }
            ++i;
        }
        return (Node)new ImageView((Image)buffer);
    }

    private final Tileset findTileset(int gid, List<Tileset> tilesets) {
        for (Tileset tileset : tilesets) {
            if (gid < tileset.getFirstgid() || gid >= tileset.getFirstgid() + tileset.getTilecount()) continue;
            return tileset;
        }
        throw (Throwable)new IllegalArgumentException("Tileset for gid=" + gid + " not found");
    }

    private final Image loadTilesetImage(Tileset tileset) {
        Image image;
        Image image2;
        String imageName = tileset.getImage();
        Object object = imageName;
        int n = StringsKt.lastIndexOf$default((CharSequence)imageName, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        imageName = string2;
        object = this.imageCache;
        n = 0;
        Object object2 = object;
        boolean bl2 = false;
        if (object2.containsKey(imageName)) {
            Image image3 = this.imageCache.get(imageName);
            if (image3 == null) {
                Intrinsics.throwNpe();
            }
            return image3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.mapURL.toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mapURL.toExternalForm()");
        String ext = stringBuilder.append(StringsKt.substringBeforeLast$default((String)string3, (String)"/", null, (int)2, null)).append("/").toString();
        object2 = tileset.getTransparentcolor();
        bl2 = false;
        if (object2.length() == 0) {
            image2 = new Image(ext + imageName);
        } else {
            Texture texture = new Texture(new Image(ext + imageName));
            Color color = Color.web((String)tileset.getTransparentcolor());
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.web(tileset.transparentcolor)");
            image2 = texture.transparentColor(color).getImage();
        }
        Image image4 = image = image2;
        Intrinsics.checkExpressionValueIsNotNull((Object)image4, (String)"image");
        if (image4.isError()) {
            throw (Throwable)new IllegalArgumentException(ext + imageName + " cannot be loaded");
        }
        ((Map)this.imageCache).put(imageName, image);
        return image;
    }

    /*
     * WARNING - void declaration
     */
    public TilesetLoader(@NotNull TiledMap map, @NotNull URL mapURL) {
        void this_$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)mapURL, (String)"mapURL");
        this.map = map;
        this.mapURL = mapURL;
        Logger.Companion companion = Logger.Companion;
        TilesetLoader tilesetLoader = this;
        boolean $i$f$get = false;
        tilesetLoader.log = object = this_$iv.get(TilesetLoader.class);
        tilesetLoader = this;
        boolean bl = false;
        tilesetLoader.imageCache = object = new HashMap();
    }
}

