/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.physics.BoxShapeData;
import com.almasb.fxgl.physics.ChainShapeData;
import com.almasb.fxgl.physics.CircleShapeData;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.PolygonShapeData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/physics/BoundingShape;", "", "size", "Ljavafx/geometry/Dimension2D;", "(Ljavafx/geometry/Dimension2D;)V", "getSize", "()Ljavafx/geometry/Dimension2D;", "toBox2DShape", "Lcom/almasb/fxgl/physics/box2d/collision/shapes/Shape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "bboxComp", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "conv", "Lcom/almasb/fxgl/physics/PhysicsUnitConverter;", "toString", "", "Companion", "Lcom/almasb/fxgl/physics/CircleShapeData;", "Lcom/almasb/fxgl/physics/BoxShapeData;", "Lcom/almasb/fxgl/physics/PolygonShapeData;", "Lcom/almasb/fxgl/physics/ChainShapeData;", "fxgl-entity"})
public abstract class BoundingShape {
    @NotNull
    private final Dimension2D size;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Shape toBox2DShape(@NotNull HitBox var1, @NotNull BoundingBoxComponent var2, @NotNull PhysicsUnitConverter var3);

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return StringsKt.substringBefore$default((String)string, (String)"ShapeData", null, (int)2, null);
    }

    @NotNull
    public final Dimension2D getSize() {
        return this.size;
    }

    private BoundingShape(Dimension2D size) {
        this.size = size;
    }

    public /* synthetic */ BoundingShape(Dimension2D size, DefaultConstructorMarker $constructor_marker) {
        this(size);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape circle(double radius) {
        return Companion.circle(radius);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape box(double width, double height) {
        return Companion.box(width, height);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape chain(Point2D ... points) {
        return Companion.chain(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(@NotNull List<? extends Point2D> points) {
        return Companion.polygon(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygonFromDoubles(@NotNull List<Double> points) {
        return Companion.polygonFromDoubles(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(double ... points) {
        return Companion.polygon(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(Point2D ... points) {
        return Companion.polygon(points);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J!\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J!\u0010\u000f\u001a\u00020\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u000f\u001a\u00020\u00042\n\u0010\t\u001a\u00020\u0010\"\u00020\u0006H\u0007J\u0016\u0010\u000f\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/physics/BoundingShape$Companion;", "", "()V", "box", "Lcom/almasb/fxgl/physics/BoundingShape;", "width", "", "height", "chain", "points", "", "Ljavafx/geometry/Point2D;", "([Ljavafx/geometry/Point2D;)Lcom/almasb/fxgl/physics/BoundingShape;", "circle", "radius", "polygon", "", "", "polygonFromDoubles", "fxgl-entity"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BoundingShape circle(double radius) {
            return new CircleShapeData(radius);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape box(double width, double height) {
            return new BoxShapeData(width, height);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape chain(Point2D ... points) {
            Intrinsics.checkParameterIsNotNull((Object)points, (String)"points");
            if (points.length < 2) {
                throw (Throwable)new IllegalArgumentException("Chain shape requires at least 2 points. Given points: " + points.length);
            }
            double maxX = points[0].getX();
            double maxY = points[0].getY();
            for (Point2D p : points) {
                if (p.getX() > maxX) {
                    maxX = p.getX();
                }
                if (!(p.getY() > maxY)) continue;
                maxY = p.getY();
            }
            return new ChainShapeData(new Dimension2D(maxX, maxY), points);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BoundingShape polygon(@NotNull List<? extends Point2D> points) {
            Point2D[] point2DArray;
            void $this$toTypedArray$iv;
            Intrinsics.checkParameterIsNotNull(points, (String)"points");
            Collection collection = points;
            Companion companion = this;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Point2D[] point2DArray2 = thisCollection$iv.toArray(new Point2D[0]);
            if (point2DArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Point2D[] point2DArray3 = point2DArray = point2DArray2;
            return companion.polygon(Arrays.copyOf(point2DArray3, point2DArray3.length));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BoundingShape polygonFromDoubles(@NotNull List<Double> points) {
            Intrinsics.checkParameterIsNotNull(points, (String)"points");
            double[] array = new double[points.size()];
            int n = 0;
            int n2 = ((Collection)points).size();
            while (n < n2) {
                void i;
                array[i] = ((Number)points.get((int)i)).doubleValue();
                ++i;
            }
            double[] dArray = CollectionsKt.toDoubleArray((Collection)points);
            return this.polygon(Arrays.copyOf(dArray, dArray.length));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BoundingShape polygon(double ... points) {
            Intrinsics.checkParameterIsNotNull((Object)points, (String)"points");
            int n = points.length / 2;
            Point2D[] point2DArray = new Point2D[n];
            int n2 = 0;
            while (n2 < n) {
                Point2D point2D;
                int n3 = n2;
                int n4 = n2++;
                Point2D[] point2DArray2 = point2DArray;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)Point2D.ZERO, (String)"Point2D.ZERO");
                point2DArray2[n4] = point2D;
            }
            Point2D[] array = point2DArray;
            n = 0;
            int n5 = array.length;
            while (n < n5) {
                void i;
                double x = points[i * 2];
                double y = points[i * 2 + true];
                array[i] = new Point2D(x, y);
                ++i;
            }
            return this.polygon(Arrays.copyOf(array, array.length));
        }

        @JvmStatic
        @NotNull
        public final BoundingShape polygon(Point2D ... points) {
            Intrinsics.checkParameterIsNotNull((Object)points, (String)"points");
            if (points.length < 3) {
                throw (Throwable)new IllegalArgumentException("Polygon shape requires at least 3 points. Given points: " + points.length);
            }
            double maxX = points[0].getX();
            double maxY = points[0].getY();
            for (Point2D p : points) {
                if (p.getX() > maxX) {
                    maxX = p.getX();
                }
                if (!(p.getY() > maxY)) continue;
                maxY = p.getY();
            }
            return new PolygonShapeData(new Dimension2D(maxX, maxY), points);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

