/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.box2d.collision.shapes.CircleShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/physics/CircleShapeData;", "Lcom/almasb/fxgl/physics/BoundingShape;", "radius", "", "(D)V", "getRadius", "()D", "toBox2DShape", "Lcom/almasb/fxgl/physics/box2d/collision/shapes/Shape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "bboxComp", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "conv", "Lcom/almasb/fxgl/physics/PhysicsUnitConverter;", "fxgl-entity"})
public final class CircleShapeData
extends BoundingShape {
    private final double radius;

    @Override
    @NotNull
    public Shape toBox2DShape(@NotNull HitBox box, @NotNull BoundingBoxComponent bboxComp, @NotNull PhysicsUnitConverter conv) {
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        Intrinsics.checkParameterIsNotNull((Object)bboxComp, (String)"bboxComp");
        Intrinsics.checkParameterIsNotNull((Object)conv, (String)"conv");
        Point2D boundsCenterLocal = box.getCenterWorld().subtract(bboxComp.getCenterWorld());
        CircleShape shape = new CircleShape();
        shape.setRadius(conv.toMetersF(box.getWidth() / 2.0));
        shape.center.set(conv.toVector(boundsCenterLocal));
        return shape;
    }

    public final double getRadius() {
        return this.radius;
    }

    public CircleShapeData(double radius) {
        super(new Dimension2D(radius * (double)2, radius * (double)2), null);
        this.radius = radius;
    }
}

