/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.HitBox;

public final class SAT {
    private static final Array<Vec2> axes = new UnorderedArray(4);
    private static final Array<Vec2> corners1 = new UnorderedArray(4);
    private static final Array<Vec2> corners2 = new UnorderedArray(4);

    private SAT() {
    }

    public static boolean isColliding(HitBox box1, HitBox box2, double angle1, double angle2, TransformComponent t1, TransformComponent t2) {
        SAT.populateAxes(angle1);
        SAT.populateAxes(angle2);
        SAT.corners(box1, angle1, t1, corners1);
        SAT.corners(box2, angle2, t2, corners2);
        boolean result = true;
        for (Vec2 axis : axes) {
            float e1Min = SAT.getMin(corners1, axis);
            float e1Max = SAT.getMax(corners1, axis);
            float e2Min = SAT.getMin(corners2, axis);
            float e2Max = SAT.getMax(corners2, axis);
            if (!(e1Max < e2Min) && !(e2Max < e1Min)) continue;
            result = false;
            break;
        }
        SAT.cleanArrays();
        return result;
    }

    private static void cleanArrays() {
        for (Vec2 v : axes) {
            SAT.freeVec(v);
        }
        for (Vec2 v : corners1) {
            SAT.freeVec(v);
        }
        for (Vec2 v : corners2) {
            SAT.freeVec(v);
        }
        axes.clear();
        corners1.clear();
        corners2.clear();
    }

    private static void populateAxes(double angle) {
        axes.add((Object)SAT.newVec(SAT.cos(angle), SAT.sin(angle)).normalizeLocal());
        axes.add((Object)SAT.newVec(SAT.cos(angle + 90.0), SAT.sin(angle + 90.0)).normalizeLocal());
    }

    private static void corners(HitBox box, double angle, TransformComponent t, Array<Vec2> array) {
        Vec2 origin = new Vec2(t.getRotationOrigin()).addLocal(t.getX(), t.getY());
        Vec2 topLeft = SAT.newVec(box.getMinXWorld(), box.getMinYWorld());
        Vec2 topRight = SAT.newVec(box.getMaxXWorld(), box.getMinYWorld());
        Vec2 botRight = SAT.newVec(box.getMaxXWorld(), box.getMaxYWorld());
        Vec2 botLeft = SAT.newVec(box.getMinXWorld(), box.getMaxYWorld());
        array.addAll((Object[])new Vec2[]{topLeft, topRight, botRight, botLeft});
        double cos = SAT.cos(angle);
        double sin = SAT.sin(angle);
        for (Vec2 v : array) {
            v.subLocal(origin);
            v.set((float)((double)v.x * cos - (double)v.y * sin), (float)((double)v.x * sin + (double)v.y * cos));
            v.addLocal(origin);
        }
        SAT.freeVec(origin);
    }

    private static float getMin(Array<Vec2> arrayCorners, Vec2 axis) {
        float min = Float.MAX_VALUE;
        for (Vec2 corner : arrayCorners) {
            float value = Vec2.dot((Vec2)corner, (Vec2)axis);
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    private static float getMax(Array<Vec2> arrayCorners, Vec2 axis) {
        float max = -2.1474836E9f;
        for (Vec2 corner : arrayCorners) {
            float value = Vec2.dot((Vec2)corner, (Vec2)axis);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private static Vec2 newVec(double x, double y) {
        return ((Vec2)Pools.obtain(Vec2.class)).set((float)x, (float)y);
    }

    private static void freeVec(Vec2 vec) {
        Pools.free((Object)vec);
    }

    private static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    private static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }
}

