/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.ContactImpulse;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.SolverData;
import com.almasb.fxgl.physics.box2d.dynamics.TimeStep;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactSolver;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactVelocityConstraint;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Position;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Velocity;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;

class Island {
    private ContactListener listener;
    public Body[] m_bodies;
    private Contact[] m_contacts;
    private Joint[] m_joints;
    private Position[] m_positions;
    private Velocity[] m_velocities;
    public int m_bodyCount;
    public int m_jointCount;
    public int m_contactCount;
    public int m_bodyCapacity;
    public int m_contactCapacity;
    public int m_jointCapacity;
    private final ContactSolver contactSolver = new ContactSolver();
    private final SolverData solverData = new SolverData();
    private final ContactSolver.ContactSolverDef solverDef = new ContactSolver.ContactSolverDef();
    private final ContactSolver toiContactSolver = new ContactSolver();
    private final ContactSolver.ContactSolverDef toiSolverDef = new ContactSolver.ContactSolverDef();
    private final ContactImpulse impulse = new ContactImpulse();

    Island() {
    }

    void init(int bodyCapacity, int contactCapacity, int jointCapacity, ContactListener listener) {
        int i;
        Object[] old;
        this.m_bodyCapacity = bodyCapacity;
        this.m_contactCapacity = contactCapacity;
        this.m_jointCapacity = jointCapacity;
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
        this.listener = listener;
        if (this.m_bodies == null || this.m_bodyCapacity > this.m_bodies.length) {
            this.m_bodies = new Body[this.m_bodyCapacity];
        }
        if (this.m_joints == null || this.m_jointCapacity > this.m_joints.length) {
            this.m_joints = new Joint[this.m_jointCapacity];
        }
        if (this.m_contacts == null || this.m_contactCapacity > this.m_contacts.length) {
            this.m_contacts = new Contact[this.m_contactCapacity];
        }
        if (this.m_velocities == null || this.m_bodyCapacity > this.m_velocities.length) {
            old = this.m_velocities == null ? new Velocity[]{} : this.m_velocities;
            this.m_velocities = new Velocity[this.m_bodyCapacity];
            System.arraycopy(old, 0, this.m_velocities, 0, old.length);
            for (i = old.length; i < this.m_velocities.length; ++i) {
                this.m_velocities[i] = new Velocity();
            }
        }
        if (this.m_positions == null || this.m_bodyCapacity > this.m_positions.length) {
            old = this.m_positions == null ? new Position[]{} : this.m_positions;
            this.m_positions = new Position[this.m_bodyCapacity];
            System.arraycopy(old, 0, this.m_positions, 0, old.length);
            for (i = old.length; i < this.m_positions.length; ++i) {
                this.m_positions[i] = new Position();
            }
        }
    }

    void clear() {
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
    }

    void solve(TimeStep step, Vec2 gravity, boolean allowSleep) {
        int i;
        int i2;
        float h = step.dt;
        for (i2 = 0; i2 < this.m_bodyCount; ++i2) {
            Body b = this.m_bodies[i2];
            Sweep bm_sweep = b.m_sweep;
            Vec2 c = bm_sweep.c;
            float a = bm_sweep.a;
            Vec2 v = b.m_linearVelocity;
            float w = b.getAngularVelocity();
            bm_sweep.c0.set(bm_sweep.c);
            bm_sweep.a0 = bm_sweep.a;
            if (b.getType() == BodyType.DYNAMIC) {
                v.x += h * (b.getGravityScale() * gravity.x + b.m_invMass * b.m_force.x);
                v.y += h * (b.getGravityScale() * gravity.y + b.m_invMass * b.m_force.y);
                w += h * b.m_invI * b.getTorque();
                v.x *= 1.0f / (1.0f + h * b.getLinearDamping());
                v.y *= 1.0f / (1.0f + h * b.getLinearDamping());
                w *= 1.0f / (1.0f + h * b.getAngularDamping());
            }
            this.m_positions[i2].c.x = c.x;
            this.m_positions[i2].c.y = c.y;
            this.m_positions[i2].a = a;
            this.m_velocities[i2].v.x = v.x;
            this.m_velocities[i2].v.y = v.y;
            this.m_velocities[i2].w = w;
        }
        this.solverData.step = step;
        this.solverData.positions = this.m_positions;
        this.solverData.velocities = this.m_velocities;
        this.solverDef.step = step;
        this.solverDef.contacts = this.m_contacts;
        this.solverDef.count = this.m_contactCount;
        this.solverDef.positions = this.m_positions;
        this.solverDef.velocities = this.m_velocities;
        this.contactSolver.init(this.solverDef);
        this.contactSolver.initializeVelocityConstraints();
        if (step.warmStarting) {
            this.contactSolver.warmStart();
        }
        for (i2 = 0; i2 < this.m_jointCount; ++i2) {
            this.m_joints[i2].initVelocityConstraints(this.solverData);
        }
        for (i2 = 0; i2 < step.velocityIterations; ++i2) {
            for (int j = 0; j < this.m_jointCount; ++j) {
                this.m_joints[j].solveVelocityConstraints(this.solverData);
            }
            this.contactSolver.solveVelocityConstraints();
        }
        this.contactSolver.storeImpulses();
        for (i2 = 0; i2 < this.m_bodyCount; ++i2) {
            float rotation;
            Vec2 c = this.m_positions[i2].c;
            float a = this.m_positions[i2].a;
            Vec2 v = this.m_velocities[i2].v;
            float w = this.m_velocities[i2].w;
            float translationx = v.x * h;
            float translationy = v.y * h;
            if (translationx * translationx + translationy * translationy > JBoxSettings.maxTranslationSquared) {
                float ratio = JBoxSettings.maxTranslation / JBoxUtils.sqrt(translationx * translationx + translationy * translationy);
                v.x *= ratio;
                v.y *= ratio;
            }
            if ((rotation = h * w) * rotation > JBoxSettings.maxRotationSquared) {
                float ratio = JBoxSettings.maxRotation / FXGLMath.abs((float)rotation);
                w *= ratio;
            }
            c.x += h * v.x;
            c.y += h * v.y;
            this.m_positions[i2].a = a += h * w;
            this.m_velocities[i2].w = w;
        }
        boolean positionSolved = false;
        for (i = 0; i < step.positionIterations; ++i) {
            boolean contactsOkay = this.contactSolver.solvePositionConstraints();
            boolean jointsOkay = true;
            for (int j = 0; j < this.m_jointCount; ++j) {
                boolean jointOkay = this.m_joints[j].solvePositionConstraints(this.solverData);
                jointsOkay = jointsOkay && jointOkay;
            }
            if (!contactsOkay || !jointsOkay) continue;
            positionSolved = true;
            break;
        }
        for (i = 0; i < this.m_bodyCount; ++i) {
            Body body = this.m_bodies[i];
            body.m_sweep.c.x = this.m_positions[i].c.x;
            body.m_sweep.c.y = this.m_positions[i].c.y;
            body.m_sweep.a = this.m_positions[i].a;
            body.m_linearVelocity.x = this.m_velocities[i].v.x;
            body.m_linearVelocity.y = this.m_velocities[i].v.y;
            body.setAngularVelocityDirectly(this.m_velocities[i].w);
            body.synchronizeTransform();
        }
        this.report(this.contactSolver.m_velocityConstraints);
        if (allowSleep) {
            int i3;
            float minSleepTime = Float.MAX_VALUE;
            float linTolSqr = JBoxSettings.linearSleepTolerance * JBoxSettings.linearSleepTolerance;
            float angTolSqr = JBoxSettings.angularSleepTolerance * JBoxSettings.angularSleepTolerance;
            for (i3 = 0; i3 < this.m_bodyCount; ++i3) {
                Body b = this.m_bodies[i3];
                if (b.getType() == BodyType.STATIC) continue;
                if (!b.isSleepingAllowed() || b.getAngularVelocity() * b.getAngularVelocity() > angTolSqr || Vec2.dot((Vec2)b.m_linearVelocity, (Vec2)b.m_linearVelocity) > linTolSqr) {
                    b.setSleepTime(0.0f);
                    minSleepTime = 0.0f;
                    continue;
                }
                b.setSleepTime(b.getSleepTime() + h);
                minSleepTime = JBoxUtils.min(minSleepTime, b.getSleepTime());
            }
            if (minSleepTime >= JBoxSettings.timeToSleep && positionSolved) {
                for (i3 = 0; i3 < this.m_bodyCount; ++i3) {
                    Body b = this.m_bodies[i3];
                    b.setAwake(false);
                }
            }
        }
    }

    void solveTOI(TimeStep subStep, int toiIndexA, int toiIndexB) {
        boolean contactsOkay;
        int i;
        assert (toiIndexA < this.m_bodyCount);
        assert (toiIndexB < this.m_bodyCount);
        for (i = 0; i < this.m_bodyCount; ++i) {
            this.m_positions[i].c.x = this.m_bodies[i].m_sweep.c.x;
            this.m_positions[i].c.y = this.m_bodies[i].m_sweep.c.y;
            this.m_positions[i].a = this.m_bodies[i].m_sweep.a;
            this.m_velocities[i].v.x = this.m_bodies[i].m_linearVelocity.x;
            this.m_velocities[i].v.y = this.m_bodies[i].m_linearVelocity.y;
            this.m_velocities[i].w = this.m_bodies[i].getAngularVelocity();
        }
        this.toiSolverDef.contacts = this.m_contacts;
        this.toiSolverDef.count = this.m_contactCount;
        this.toiSolverDef.step = subStep;
        this.toiSolverDef.positions = this.m_positions;
        this.toiSolverDef.velocities = this.m_velocities;
        this.toiContactSolver.init(this.toiSolverDef);
        for (i = 0; i < subStep.positionIterations && !(contactsOkay = this.toiContactSolver.solveTOIPositionConstraints(toiIndexA, toiIndexB)); ++i) {
        }
        this.m_bodies[toiIndexA].m_sweep.c0.x = this.m_positions[toiIndexA].c.x;
        this.m_bodies[toiIndexA].m_sweep.c0.y = this.m_positions[toiIndexA].c.y;
        this.m_bodies[toiIndexA].m_sweep.a0 = this.m_positions[toiIndexA].a;
        this.m_bodies[toiIndexB].m_sweep.c0.set(this.m_positions[toiIndexB].c);
        this.m_bodies[toiIndexB].m_sweep.a0 = this.m_positions[toiIndexB].a;
        this.toiContactSolver.initializeVelocityConstraints();
        for (i = 0; i < subStep.velocityIterations; ++i) {
            this.toiContactSolver.solveVelocityConstraints();
        }
        float h = subStep.dt;
        for (int i2 = 0; i2 < this.m_bodyCount; ++i2) {
            float rotation;
            Vec2 c = this.m_positions[i2].c;
            float a = this.m_positions[i2].a;
            Vec2 v = this.m_velocities[i2].v;
            float w = this.m_velocities[i2].w;
            float translationx = v.x * h;
            float translationy = v.y * h;
            if (translationx * translationx + translationy * translationy > JBoxSettings.maxTranslationSquared) {
                float ratio = JBoxSettings.maxTranslation / JBoxUtils.sqrt(translationx * translationx + translationy * translationy);
                v.mulLocal((double)ratio);
            }
            if ((rotation = h * w) * rotation > JBoxSettings.maxRotationSquared) {
                float ratio = JBoxSettings.maxRotation / FXGLMath.abs((float)rotation);
                w *= ratio;
            }
            c.x += v.x * h;
            c.y += v.y * h;
            this.m_positions[i2].c.x = c.x;
            this.m_positions[i2].c.y = c.y;
            this.m_positions[i2].a = a += h * w;
            this.m_velocities[i2].v.x = v.x;
            this.m_velocities[i2].v.y = v.y;
            this.m_velocities[i2].w = w;
            Body body = this.m_bodies[i2];
            body.m_sweep.c.x = c.x;
            body.m_sweep.c.y = c.y;
            body.m_sweep.a = a;
            body.m_linearVelocity.x = v.x;
            body.m_linearVelocity.y = v.y;
            body.setAngularVelocityDirectly(w);
            body.synchronizeTransform();
        }
        this.report(this.toiContactSolver.m_velocityConstraints);
    }

    void add(Body body) {
        assert (this.m_bodyCount < this.m_bodyCapacity);
        body.m_islandIndex = this.m_bodyCount;
        this.m_bodies[this.m_bodyCount] = body;
        ++this.m_bodyCount;
    }

    void add(Contact contact) {
        assert (this.m_contactCount < this.m_contactCapacity);
        this.m_contacts[this.m_contactCount++] = contact;
    }

    void add(Joint joint) {
        assert (this.m_jointCount < this.m_jointCapacity);
        this.m_joints[this.m_jointCount++] = joint;
    }

    private void report(ContactVelocityConstraint[] constraints) {
        if (this.listener == null) {
            return;
        }
        for (int i = 0; i < this.m_contactCount; ++i) {
            Contact c = this.m_contacts[i];
            ContactVelocityConstraint vc = constraints[i];
            this.impulse.count = vc.pointCount;
            for (int j = 0; j < vc.pointCount; ++j) {
                this.impulse.normalImpulses[j] = vc.points[j].normalImpulse;
                this.impulse.tangentImpulses[j] = vc.points[j].tangentImpulse;
            }
            this.listener.postSolve(c, this.impulse);
        }
    }
}

