/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.contacts;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.collision.ManifoldPoint;
import com.almasb.fxgl.physics.box2d.collision.WorldManifold;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Mat22;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.TimeStep;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactPositionConstraint;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactVelocityConstraint;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Position;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Velocity;

public final class ContactSolver {
    private static final float k_errorTol = 0.001f;
    private static final int INITIAL_NUM_CONSTRAINTS = 256;
    private static final float k_maxConditionNumber = 100.0f;
    public Position[] m_positions;
    public Velocity[] m_velocities;
    public ContactPositionConstraint[] m_positionConstraints = new ContactPositionConstraint[256];
    public ContactVelocityConstraint[] m_velocityConstraints = new ContactVelocityConstraint[256];
    private Contact[] m_contacts;
    private int m_count;
    private final Transform xfA = new Transform();
    private final Transform xfB = new Transform();
    private final WorldManifold worldManifold = new WorldManifold();
    private final PositionSolverManifold psolver = new PositionSolverManifold();

    public ContactSolver() {
        for (int i = 0; i < 256; ++i) {
            this.m_positionConstraints[i] = new ContactPositionConstraint();
            this.m_velocityConstraints[i] = new ContactVelocityConstraint();
        }
    }

    public void init(ContactSolverDef def) {
        int i;
        Object[] old;
        TimeStep step = def.step;
        this.m_count = def.count;
        if (this.m_positionConstraints.length < this.m_count) {
            old = this.m_positionConstraints;
            this.m_positionConstraints = new ContactPositionConstraint[JBoxUtils.max(old.length * 2, this.m_count)];
            System.arraycopy(old, 0, this.m_positionConstraints, 0, old.length);
            for (i = old.length; i < this.m_positionConstraints.length; ++i) {
                this.m_positionConstraints[i] = new ContactPositionConstraint();
            }
        }
        if (this.m_velocityConstraints.length < this.m_count) {
            old = this.m_velocityConstraints;
            this.m_velocityConstraints = new ContactVelocityConstraint[JBoxUtils.max(old.length * 2, this.m_count)];
            System.arraycopy(old, 0, this.m_velocityConstraints, 0, old.length);
            for (i = old.length; i < this.m_velocityConstraints.length; ++i) {
                this.m_velocityConstraints[i] = new ContactVelocityConstraint();
            }
        }
        this.m_positions = def.positions;
        this.m_velocities = def.velocities;
        this.m_contacts = def.contacts;
        for (int i2 = 0; i2 < this.m_count; ++i2) {
            Contact contact = this.m_contacts[i2];
            Fixture fixtureA = contact.m_fixtureA;
            Fixture fixtureB = contact.m_fixtureB;
            Shape shapeA = fixtureA.getShape();
            Shape shapeB = fixtureB.getShape();
            float radiusA = shapeA.getRadius();
            float radiusB = shapeB.getRadius();
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            Manifold manifold = contact.getManifold();
            int pointCount = manifold.pointCount;
            assert (pointCount > 0);
            ContactVelocityConstraint vc = this.m_velocityConstraints[i2];
            vc.friction = contact.m_friction;
            vc.restitution = contact.m_restitution;
            vc.tangentSpeed = contact.m_tangentSpeed;
            vc.indexA = bodyA.m_islandIndex;
            vc.indexB = bodyB.m_islandIndex;
            vc.invMassA = bodyA.m_invMass;
            vc.invMassB = bodyB.m_invMass;
            vc.invIA = bodyA.m_invI;
            vc.invIB = bodyB.m_invI;
            vc.contactIndex = i2;
            vc.pointCount = pointCount;
            vc.K.setZero();
            vc.normalMass.setZero();
            ContactPositionConstraint pc = this.m_positionConstraints[i2];
            pc.indexA = bodyA.m_islandIndex;
            pc.indexB = bodyB.m_islandIndex;
            pc.invMassA = bodyA.m_invMass;
            pc.invMassB = bodyB.m_invMass;
            pc.localCenterA.set(bodyA.m_sweep.localCenter);
            pc.localCenterB.set(bodyB.m_sweep.localCenter);
            pc.invIA = bodyA.m_invI;
            pc.invIB = bodyB.m_invI;
            pc.localNormal.set(manifold.localNormal);
            pc.localPoint.set(manifold.localPoint);
            pc.pointCount = pointCount;
            pc.radiusA = radiusA;
            pc.radiusB = radiusB;
            pc.type = manifold.type;
            for (int j = 0; j < pointCount; ++j) {
                ManifoldPoint cp = manifold.points[j];
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                if (step.warmStarting) {
                    vcp.normalImpulse = step.dtRatio * cp.normalImpulse;
                    vcp.tangentImpulse = step.dtRatio * cp.tangentImpulse;
                } else {
                    vcp.normalImpulse = 0.0f;
                    vcp.tangentImpulse = 0.0f;
                }
                vcp.rA.setZero();
                vcp.rB.setZero();
                vcp.normalMass = 0.0f;
                vcp.tangentMass = 0.0f;
                vcp.velocityBias = 0.0f;
                pc.localPoints[j].x = cp.localPoint.x;
                pc.localPoints[j].y = cp.localPoint.y;
            }
        }
    }

    public void warmStart() {
        for (int i = 0; i < this.m_count; ++i) {
            ContactVelocityConstraint vc = this.m_velocityConstraints[i];
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float iA = vc.invIA;
            float mB = vc.invMassB;
            float iB = vc.invIB;
            int pointCount = vc.pointCount;
            Vec2 vA = this.m_velocities[indexA].v;
            float wA = this.m_velocities[indexA].w;
            Vec2 vB = this.m_velocities[indexB].v;
            float wB = this.m_velocities[indexB].w;
            Vec2 normal = vc.normal;
            float tangentx = 1.0f * normal.y;
            float tangenty = -1.0f * normal.x;
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                float Px = tangentx * vcp.tangentImpulse + normal.x * vcp.normalImpulse;
                float Py = tangenty * vcp.tangentImpulse + normal.y * vcp.normalImpulse;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
            }
            this.m_velocities[indexA].w = wA;
            this.m_velocities[indexB].w = wB;
        }
    }

    public void initializeVelocityConstraints() {
        for (int i = 0; i < this.m_count; ++i) {
            ContactVelocityConstraint vc = this.m_velocityConstraints[i];
            ContactPositionConstraint pc = this.m_positionConstraints[i];
            float radiusA = pc.radiusA;
            float radiusB = pc.radiusB;
            Manifold manifold = this.m_contacts[vc.contactIndex].getManifold();
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float mB = vc.invMassB;
            float iA = vc.invIA;
            float iB = vc.invIB;
            Vec2 localCenterA = pc.localCenterA;
            Vec2 localCenterB = pc.localCenterB;
            Vec2 cA = this.m_positions[indexA].c;
            float aA = this.m_positions[indexA].a;
            Vec2 vA = this.m_velocities[indexA].v;
            float wA = this.m_velocities[indexA].w;
            Vec2 cB = this.m_positions[indexB].c;
            float aB = this.m_positions[indexB].a;
            Vec2 vB = this.m_velocities[indexB].v;
            float wB = this.m_velocities[indexB].w;
            assert (manifold.pointCount > 0);
            Rotation xfAq = this.xfA.q;
            Rotation xfBq = this.xfB.q;
            xfAq.set(aA);
            xfBq.set(aB);
            this.xfA.p.x = cA.x - (xfAq.c * localCenterA.x - xfAq.s * localCenterA.y);
            this.xfA.p.y = cA.y - (xfAq.s * localCenterA.x + xfAq.c * localCenterA.y);
            this.xfB.p.x = cB.x - (xfBq.c * localCenterB.x - xfBq.s * localCenterB.y);
            this.xfB.p.y = cB.y - (xfBq.s * localCenterB.x + xfBq.c * localCenterB.y);
            this.worldManifold.initialize(manifold, this.xfA, radiusA, this.xfB, radiusB);
            Vec2 vcnormal = vc.normal;
            vcnormal.x = this.worldManifold.normal.x;
            vcnormal.y = this.worldManifold.normal.y;
            int pointCount = vc.pointCount;
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                Vec2 wmPj = this.worldManifold.points[j];
                Vec2 vcprA = vcp.rA;
                Vec2 vcprB = vcp.rB;
                vcprA.x = wmPj.x - cA.x;
                vcprA.y = wmPj.y - cA.y;
                vcprB.x = wmPj.x - cB.x;
                vcprB.y = wmPj.y - cB.y;
                float rnA = vcprA.x * vcnormal.y - vcprA.y * vcnormal.x;
                float rnB = vcprB.x * vcnormal.y - vcprB.y * vcnormal.x;
                float kNormal = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                vcp.normalMass = kNormal > 0.0f ? 1.0f / kNormal : 0.0f;
                float tangentx = 1.0f * vcnormal.y;
                float tangenty = -1.0f * vcnormal.x;
                float rtA = vcprA.x * tangenty - vcprA.y * tangentx;
                float rtB = vcprB.x * tangenty - vcprB.y * tangentx;
                float kTangent = mA + mB + iA * rtA * rtA + iB * rtB * rtB;
                vcp.tangentMass = kTangent > 0.0f ? 1.0f / kTangent : 0.0f;
                vcp.velocityBias = 0.0f;
                float tempx = vB.x + -wB * vcprB.y - vA.x - -wA * vcprA.y;
                float tempy = vB.y + wB * vcprB.x - vA.y - wA * vcprA.x;
                float vRel = vcnormal.x * tempx + vcnormal.y * tempy;
                if (!(vRel < -JBoxSettings.velocityThreshold)) continue;
                vcp.velocityBias = -vc.restitution * vRel;
            }
            if (vc.pointCount != 2) continue;
            ContactVelocityConstraint.VelocityConstraintPoint vcp1 = vc.points[0];
            ContactVelocityConstraint.VelocityConstraintPoint vcp2 = vc.points[1];
            float rn1A = vcp1.rA.x * vcnormal.y - vcp1.rA.y * vcnormal.x;
            float rn1B = vcp1.rB.x * vcnormal.y - vcp1.rB.y * vcnormal.x;
            float k11 = mA + mB + iA * rn1A * rn1A + iB * rn1B * rn1B;
            float rn2A = vcp2.rA.x * vcnormal.y - vcp2.rA.y * vcnormal.x;
            float rn2B = vcp2.rB.x * vcnormal.y - vcp2.rB.y * vcnormal.x;
            float k22 = mA + mB + iA * rn2A * rn2A + iB * rn2B * rn2B;
            float k12 = mA + mB + iA * rn1A * rn2A + iB * rn1B * rn2B;
            if (k11 * k11 < 100.0f * (k11 * k22 - k12 * k12)) {
                vc.K.ex.x = k11;
                vc.K.ex.y = k12;
                vc.K.ey.x = k12;
                vc.K.ey.y = k22;
                vc.K.invertToOut(vc.normalMass);
                continue;
            }
            vc.pointCount = 1;
        }
    }

    public void solveVelocityConstraints() {
        for (int i = 0; i < this.m_count; ++i) {
            ContactVelocityConstraint vc = this.m_velocityConstraints[i];
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float mB = vc.invMassB;
            float iA = vc.invIA;
            float iB = vc.invIB;
            int pointCount = vc.pointCount;
            Vec2 vA = this.m_velocities[indexA].v;
            float wA = this.m_velocities[indexA].w;
            Vec2 vB = this.m_velocities[indexB].v;
            float wB = this.m_velocities[indexB].w;
            Vec2 normal = vc.normal;
            float normalx = normal.x;
            float normaly = normal.y;
            float tangentx = 1.0f * vc.normal.y;
            float tangenty = -1.0f * vc.normal.x;
            float friction = vc.friction;
            assert (pointCount == 1 || pointCount == 2);
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                Vec2 a = vcp.rA;
                float dvx = -wB * vcp.rB.y + vB.x - vA.x + wA * a.y;
                float dvy = wB * vcp.rB.x + vB.y - vA.y - wA * a.x;
                float vt = dvx * tangentx + dvy * tangenty - vc.tangentSpeed;
                float lambda = vcp.tangentMass * -vt;
                float maxFriction = friction * vcp.normalImpulse;
                float newImpulse = JBoxUtils.clamp(vcp.tangentImpulse + lambda, -maxFriction, maxFriction);
                lambda = newImpulse - vcp.tangentImpulse;
                vcp.tangentImpulse = newImpulse;
                float Px = tangentx * lambda;
                float Py = tangenty * lambda;
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
            }
            if (vc.pointCount == 1) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[0];
                float dvx = -wB * vcp.rB.y + vB.x - vA.x + wA * vcp.rA.y;
                float dvy = wB * vcp.rB.x + vB.y - vA.y - wA * vcp.rA.x;
                float vn = dvx * normalx + dvy * normaly;
                float lambda = -vcp.normalMass * (vn - vcp.velocityBias);
                float a = vcp.normalImpulse + lambda;
                float newImpulse = a > 0.0f ? a : 0.0f;
                lambda = newImpulse - vcp.normalImpulse;
                vcp.normalImpulse = newImpulse;
                float Px = normalx * lambda;
                float Py = normaly * lambda;
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
            } else {
                float P2y;
                float P2x;
                float P1y;
                float P1x;
                float dy;
                float dx;
                ContactVelocityConstraint.VelocityConstraintPoint cp1 = vc.points[0];
                ContactVelocityConstraint.VelocityConstraintPoint cp2 = vc.points[1];
                Vec2 cp1rA = cp1.rA;
                Vec2 cp1rB = cp1.rB;
                Vec2 cp2rA = cp2.rA;
                Vec2 cp2rB = cp2.rB;
                float ax = cp1.normalImpulse;
                float ay = cp2.normalImpulse;
                assert (ax >= 0.0f && ay >= 0.0f);
                float dv1x = -wB * cp1rB.y + vB.x - vA.x + wA * cp1rA.y;
                float dv1y = wB * cp1rB.x + vB.y - vA.y - wA * cp1rA.x;
                float dv2x = -wB * cp2rB.y + vB.x - vA.x + wA * cp2rA.y;
                float dv2y = wB * cp2rB.x + vB.y - vA.y - wA * cp2rA.x;
                float vn1 = dv1x * normalx + dv1y * normaly;
                float vn2 = dv2x * normalx + dv2y * normaly;
                float bx = vn1 - cp1.velocityBias;
                float by = vn2 - cp2.velocityBias;
                Mat22 R = vc.K;
                Mat22 R1 = vc.normalMass;
                float xx = R1.ex.x * (bx -= R.ex.x * ax + R.ey.x * ay) + R1.ey.x * (by -= R.ex.y * ax + R.ey.y * ay);
                float xy = R1.ex.y * bx + R1.ey.y * by;
                xx *= -1.0f;
                xy *= -1.0f;
                if (xx >= 0.0f && xy >= 0.0f) {
                    dx = xx - ax;
                    dy = xy - ay;
                    P1x = dx * normalx;
                    P1y = dx * normaly;
                    P2x = dy * normalx;
                    P2y = dy * normaly;
                    vA.x -= mA * (P1x + P2x);
                    vA.y -= mA * (P1y + P2y);
                    vB.x += mB * (P1x + P2x);
                    vB.y += mB * (P1y + P2y);
                    wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                    wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                    cp1.normalImpulse = xx;
                    cp2.normalImpulse = xy;
                } else {
                    xx = -cp1.normalMass * bx;
                    xy = 0.0f;
                    vn1 = 0.0f;
                    vn2 = vc.K.ex.y * xx + by;
                    if (xx >= 0.0f && vn2 >= 0.0f) {
                        dx = xx - ax;
                        dy = xy - ay;
                        P1x = normalx * dx;
                        P1y = normaly * dx;
                        P2x = normalx * dy;
                        P2y = normaly * dy;
                        vA.x -= mA * (P1x + P2x);
                        vA.y -= mA * (P1y + P2y);
                        vB.x += mB * (P1x + P2x);
                        vB.y += mB * (P1y + P2y);
                        wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                        wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                        cp1.normalImpulse = xx;
                        cp2.normalImpulse = xy;
                    } else {
                        xx = 0.0f;
                        xy = -cp2.normalMass * by;
                        vn1 = vc.K.ey.x * xy + bx;
                        vn2 = 0.0f;
                        if (xy >= 0.0f && vn1 >= 0.0f) {
                            dx = xx - ax;
                            dy = xy - ay;
                            P1x = normalx * dx;
                            P1y = normaly * dx;
                            P2x = normalx * dy;
                            P2y = normaly * dy;
                            vA.x -= mA * (P1x + P2x);
                            vA.y -= mA * (P1y + P2y);
                            vB.x += mB * (P1x + P2x);
                            vB.y += mB * (P1y + P2y);
                            wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                            wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                            cp1.normalImpulse = xx;
                            cp2.normalImpulse = xy;
                        } else {
                            xx = 0.0f;
                            xy = 0.0f;
                            vn1 = bx;
                            vn2 = by;
                            if (vn1 >= 0.0f && vn2 >= 0.0f) {
                                dx = xx - ax;
                                dy = xy - ay;
                                P1x = normalx * dx;
                                P1y = normaly * dx;
                                P2x = normalx * dy;
                                P2y = normaly * dy;
                                vA.x -= mA * (P1x + P2x);
                                vA.y -= mA * (P1y + P2y);
                                vB.x += mB * (P1x + P2x);
                                vB.y += mB * (P1y + P2y);
                                wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                                wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                                cp1.normalImpulse = xx;
                                cp2.normalImpulse = xy;
                            }
                        }
                    }
                }
            }
            this.m_velocities[indexA].w = wA;
            this.m_velocities[indexB].w = wB;
        }
    }

    public void storeImpulses() {
        for (int i = 0; i < this.m_count; ++i) {
            ContactVelocityConstraint vc = this.m_velocityConstraints[i];
            Manifold manifold = this.m_contacts[vc.contactIndex].getManifold();
            for (int j = 0; j < vc.pointCount; ++j) {
                manifold.points[j].normalImpulse = vc.points[j].normalImpulse;
                manifold.points[j].tangentImpulse = vc.points[j].tangentImpulse;
            }
        }
    }

    public boolean solvePositionConstraints() {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_count; ++i) {
            ContactPositionConstraint pc = this.m_positionConstraints[i];
            int indexA = pc.indexA;
            int indexB = pc.indexB;
            float mA = pc.invMassA;
            float iA = pc.invIA;
            Vec2 localCenterA = pc.localCenterA;
            float localCenterAx = localCenterA.x;
            float localCenterAy = localCenterA.y;
            float mB = pc.invMassB;
            float iB = pc.invIB;
            Vec2 localCenterB = pc.localCenterB;
            float localCenterBx = localCenterB.x;
            float localCenterBy = localCenterB.y;
            int pointCount = pc.pointCount;
            Vec2 cA = this.m_positions[indexA].c;
            float aA = this.m_positions[indexA].a;
            Vec2 cB = this.m_positions[indexB].c;
            float aB = this.m_positions[indexB].a;
            for (int j = 0; j < pointCount; ++j) {
                Rotation xfAq = this.xfA.q;
                Rotation xfBq = this.xfB.q;
                xfAq.set(aA);
                xfBq.set(aB);
                this.xfA.p.x = cA.x - xfAq.c * localCenterAx + xfAq.s * localCenterAy;
                this.xfA.p.y = cA.y - xfAq.s * localCenterAx - xfAq.c * localCenterAy;
                this.xfB.p.x = cB.x - xfBq.c * localCenterBx + xfBq.s * localCenterBy;
                this.xfB.p.y = cB.y - xfBq.s * localCenterBx - xfBq.c * localCenterBy;
                PositionSolverManifold psm = this.psolver;
                psm.initialize(pc, this.xfA, this.xfB, j);
                Vec2 normal = psm.normal;
                Vec2 point = psm.point;
                float separation = psm.separation;
                float rAx = point.x - cA.x;
                float rAy = point.y - cA.y;
                float rBx = point.x - cB.x;
                float rBy = point.y - cB.y;
                minSeparation = JBoxUtils.min(minSeparation, separation);
                float C = JBoxUtils.clamp(JBoxSettings.baumgarte * (separation + JBoxSettings.linearSlop), -JBoxSettings.maxLinearCorrection, 0.0f);
                float rnA = rAx * normal.y - rAy * normal.x;
                float rnB = rBx * normal.y - rBy * normal.x;
                float K = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                float Px = normal.x * impulse;
                float Py = normal.y * impulse;
                cA.x -= Px * mA;
                cA.y -= Py * mA;
                aA -= iA * (rAx * Py - rAy * Px);
                cB.x += Px * mB;
                cB.y += Py * mB;
                aB += iB * (rBx * Py - rBy * Px);
            }
            this.m_positions[indexA].a = aA;
            this.m_positions[indexB].a = aB;
        }
        return minSeparation >= -3.0f * JBoxSettings.linearSlop;
    }

    public boolean solveTOIPositionConstraints(int toiIndexA, int toiIndexB) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_count; ++i) {
            ContactPositionConstraint pc = this.m_positionConstraints[i];
            int indexA = pc.indexA;
            int indexB = pc.indexB;
            Vec2 localCenterA = pc.localCenterA;
            Vec2 localCenterB = pc.localCenterB;
            float localCenterAx = localCenterA.x;
            float localCenterAy = localCenterA.y;
            float localCenterBx = localCenterB.x;
            float localCenterBy = localCenterB.y;
            int pointCount = pc.pointCount;
            float mA = 0.0f;
            float iA = 0.0f;
            if (indexA == toiIndexA || indexA == toiIndexB) {
                mA = pc.invMassA;
                iA = pc.invIA;
            }
            float mB = 0.0f;
            float iB = 0.0f;
            if (indexB == toiIndexA || indexB == toiIndexB) {
                mB = pc.invMassB;
                iB = pc.invIB;
            }
            Vec2 cA = this.m_positions[indexA].c;
            float aA = this.m_positions[indexA].a;
            Vec2 cB = this.m_positions[indexB].c;
            float aB = this.m_positions[indexB].a;
            for (int j = 0; j < pointCount; ++j) {
                Rotation xfAq = this.xfA.q;
                Rotation xfBq = this.xfB.q;
                xfAq.set(aA);
                xfBq.set(aB);
                this.xfA.p.x = cA.x - xfAq.c * localCenterAx + xfAq.s * localCenterAy;
                this.xfA.p.y = cA.y - xfAq.s * localCenterAx - xfAq.c * localCenterAy;
                this.xfB.p.x = cB.x - xfBq.c * localCenterBx + xfBq.s * localCenterBy;
                this.xfB.p.y = cB.y - xfBq.s * localCenterBx - xfBq.c * localCenterBy;
                PositionSolverManifold psm = this.psolver;
                psm.initialize(pc, this.xfA, this.xfB, j);
                Vec2 normal = psm.normal;
                Vec2 point = psm.point;
                float separation = psm.separation;
                float rAx = point.x - cA.x;
                float rAy = point.y - cA.y;
                float rBx = point.x - cB.x;
                float rBy = point.y - cB.y;
                minSeparation = JBoxUtils.min(minSeparation, separation);
                float C = JBoxUtils.clamp(JBoxSettings.toiBaugarte * (separation + JBoxSettings.linearSlop), -JBoxSettings.maxLinearCorrection, 0.0f);
                float rnA = rAx * normal.y - rAy * normal.x;
                float rnB = rBx * normal.y - rBy * normal.x;
                float K = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                float Px = normal.x * impulse;
                float Py = normal.y * impulse;
                cA.x -= Px * mA;
                cA.y -= Py * mA;
                aA -= iA * (rAx * Py - rAy * Px);
                cB.x += Px * mB;
                cB.y += Py * mB;
                aB += iB * (rBx * Py - rBy * Px);
            }
            this.m_positions[indexA].a = aA;
            this.m_positions[indexB].a = aB;
        }
        return minSeparation >= -1.5f * JBoxSettings.linearSlop;
    }

    private static class PositionSolverManifold {
        final Vec2 normal = new Vec2();
        final Vec2 point = new Vec2();
        float separation;

        private PositionSolverManifold() {
        }

        public void initialize(ContactPositionConstraint pc, Transform xfA, Transform xfB, int index) {
            assert (pc.pointCount > 0);
            Rotation xfAq = xfA.q;
            Rotation xfBq = xfB.q;
            Vec2 pcLocalPointsI = pc.localPoints[index];
            switch (pc.type) {
                case CIRCLES: {
                    Vec2 plocalPoint = pc.localPoint;
                    Vec2 pLocalPoints0 = pc.localPoints[0];
                    float pointAx = xfAq.c * plocalPoint.x - xfAq.s * plocalPoint.y + xfA.p.x;
                    float pointAy = xfAq.s * plocalPoint.x + xfAq.c * plocalPoint.y + xfA.p.y;
                    float pointBx = xfBq.c * pLocalPoints0.x - xfBq.s * pLocalPoints0.y + xfB.p.x;
                    float pointBy = xfBq.s * pLocalPoints0.x + xfBq.c * pLocalPoints0.y + xfB.p.y;
                    this.normal.x = pointBx - pointAx;
                    this.normal.y = pointBy - pointAy;
                    this.normal.getLengthAndNormalize();
                    this.point.x = (pointAx + pointBx) * 0.5f;
                    this.point.y = (pointAy + pointBy) * 0.5f;
                    float tempx = pointBx - pointAx;
                    float tempy = pointBy - pointAy;
                    this.separation = tempx * this.normal.x + tempy * this.normal.y - pc.radiusA - pc.radiusB;
                    break;
                }
                case FACE_A: {
                    Vec2 pcLocalNormal = pc.localNormal;
                    Vec2 pcLocalPoint = pc.localPoint;
                    this.normal.x = xfAq.c * pcLocalNormal.x - xfAq.s * pcLocalNormal.y;
                    this.normal.y = xfAq.s * pcLocalNormal.x + xfAq.c * pcLocalNormal.y;
                    float planePointx = xfAq.c * pcLocalPoint.x - xfAq.s * pcLocalPoint.y + xfA.p.x;
                    float planePointy = xfAq.s * pcLocalPoint.x + xfAq.c * pcLocalPoint.y + xfA.p.y;
                    float clipPointx = xfBq.c * pcLocalPointsI.x - xfBq.s * pcLocalPointsI.y + xfB.p.x;
                    float clipPointy = xfBq.s * pcLocalPointsI.x + xfBq.c * pcLocalPointsI.y + xfB.p.y;
                    float tempx = clipPointx - planePointx;
                    float tempy = clipPointy - planePointy;
                    this.separation = tempx * this.normal.x + tempy * this.normal.y - pc.radiusA - pc.radiusB;
                    this.point.x = clipPointx;
                    this.point.y = clipPointy;
                    break;
                }
                case FACE_B: {
                    Vec2 pcLocalNormal = pc.localNormal;
                    Vec2 pcLocalPoint = pc.localPoint;
                    this.normal.x = xfBq.c * pcLocalNormal.x - xfBq.s * pcLocalNormal.y;
                    this.normal.y = xfBq.s * pcLocalNormal.x + xfBq.c * pcLocalNormal.y;
                    float planePointx = xfBq.c * pcLocalPoint.x - xfBq.s * pcLocalPoint.y + xfB.p.x;
                    float planePointy = xfBq.s * pcLocalPoint.x + xfBq.c * pcLocalPoint.y + xfB.p.y;
                    float clipPointx = xfAq.c * pcLocalPointsI.x - xfAq.s * pcLocalPointsI.y + xfA.p.x;
                    float clipPointy = xfAq.s * pcLocalPointsI.x + xfAq.c * pcLocalPointsI.y + xfA.p.y;
                    float tempx = clipPointx - planePointx;
                    float tempy = clipPointy - planePointy;
                    this.separation = tempx * this.normal.x + tempy * this.normal.y - pc.radiusA - pc.radiusB;
                    this.point.x = clipPointx;
                    this.point.y = clipPointy;
                    this.normal.x *= -1.0f;
                    this.normal.y *= -1.0f;
                }
            }
        }
    }

    public static class ContactSolverDef {
        public TimeStep step;
        public Contact[] contacts;
        public int count;
        public Position[] positions;
        public Velocity[] velocities;
    }
}

