/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.joints;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Mat22;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.dynamics.SolverData;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.MotorJointDef;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public class MotorJoint
extends Joint {
    private final Vec2 linearOffset = new Vec2();
    private float angularOffset;
    private final Vec2 linearImpulse = new Vec2();
    private float angularImpulse;
    private float maxForce;
    private float maxTorque;
    private float correctionFactor;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private final Vec2 m_linearError = new Vec2();
    private float m_angularError;
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Mat22 m_linearMass = new Mat22();
    private float m_angularMass;

    public MotorJoint(IWorldPool pool, MotorJointDef def) {
        super(pool, def);
        this.linearOffset.set(def.linearOffset);
        this.angularOffset = def.angularOffset;
        this.angularImpulse = 0.0f;
        this.maxForce = def.maxForce;
        this.maxTorque = def.maxTorque;
        this.correctionFactor = def.correctionFactor;
    }

    @Override
    public void getAnchorA(Vec2 out) {
        out.set(this.m_bodyA.getPosition());
    }

    @Override
    public void getAnchorB(Vec2 out) {
        out.set(this.m_bodyB.getPosition());
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 out) {
        out.set(this.linearImpulse).mulLocal((double)inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return this.angularImpulse * inv_dt;
    }

    public float getCorrectionFactor() {
        return this.correctionFactor;
    }

    public void setCorrectionFactor(float correctionFactor) {
        this.correctionFactor = correctionFactor;
    }

    public void setLinearOffset(Vec2 linearOffset) {
        if (linearOffset.x != this.linearOffset.x || linearOffset.y != this.linearOffset.y) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.linearOffset.set(linearOffset);
        }
    }

    public void getLinearOffset(Vec2 out) {
        out.set(this.linearOffset);
    }

    public Vec2 getLinearOffset() {
        return this.linearOffset;
    }

    public void setAngularOffset(float angularOffset) {
        if (angularOffset != this.angularOffset) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.angularOffset = angularOffset;
        }
    }

    public float getAngularOffset() {
        return this.angularOffset;
    }

    public void setMaxForce(float force) {
        assert (force >= 0.0f);
        this.maxForce = force;
    }

    public float getMaxForce() {
        return this.maxForce;
    }

    public void setMaxTorque(float torque) {
        assert (torque >= 0.0f);
        this.maxTorque = torque;
    }

    public float getMaxTorque() {
        return this.maxTorque;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 cA = data.positions[this.m_indexA].c;
        float aA = data.positions[this.m_indexA].a;
        Vec2 vA = data.velocities[this.m_indexA].v;
        float wA = data.velocities[this.m_indexA].w;
        Vec2 cB = data.positions[this.m_indexB].c;
        float aB = data.positions[this.m_indexB].a;
        Vec2 vB = data.velocities[this.m_indexB].v;
        float wB = data.velocities[this.m_indexB].w;
        Rotation qA = this.pool.popRot();
        Rotation qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        Mat22 K = this.pool.popMat22();
        qA.set(aA);
        qB.set(aB);
        this.m_rA.x = qA.c * -this.m_localCenterA.x - qA.s * -this.m_localCenterA.y;
        this.m_rA.y = qA.s * -this.m_localCenterA.x + qA.c * -this.m_localCenterA.y;
        this.m_rB.x = qB.c * -this.m_localCenterB.x - qB.s * -this.m_localCenterB.y;
        this.m_rB.y = qB.s * -this.m_localCenterB.x + qB.c * -this.m_localCenterB.y;
        float mA = this.m_invMassA;
        float mB = this.m_invMassB;
        float iA = this.m_invIA;
        float iB = this.m_invIB;
        K.ex.x = mA + mB + iA * this.m_rA.y * this.m_rA.y + iB * this.m_rB.y * this.m_rB.y;
        K.ey.x = K.ex.y = -iA * this.m_rA.x * this.m_rA.y - iB * this.m_rB.x * this.m_rB.y;
        K.ey.y = mA + mB + iA * this.m_rA.x * this.m_rA.x + iB * this.m_rB.x * this.m_rB.x;
        K.invertToOut(this.m_linearMass);
        this.m_angularMass = iA + iB;
        if (this.m_angularMass > 0.0f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        Rotation.mulToOutUnsafe(qA, this.linearOffset, temp);
        this.m_linearError.x = cB.x + this.m_rB.x - cA.x - this.m_rA.x - temp.x;
        this.m_linearError.y = cB.y + this.m_rB.y - cA.y - this.m_rA.y - temp.y;
        this.m_angularError = aB - aA - this.angularOffset;
        if (data.step.warmStarting) {
            this.linearImpulse.x *= data.step.dtRatio;
            this.linearImpulse.y *= data.step.dtRatio;
            this.angularImpulse *= data.step.dtRatio;
            Vec2 P = this.linearImpulse;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (this.m_rA.x * P.y - this.m_rA.y * P.x + this.angularImpulse);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (this.m_rB.x * P.y - this.m_rB.y * P.x + this.angularImpulse);
        } else {
            this.linearImpulse.setZero();
            this.angularImpulse = 0.0f;
        }
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
        this.pool.pushRot(2);
        data.velocities[this.m_indexA].w = wA;
        data.velocities[this.m_indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.m_indexA].v;
        float wA = data.velocities[this.m_indexA].w;
        Vec2 vB = data.velocities[this.m_indexB].v;
        float wB = data.velocities[this.m_indexB].w;
        float mA = this.m_invMassA;
        float mB = this.m_invMassB;
        float iA = this.m_invIA;
        float iB = this.m_invIB;
        float h = data.step.dt;
        float inv_h = data.step.inv_dt;
        Vec2 temp = this.pool.popVec2();
        float Cdot = wB - wA + inv_h * this.correctionFactor * this.m_angularError;
        float impulse = -this.m_angularMass * Cdot;
        float oldImpulse = this.angularImpulse;
        float maxImpulse = h * this.maxTorque;
        this.angularImpulse = JBoxUtils.clamp(this.angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.angularImpulse - oldImpulse;
        Vec2 Cdot2 = this.pool.popVec2();
        Cdot2.x = vB.x + -(wB += iB * impulse) * this.m_rB.y - vA.x - -(wA -= iA * impulse) * this.m_rA.y + inv_h * this.correctionFactor * this.m_linearError.x;
        Cdot2.y = vB.y + wB * this.m_rB.x - vA.y - wA * this.m_rA.x + inv_h * this.correctionFactor * this.m_linearError.y;
        Vec2 impulse2 = temp;
        Mat22.mulToOutUnsafe(this.m_linearMass, Cdot2, impulse2);
        impulse2.negateLocal();
        Vec2 oldImpulse2 = this.pool.popVec2();
        oldImpulse2.set(this.linearImpulse);
        this.linearImpulse.addLocal(impulse2);
        maxImpulse = h * this.maxForce;
        if (this.linearImpulse.lengthSquared() > maxImpulse * maxImpulse) {
            this.linearImpulse.getLengthAndNormalize();
            this.linearImpulse.mulLocal((double)maxImpulse);
        }
        impulse2.x = this.linearImpulse.x - oldImpulse2.x;
        impulse2.y = this.linearImpulse.y - oldImpulse2.y;
        vA.x -= mA * impulse2.x;
        vA.y -= mA * impulse2.y;
        vB.x += mB * impulse2.x;
        vB.y += mB * impulse2.y;
        this.pool.pushVec2(3);
        data.velocities[this.m_indexA].w = wA -= iA * (this.m_rA.x * impulse2.y - this.m_rA.y * impulse2.x);
        data.velocities[this.m_indexB].w = wB += iB * (this.m_rB.x * impulse2.y - this.m_rB.y * impulse2.x);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        return true;
    }
}

