/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio;

import com.almasb.fxgl.audio.Audio;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.sslogger.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/audio/AudioPlayer;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "activeMusic", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "Lcom/almasb/fxgl/audio/Music;", "activeSounds", "Lcom/almasb/fxgl/audio/Sound;", "log", "Lcom/almasb/sslogger/Logger;", "musicVolume", "Ljavafx/beans/property/DoubleProperty;", "soundVolume", "loopMusic", "", "music", "onExit", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "onMainLoopStarting", "onUpdate", "tpf", "", "pauseMusic", "playMusic", "playSound", "sound", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "resumeMusic", "stopMusic", "stopSound", "write", "fxgl-media"})
public final class AudioPlayer
implements EngineService {
    private final Logger log = Logger.Companion.get(this.getClass());
    private final UnorderedArray<Music> activeMusic = new UnorderedArray(0, 1, null);
    private final UnorderedArray<Sound> activeSounds = new UnorderedArray(0, 1, null);
    @Inject(value="globalMusicVolumeProperty")
    private DoubleProperty musicVolume;
    @Inject(value="globalSoundVolumeProperty")
    private DoubleProperty soundVolume;

    public void onMainLoopStarting() {
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"musicVolume");
        }
        doubleProperty.addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ AudioPlayer this$0;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number newVolume) {
                Iterable $this$forEach$iv = (Iterable)AudioPlayer.access$getActiveMusic$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Music it = (Music)element$iv;
                    boolean bl = false;
                    it.getAudio$fxgl_media().setVolume(newVolume.doubleValue());
                }
            }
            {
                this.this$0 = audioPlayer;
            }
        });
        DoubleProperty doubleProperty2 = this.soundVolume;
        if (doubleProperty2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"soundVolume");
        }
        doubleProperty2.addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ AudioPlayer this$0;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number newVolume) {
                Iterable $this$forEach$iv = (Iterable)AudioPlayer.access$getActiveSounds$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Sound it = (Sound)element$iv;
                    boolean bl = false;
                    it.getAudio$fxgl_media().setVolume(newVolume.doubleValue());
                }
            }
            {
                this.this$0 = audioPlayer;
            }
        });
    }

    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkParameterIsNotNull((Object)vars, (String)"vars");
    }

    public void onExit() {
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
    }

    public void onUpdate(double tpf) {
        CollectionsKt.removeAll((Iterable)((Iterable)this.activeMusic), (Function1)onUpdate.1.INSTANCE);
        CollectionsKt.removeAll((Iterable)((Iterable)this.activeSounds), (Function1)onUpdate.2.INSTANCE);
    }

    public final void playSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        if (!this.activeSounds.containsByIdentity((Object)sound)) {
            this.activeSounds.add((Object)sound);
        }
        Audio audio2 = sound.getAudio$fxgl_media();
        DoubleProperty doubleProperty = this.soundVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"soundVolume");
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"soundVolume.value");
        audio2.setVolume(d);
        sound.getAudio$fxgl_media().play();
    }

    public final void stopSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        sound.getAudio$fxgl_media().stop();
    }

    public final void playMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Playing music " + music);
        if (!this.activeMusic.containsByIdentity((Object)music)) {
            this.activeMusic.add((Object)music);
        }
        Audio audio2 = music.getAudio$fxgl_media();
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"musicVolume");
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"musicVolume.value");
        audio2.setVolume(d);
        music.getAudio$fxgl_media().play();
    }

    public final void pauseMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Pausing music " + music);
        music.getAudio$fxgl_media().pause();
    }

    public final void resumeMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Resuming music " + music);
        music.getAudio$fxgl_media().play();
    }

    public final void stopMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Stopping music " + music);
        music.getAudio$fxgl_media().stop();
    }

    public final void loopMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        music.getAudio$fxgl_media().setLooping(true);
        this.playMusic(music);
    }

    public static final /* synthetic */ UnorderedArray access$getActiveMusic$p(AudioPlayer $this) {
        return $this.activeMusic;
    }

    public static final /* synthetic */ UnorderedArray access$getActiveSounds$p(AudioPlayer $this) {
        return $this.activeSounds;
    }
}

