/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.CursorInfo;
import com.almasb.fxgl.app.EmbeddedPaneWindow;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.FXGLPane;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PrimaryStageWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.IntroScene;
import com.almasb.fxgl.app.scene.LoadingScene;
import com.almasb.fxgl.app.scene.SceneFactory;
import com.almasb.fxgl.app.services.FXGLAssetLoaderService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.PauseMenuBGGen;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputSequence;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.DialogService;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import com.gluonhq.attach.lifecycle.LifecycleEvent;
import com.gluonhq.attach.lifecycle.LifecycleService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication;", "Ljavafx/application/Application;", "()V", "isError", "", "embeddedStart", "Lcom/almasb/fxgl/app/FXGLPane;", "exitFXGL", "", "handleFatalError", "error", "", "initAndLoadLocalization", "initPauseResumeHandler", "initPauseResumeHandlerDesktop", "initPauseResumeHandlerMobile", "initSaveLoadHandler", "postServicesInit", "setFirstSceneAfterStartup", "start", "stage", "Ljavafx/stage/Stage;", "startImpl", "windowSupplier", "Lkotlin/Function0;", "Lcom/almasb/fxgl/app/MainWindow;", "Companion", "GameApplicationService", "InitAppTask", "fxgl"})
@SourceDebugExtension(value={"SMAP\nFXGLApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,722:1\n766#2:723\n857#2,2:724\n1855#2,2:726\n31#3,6:728\n*S KotlinDebug\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication\n*L\n248#1:723\n248#1:724,2\n248#1:726,2\n137#1:728,6\n*E\n"})
public final class FXGLApplication
extends Application {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isError;
    @NotNull
    private static final Logger log = Logger.Companion.get(FXGLApplication.class);
    private static GameApplication app;
    private static ReadOnlyGameSettings settings;
    private static Engine engine;
    private static MainWindow mainWindow;

    private final FXGLPane embeddedStart() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        double d = readOnlyGameSettings.getWidth();
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings2 = null;
        }
        FXGLPane pane = new FXGLPane(d, readOnlyGameSettings2.getHeight());
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(pane){
            final /* synthetic */ FXGLPane $pane;
            {
                this.$pane = $pane;
                super(0);
            }

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings = null;
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                ReadOnlyGameSettings readOnlyGameSettings2 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings2 = null;
                }
                int n = readOnlyGameSettings2.getWidth();
                ReadOnlyGameSettings readOnlyGameSettings3 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings3 = null;
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings3.getHeight());
                ReadOnlyGameSettings readOnlyGameSettings4 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings4 = null;
                }
                return new EmbeddedPaneWindow(this.$pane, fXGLScene, readOnlyGameSettings4);
            }
        }));
        return pane;
    }

    public void start(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(stage){
            final /* synthetic */ Stage $stage;
            {
                this.$stage = $stage;
                super(0);
            }

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings = null;
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                ReadOnlyGameSettings readOnlyGameSettings2 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings2 = null;
                }
                int n = readOnlyGameSettings2.getWidth();
                ReadOnlyGameSettings readOnlyGameSettings3 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings3 = null;
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings3.getHeight());
                ReadOnlyGameSettings readOnlyGameSettings4 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings4 = null;
                }
                return new PrimaryStageWindow(this.$stage, fXGLScene, readOnlyGameSettings4);
            }
        }));
    }

    private final void startImpl(Function0<? extends MainWindow> windowSupplier) {
        GameApplication gameApplication;
        Engine engine;
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> FXGLApplication.startImpl$lambda$0(this, arg_0, arg_1));
        log.debug("Initializing FXGL");
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        if ((engine = (FXGLApplication.engine = new Engine(readOnlyGameSettings))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        if ((gameApplication = app) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            gameApplication = null;
        }
        FXGL.Companion.inject$fxgl(engine, gameApplication, this);
        mainWindow = (MainWindow)windowSupplier.invoke();
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            mainWindow = null;
        }
        mainWindow.show();
        Task task2 = IOTask.ofVoid(() -> FXGLApplication.startImpl$lambda$2(this)).onSuccess(arg_0 -> FXGLApplication.startImpl$lambda$3(this, arg_0)).onFailure(arg_0 -> FXGLApplication.startImpl$lambda$4(this, arg_0)).toJavaFXTask();
        Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"task");
        Async.INSTANCE.execute((Runnable)task2);
    }

    private final void postServicesInit() {
        Async.INSTANCE.startAsync(FXGLApplication::postServicesInit$lambda$6);
        this.initPauseResumeHandler();
        this.initSaveLoadHandler();
        this.initAndLoadLocalization();
        FXGL.Companion.getGameScene().addListener(FXGLApplication::postServicesInit$lambda$7);
    }

    private final void initPauseResumeHandler() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        if (readOnlyGameSettings.isMobile()) {
            this.initPauseResumeHandlerMobile();
        } else {
            this.initPauseResumeHandlerDesktop();
        }
    }

    private final void initPauseResumeHandlerMobile() {
        Optional serviceWrapper = LifecycleService.create();
        if (serviceWrapper.isEmpty()) {
            log.warning("Attach LifecycleService is not present");
        } else {
            Object t = serviceWrapper.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"serviceWrapper.get()");
            LifecycleService service = (LifecycleService)t;
            log.debug("Init pause/resume handlers via Attach LifecycleService");
            service.addListener(LifecycleEvent.PAUSE, FXGLApplication::initPauseResumeHandlerMobile$lambda$8);
            service.addListener(LifecycleEvent.RESUME, FXGLApplication::initPauseResumeHandlerMobile$lambda$9);
        }
    }

    private final void initPauseResumeHandlerDesktop() {
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            mainWindow = null;
        }
        mainWindow.iconifiedProperty().addListener((arg_0, arg_1, arg_2) -> FXGLApplication.initPauseResumeHandlerDesktop$lambda$10(initPauseResumeHandlerDesktop.1.INSTANCE, arg_0, arg_1, arg_2));
    }

    private final void initSaveLoadHandler() {
        FXGL.Companion.getSaveLoadService().addHandler(new SaveLoadHandler(){

            public void onSave(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = new Bundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                    engine = null;
                }
                engine.write(bundle);
                data.putBundle(bundle);
            }

            public void onLoad(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = data.getBundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                    engine = null;
                }
                engine.read(bundle);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void initAndLoadLocalization() {
        void $this$filterTo$iv$iv;
        log.debug("Loading default localization");
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        Language defaultLang = (Language)readOnlyGameSettings.getLanguage().getValue();
        FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
        String string = defaultLang.getName().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        PropertyMap langData = fXGLAssetLoaderService.loadPropertyMap("languages/" + string + ".lang");
        LocalizationService localizationService = FXGL.Companion.getLocalizationService();
        Intrinsics.checkNotNullExpressionValue((Object)defaultLang, (String)"defaultLang");
        localizationService.addLanguageData(defaultLang, langData.toStringMap());
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings2 = null;
        }
        Iterable $this$filter$iv = readOnlyGameSettings2.getSupportedLanguages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)defaultLang))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language lang = (Language)element$iv;
            boolean bl = false;
            FXGL.Companion.getLocalizationService().addLanguageDataLazy(lang, (Function0)new Function0<Map<String, ? extends String>>(lang){
                final /* synthetic */ Language $lang;
                {
                    this.$lang = $lang;
                    super(0);
                }

                @NotNull
                public final Map<String, String> invoke() {
                    FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
                    String string = this.$lang.getName().toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                    return fXGLAssetLoaderService.loadPropertyMap("languages/" + string + ".lang").toStringMap();
                }
            });
        }
        SimpleObjectProperty simpleObjectProperty = FXGL.Companion.getLocalizationService().selectedLanguageProperty();
        ReadOnlyGameSettings readOnlyGameSettings3 = settings;
        if (readOnlyGameSettings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings3 = null;
        }
        simpleObjectProperty.bind((ObservableValue)readOnlyGameSettings3.getLanguage());
    }

    private final void setFirstSceneAfterStartup() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        if (readOnlyGameSettings.isIntroEnabled()) {
            FXGLForKtKt.getGameController().gotoIntro();
        } else {
            ReadOnlyGameSettings readOnlyGameSettings2 = settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings2 = null;
            }
            if (readOnlyGameSettings2.isMainMenuEnabled()) {
                FXGLForKtKt.getGameController().gotoMainMenu();
            } else {
                FXGLForKtKt.getGameController().startNewGame();
            }
        }
    }

    private final void handleFatalError(Throwable error) {
        if (this.isError) {
            return;
        }
        this.isError = true;
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.stopLoop();
        log.fatal("Uncaught Exception:", error);
        log.fatal("Application will now exit");
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            mainWindow = null;
        }
        mainWindow.showFatalError(error, () -> FXGLApplication.handleFatalError$lambda$13(this));
    }

    public final void exitFXGL() {
        log.debug("Exiting FXGL");
        if (!this.isError) {
            Engine engine = FXGLApplication.engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                engine = null;
            }
            engine.stopLoopAndExitServices();
        }
        Async.INSTANCE.shutdownNow();
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            mainWindow = null;
        }
        mainWindow.close();
        Logger.Companion.close();
    }

    private static final void startImpl$lambda$0(FXGLApplication this$0, Thread thread, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
        this$0.handleFatalError(e);
    }

    private static final void startImpl$lambda$2(FXGLApplication this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.initServices();
        this$0.postServicesInit();
        long time = System.nanoTime() - start$iv;
        Object[] objectArray = new Object[]{(double)time / 1.0E9};
        log.infof("FXGL initialization took: %.3f sec", objectArray);
    }

    private static final void startImpl$lambda$3(FXGLApplication this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.startLoop();
        this$0.setFirstSceneAfterStartup();
    }

    private static final void startImpl$lambda$4(FXGLApplication this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleFatalError(it);
    }

    private static final void postServicesInit$lambda$6$lambda$5(UIFactoryService $uiFactory, FontFactory $fontUI, FontFactory $fontGame, FontFactory $fontMono, FontFactory $fontText) {
        Intrinsics.checkNotNullParameter((Object)$uiFactory, (String)"$uiFactory");
        Intrinsics.checkNotNullParameter((Object)$fontUI, (String)"$fontUI");
        Intrinsics.checkNotNullParameter((Object)$fontGame, (String)"$fontGame");
        Intrinsics.checkNotNullParameter((Object)$fontMono, (String)"$fontMono");
        Intrinsics.checkNotNullParameter((Object)$fontText, (String)"$fontText");
        log.debug("Registering font factories with UI factory");
        $uiFactory.registerFontFactory(FontType.UI, $fontUI);
        $uiFactory.registerFontFactory(FontType.GAME, $fontGame);
        $uiFactory.registerFontFactory(FontType.MONO, $fontMono);
        $uiFactory.registerFontFactory(FontType.TEXT, $fontText);
    }

    private static final void postServicesInit$lambda$6() {
        log.debug("Loading fonts");
        UIFactoryService uiFactory = FXGL.Companion.getUIFactoryService();
        FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings = null;
        }
        FontFactory fontUI = fXGLAssetLoaderService.loadFont(readOnlyGameSettings.getFontUI());
        FXGLAssetLoaderService fXGLAssetLoaderService2 = FXGL.Companion.getAssetLoader();
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings2 = null;
        }
        FontFactory fontGame = fXGLAssetLoaderService2.loadFont(readOnlyGameSettings2.getFontGame());
        FXGLAssetLoaderService fXGLAssetLoaderService3 = FXGL.Companion.getAssetLoader();
        ReadOnlyGameSettings readOnlyGameSettings3 = settings;
        if (readOnlyGameSettings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings3 = null;
        }
        FontFactory fontMono = fXGLAssetLoaderService3.loadFont(readOnlyGameSettings3.getFontMono());
        FXGLAssetLoaderService fXGLAssetLoaderService4 = FXGL.Companion.getAssetLoader();
        ReadOnlyGameSettings readOnlyGameSettings4 = settings;
        if (readOnlyGameSettings4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            readOnlyGameSettings4 = null;
        }
        FontFactory fontText = fXGLAssetLoaderService4.loadFont(readOnlyGameSettings4.getFontText());
        Async.INSTANCE.startAsyncFX(() -> FXGLApplication.postServicesInit$lambda$6$lambda$5(uiFactory, fontUI, fontGame, fontMono, fontText));
    }

    private static final void postServicesInit$lambda$7(double tpf) {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.onGameUpdate(tpf);
    }

    private static final void initPauseResumeHandlerMobile$lambda$8() {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.pauseLoop();
    }

    private static final void initPauseResumeHandlerMobile$lambda$9() {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            engine = null;
        }
        engine.resumeLoop();
    }

    private static final void initPauseResumeHandlerDesktop$lambda$10(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void handleFatalError$lambda$13(FXGLApplication this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.exitFXGL();
    }

    @JvmStatic
    public static final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
        Companion.launchFX(app, settings, args);
    }

    @JvmStatic
    @NotNull
    public static final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
        return Companion.embeddedLaunchFX(app, settings);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J+\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$Companion;", "", "()V", "app", "Lcom/almasb/fxgl/app/GameApplication;", "engine", "Lcom/almasb/fxgl/app/Engine;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "embeddedLaunchFX", "Lcom/almasb/fxgl/app/FXGLPane;", "launchFX", "", "args", "", "", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;[Ljava/lang/String;)V", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            app = app;
            settings = settings;
            Application.launch(FXGLApplication.class, (String[])Arrays.copyOf(args, args.length));
        }

        @JvmStatic
        @NotNull
        public final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            app = app;
            settings = settings;
            return new FXGLApplication().embeddedStart();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u0006H\u0002J\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u000209H\u0002J\u0006\u0010?\u001a\u000209J\u0006\u0010@\u001a\u000209J\u000e\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020CJ\u0012\u0010A\u001a\u0002092\n\u0010B\u001a\u0006\u0012\u0002\b\u00030DJ\u0006\u0010E\u001a\u000209J\u0006\u0010F\u001a\u000209J\b\u0010G\u001a\u000209H\u0002J\u0010\u0010H\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0006H\u0016J\u000e\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u0002092\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u000209H\u0016J\b\u0010P\u001a\u000209H\u0016J\u0010\u0010Q\u001a\u0002092\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010R\u001a\u000209H\u0016J\b\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020TH\u0016J\u0010\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020\u0016H\u0016J\u0010\u0010X\u001a\u0002092\u0006\u0010;\u001a\u00020\u0006H\u0002J\u000e\u0010Y\u001a\u0002092\u0006\u0010J\u001a\u00020KJ\u0006\u0010Z\u001a\u00020=J\b\u0010[\u001a\u000209H\u0002J\b\u0010\\\u001a\u000209H\u0002J\u0006\u0010]\u001a\u000209R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006^"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService;", "Lcom/almasb/fxgl/scene/SceneService;", "()V", "assetLoaderService", "Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService;", "currentScene", "Lcom/almasb/fxgl/scene/Scene;", "getCurrentScene", "()Lcom/almasb/fxgl/scene/Scene;", "dialogService", "Lcom/almasb/fxgl/ui/DialogService;", "dummyScene", "com/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1", "getDummyScene", "()Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1;", "dummyScene$delegate", "Lkotlin/Lazy;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus", "()Lcom/almasb/fxgl/event/EventBus;", "gameMenu", "Lcom/almasb/fxgl/scene/SubScene;", "gameScene", "Lcom/almasb/fxgl/app/scene/GameScene;", "getGameScene$fxgl", "()Lcom/almasb/fxgl/app/scene/GameScene;", "setGameScene$fxgl", "(Lcom/almasb/fxgl/app/scene/GameScene;)V", "input", "Lcom/almasb/fxgl/input/Input;", "getInput", "()Lcom/almasb/fxgl/input/Input;", "intro", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "loadScene", "Lcom/almasb/fxgl/app/scene/LoadingScene;", "localService", "Lcom/almasb/fxgl/localization/LocalizationService;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainMenu", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "window", "Lcom/almasb/fxgl/app/MainWindow;", "getWindow$fxgl", "()Lcom/almasb/fxgl/app/MainWindow;", "addClickFeedbackHandler", "", "addOverlay", "scene", "canShowCloseDialog", "", "clearPreviousGame", "gotoGameMenu", "gotoIntro", "gotoLoading", "loadingTask", "Ljava/lang/Runnable;", "Ljavafx/concurrent/Task;", "gotoMainMenu", "gotoPlay", "initAppScenes", "isInHierarchy", "loadGame", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "onGameUpdate", "tpf", "", "onInit", "onMainLoopStarting", "onUpdate", "popSubScene", "prefHeightProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "prefWidthProperty", "pushSubScene", "subScene", "removeOverlay", "saveGame", "saveScreenshot", "setSceneAfterIntro", "showConfirmExitDialog", "startNewGame", "fxgl"})
    @SourceDebugExtension(value={"SMAP\nFXGLApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication$GameApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,722:1\n1855#2,2:723\n*S KotlinDebug\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication$GameApplicationService\n*L\n395#1:723,2\n*E\n"})
    public static final class GameApplicationService
    extends SceneService {
        @NotNull
        private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
        private FXGLAssetLoaderService assetLoaderService;
        private SaveLoadService saveLoadService;
        private LocalizationService localService;
        private DialogService dialogService;
        @NotNull
        private final Group overlayRoot = new Group();
        @NotNull
        private final EventBus eventBus = new EventBus();
        @NotNull
        private final Timer timer = new Timer();
        public GameScene gameScene;
        private LoadingScene loadScene;
        @Nullable
        private FXGLScene intro;
        @Nullable
        private SubScene mainMenu;
        @Nullable
        private SubScene gameMenu;
        @NotNull
        private final Lazy dummyScene$delegate = LazyKt.lazy((Function0)dummyScene.2.INSTANCE);

        @NotNull
        public Group getOverlayRoot() {
            return this.overlayRoot;
        }

        @NotNull
        public ReadOnlyDoubleProperty prefWidthProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            return readOnlyGameSettings.prefWidthProperty();
        }

        @NotNull
        public ReadOnlyDoubleProperty prefHeightProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            return readOnlyGameSettings.prefHeightProperty();
        }

        @NotNull
        public EventBus getEventBus() {
            return this.eventBus;
        }

        @NotNull
        public Input getInput() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            return mainWindow.getInput$fxgl();
        }

        @NotNull
        public Timer getTimer() {
            return this.timer;
        }

        @NotNull
        public Scene getCurrentScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            return mainWindow.getCurrentScene();
        }

        @NotNull
        public final GameScene getGameScene$fxgl() {
            GameScene gameScene = this.gameScene;
            if (gameScene != null) {
                return gameScene;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            return null;
        }

        public final void setGameScene$fxgl(@NotNull GameScene gameScene) {
            Intrinsics.checkNotNullParameter((Object)((Object)gameScene), (String)"<set-?>");
            this.gameScene = gameScene;
        }

        @NotNull
        public final MainWindow getWindow$fxgl() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            return mainWindow;
        }

        public boolean isInHierarchy(@NotNull Scene scene) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            return mainWindow.isInHierarchy(scene);
        }

        public void onInit() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            Iterable $this$forEach$iv = readOnlyGameSettings.getCSSList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.log.debug("Applying CSS: " + it);
                MainWindow mainWindow = mainWindow;
                if (mainWindow == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    mainWindow = null;
                }
                CSS[] cSSArray = new CSS[1];
                FXGLAssetLoaderService fXGLAssetLoaderService = this.assetLoaderService;
                if (fXGLAssetLoaderService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    fXGLAssetLoaderService = null;
                }
                cSSArray[0] = fXGLAssetLoaderService.loadCSS(it);
                mainWindow.addCSS(cSSArray);
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.setOnClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GameApplicationService this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                    if (readOnlyGameSettings == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                        readOnlyGameSettings = null;
                    }
                    if (readOnlyGameSettings.isCloseConfirmation()) {
                        if (GameApplicationService.access$canShowCloseDialog(this.this$0)) {
                            GameApplicationService.access$showConfirmExitDialog(this.this$0);
                        }
                    } else {
                        FXGL.Companion.getGameController().exit();
                    }
                }
            }));
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow2 = null;
            }
            mainWindow2.getCurrentSceneProperty().addListener((arg_0, arg_1, arg_2) -> GameApplicationService.onInit$lambda$1((Function3)new Function3<ObservableValue<? extends Scene>, Scene, Scene, Unit>(this){
                final /* synthetic */ GameApplicationService this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Scene> observableValue, Scene oldScene, Scene newScene) {
                    GameApplicationService.access$getLog$p(this.this$0).debug("Removing overlay from " + oldScene + " and adding to " + newScene);
                    Intrinsics.checkNotNullExpressionValue((Object)oldScene, (String)"oldScene");
                    GameApplicationService.access$removeOverlay(this.this$0, oldScene);
                    Intrinsics.checkNotNullExpressionValue((Object)newScene, (String)"newScene");
                    GameApplicationService.access$addOverlay(this.this$0, newScene);
                }
            }, arg_0, arg_1, arg_2));
            this.initAppScenes();
        }

        public void onGameUpdate(double tpf) {
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication = null;
            }
            gameApplication.onUpdate(tpf);
        }

        public void onUpdate(double tpf) {
            this.getTimer().update(tpf);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.update(tpf);
        }

        /*
         * WARNING - void declaration
         */
        private final void initAppScenes() {
            ReadOnlyGameSettings readOnlyGameSettings;
            ReadOnlyGameSettings readOnlyGameSettings2;
            ReadOnlyGameSettings readOnlyGameSettings3;
            this.log.debug("Initializing application scenes");
            ReadOnlyGameSettings readOnlyGameSettings4 = settings;
            if (readOnlyGameSettings4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings4 = null;
            }
            SceneFactory sceneFactory = readOnlyGameSettings4.getSceneFactory();
            this.loadScene = sceneFactory.newLoadingScene();
            ReadOnlyGameSettings readOnlyGameSettings5 = settings;
            if (readOnlyGameSettings5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings5 = null;
            }
            int n = readOnlyGameSettings5.getWidth();
            ReadOnlyGameSettings readOnlyGameSettings6 = settings;
            if (readOnlyGameSettings6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings6 = null;
            }
            int n2 = readOnlyGameSettings6.getHeight();
            GameWorld gameWorld = new GameWorld();
            ReadOnlyGameSettings readOnlyGameSettings7 = settings;
            if (readOnlyGameSettings7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings7 = null;
            }
            int n3 = readOnlyGameSettings7.getHeight();
            ReadOnlyGameSettings readOnlyGameSettings8 = settings;
            if (readOnlyGameSettings8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings8 = null;
            }
            double d = readOnlyGameSettings8.getPixelsPerMeter();
            ReadOnlyGameSettings readOnlyGameSettings9 = settings;
            if (readOnlyGameSettings9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings9 = null;
            }
            PhysicsWorld physicsWorld = new PhysicsWorld(n3, d, readOnlyGameSettings9.getCollisionDetectionStrategy());
            ReadOnlyGameSettings readOnlyGameSettings10 = settings;
            if (readOnlyGameSettings10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings10 = null;
            }
            this.setGameScene$fxgl(new GameScene(n, n2, gameWorld, physicsWorld, readOnlyGameSettings10.is3D()));
            GameScene gameScene = this.getGameScene$fxgl();
            ReadOnlyGameSettings readOnlyGameSettings11 = settings;
            if (readOnlyGameSettings11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings11 = null;
            }
            gameScene.setSingleStep(readOnlyGameSettings11.isSingleStep());
            ReadOnlyGameSettings readOnlyGameSettings12 = settings;
            if (readOnlyGameSettings12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings12 = null;
            }
            if (readOnlyGameSettings12.isClickFeedbackEnabled()) {
                this.addClickFeedbackHandler();
            }
            if ((readOnlyGameSettings3 = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings3 = null;
            }
            if (readOnlyGameSettings3.isIntroEnabled()) {
                void it;
                IntroScene introScene;
                IntroScene introScene2 = introScene = sceneFactory.newIntro();
                GameApplicationService gameApplicationService = this;
                boolean bl = false;
                it.setOnFinished$fxgl(() -> GameApplicationService.initAppScenes$lambda$3$lambda$2(this));
                gameApplicationService.intro = introScene;
            }
            if ((readOnlyGameSettings2 = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings2 = null;
            }
            if (readOnlyGameSettings2.isMainMenuEnabled()) {
                this.mainMenu = sceneFactory.newMainMenu();
            }
            if ((readOnlyGameSettings = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (readOnlyGameSettings.isGameMenuEnabled()) {
                this.gameMenu = sceneFactory.newGameMenu();
                EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                    private boolean canSwitchGameMenu;
                    final /* synthetic */ GameApplicationService this$0;
                    {
                        this.this$0 = $receiver;
                        this.canSwitchGameMenu = true;
                    }

                    private final void onMenuKey(boolean pressed) {
                        if (!pressed) {
                            this.canSwitchGameMenu = true;
                            return;
                        }
                        if (this.canSwitchGameMenu) {
                            MainWindow mainWindow = FXGLApplication.access$getMainWindow$cp();
                            if (mainWindow == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                                mainWindow = null;
                            }
                            if (mainWindow.getCurrentScene() == GameApplicationService.access$getGameMenu$p(this.this$0)) {
                                this.canSwitchGameMenu = false;
                                this.this$0.popSubScene();
                            } else {
                                MainWindow mainWindow2 = FXGLApplication.access$getMainWindow$cp();
                                if (mainWindow2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                                    mainWindow2 = null;
                                }
                                if (mainWindow2.getCurrentScene() == this.this$0.getGameScene$fxgl()) {
                                    this.canSwitchGameMenu = false;
                                    SubScene subScene2 = GameApplicationService.access$getGameMenu$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)subScene2);
                                    this.this$0.pushSubScene(subScene2);
                                }
                            }
                        }
                    }

                    public void handle(@NotNull KeyEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        KeyCode keyCode = event.getCode();
                        ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                        if (readOnlyGameSettings == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                            readOnlyGameSettings = null;
                        }
                        if (keyCode == readOnlyGameSettings.getMenuKey()) {
                            this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                        }
                    }
                };
                Input input = this.getGameScene$fxgl().getInput();
                EventType eventType = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"ANY");
                input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
                SubScene subScene2 = this.gameMenu;
                Intrinsics.checkNotNull((Object)subScene2);
                Input input2 = subScene2.getInput();
                EventType eventType2 = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"ANY");
                input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
            }
            this.log.debug("Application scenes initialized");
        }

        private final void setSceneAfterIntro() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (readOnlyGameSettings.isMainMenuEnabled()) {
                FXGLForKtKt.getGameController().gotoMainMenu();
            } else {
                FXGLForKtKt.getGameController().startNewGame();
            }
        }

        private final void addClickFeedbackHandler() {
            Input input = this.getGameScene$fxgl().getInput();
            EventType eventType = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"MOUSE_PRESSED");
            input.addEventHandler(eventType, arg_0 -> GameApplicationService.addClickFeedbackHandler$lambda$5(this, arg_0));
        }

        public void onMainLoopStarting() {
            MainWindow mainWindow;
            Image[] imageArray;
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication = null;
            }
            gameApplication.initInput();
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication2 = null;
            }
            gameApplication2.onPreInit();
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (!readOnlyGameSettings.isNative()) {
                FXGLAssetLoaderService fXGLAssetLoaderService;
                ReadOnlyGameSettings readOnlyGameSettings2;
                MainWindow mainWindow2 = mainWindow;
                if (mainWindow2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    mainWindow2 = null;
                }
                imageArray = new Image[1];
                FXGLAssetLoaderService fXGLAssetLoaderService2 = this.assetLoaderService;
                if (fXGLAssetLoaderService2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    fXGLAssetLoaderService2 = null;
                }
                if ((readOnlyGameSettings2 = settings) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings2 = null;
                }
                imageArray[0] = fXGLAssetLoaderService2.loadImage(readOnlyGameSettings2.getAppIcon());
                mainWindow2.addIcons(imageArray);
                ReadOnlyGameSettings readOnlyGameSettings3 = settings;
                if (readOnlyGameSettings3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    readOnlyGameSettings3 = null;
                }
                CursorInfo cursorInfo = readOnlyGameSettings3.getDefaultCursor();
                MainWindow mainWindow3 = mainWindow;
                if (mainWindow3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    mainWindow3 = null;
                }
                if ((fXGLAssetLoaderService = this.assetLoaderService) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    fXGLAssetLoaderService = null;
                }
                mainWindow3.setDefaultCursor(new ImageCursor(fXGLAssetLoaderService.loadImage(cursorInfo.getImageName()), cursorInfo.getHotspotX(), cursorInfo.getHotspotY()));
            }
            if ((mainWindow = mainWindow) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            SystemActions.INSTANCE.bind(mainWindow.getInput$fxgl());
            MainWindow mainWindow4 = mainWindow;
            if (mainWindow4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow4 = null;
            }
            imageArray = new KeyCode[]{KeyCode.G, KeyCode.L, KeyCode.A, KeyCode.L, KeyCode.M, KeyCode.A, KeyCode.S, KeyCode.B};
            mainWindow4.getInput$fxgl().addAction(new UserAction(this){
                @NotNull
                private final onMainLoopStarting.subScene.1 subScene;
                final /* synthetic */ GameApplicationService this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                    this.subScene = new SubScene($receiver){
                        @NotNull
                        private final Lazy view$delegate;
                        final /* synthetic */ GameApplicationService this$0;
                        {
                            this.this$0 = $receiver;
                            this.view$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageView>($receiver){
                                final /* synthetic */ GameApplicationService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                @NotNull
                                public final ImageView invoke() {
                                    ImageView imageView = new ImageView(ImagesKt.toImage((byte[])PauseMenuBGGen.INSTANCE.generate()));
                                    GameApplicationService gameApplicationService = this.this$0;
                                    ImageView it = imageView;
                                    boolean bl = false;
                                    it.setScaleX(4.0);
                                    it.setScaleY(4.0);
                                    it.setTranslateX(gameApplicationService.getPrefWidth() / 2.0);
                                    it.setTranslateY(gameApplicationService.getPrefHeight() / 2.0);
                                    return imageView;
                                }
                            }));
                        }

                        private final ImageView getView() {
                            Lazy lazy = this.view$delegate;
                            return (ImageView)lazy.getValue();
                        }

                        public void onCreate() {
                            Object[] objectArray = new Node[]{(Node)this.getView()};
                            this.getContentRoot().getChildren().setAll(objectArray);
                            Timer timer2 = this.getTimer();
                            Function0 function0 = (Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ GameApplicationService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.popSubScene();
                                }
                            };
                            Duration duration = Duration.seconds((double)3.0);
                            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(3.0)");
                            timer2.runOnceAfter(function0, duration);
                        }
                    };
                }

                protected void onActionBegin() {
                    this.this$0.pushSubScene(this.subScene);
                }
            }, new InputSequence(KeyCode.F, KeyCode.X, (KeyCode[])imageArray));
        }

        private final void addOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                ObservableList observableList = scene.getContentRoot().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"scene.contentRoot.children");
                Collection collection = (Collection)observableList;
                collection.add(this.getOverlayRoot());
            } else {
                ObservableList observableList = scene.getRoot().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"scene.root.children");
                Collection collection = (Collection)observableList;
                collection.add(this.getOverlayRoot());
            }
        }

        private final void removeOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                ObservableList observableList = scene.getContentRoot().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"scene.contentRoot.children");
                Collection collection = (Collection)observableList;
                collection.remove(this.getOverlayRoot());
            } else {
                ObservableList observableList = scene.getRoot().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"scene.root.children");
                Collection collection = (Collection)observableList;
                collection.remove(this.getOverlayRoot());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canShowCloseDialog() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            Scene scene = mainWindow.getCurrentScene();
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene = null;
            }
            if (scene == loadingScene) return false;
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (!readOnlyGameSettings.isIntroEnabled()) return true;
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow2 = null;
            }
            if (mainWindow2.getCurrentScene() != this.intro) return true;
            return false;
        }

        private final void showConfirmExitDialog() {
            LocalizationService localizationService;
            DialogService dialogService = this.dialogService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
                dialogService = null;
            }
            if ((localizationService = this.localService) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localService");
                localizationService = null;
            }
            dialogService.showConfirmationBox(localizationService.getLocalizedString("dialog.exitGame"), GameApplicationService::showConfirmExitDialog$lambda$6);
        }

        public final void startNewGame() {
            LoadingScene loadingScene;
            this.log.debug("Starting new game");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            if ((loadingScene = this.loadScene) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene = null;
            }
            mainWindow.setScene(loadingScene);
            this.clearPreviousGame();
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene2 = null;
            }
            loadingScene2.pushNewTask(new InitAppTask());
        }

        private final void clearPreviousGame() {
            this.log.debug("Clearing previous game");
            this.getGameScene$fxgl().reset$fxgl();
        }

        public final void saveGame(@NotNull DataFile dataFile) {
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            SaveLoadService saveLoadService = this.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
                saveLoadService = null;
            }
            saveLoadService.save(dataFile);
        }

        public final void loadGame(@NotNull DataFile dataFile) {
            LoadingScene loadingScene;
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            this.log.debug("Starting loaded game");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            if ((loadingScene = this.loadScene) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene = null;
            }
            mainWindow.setScene(loadingScene);
            this.clearPreviousGame();
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene2 = null;
            }
            loadingScene2.pushNewTask(() -> GameApplicationService.loadGame$lambda$7(this, dataFile));
        }

        public final void gotoIntro() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            FXGLScene fXGLScene = this.intro;
            Intrinsics.checkNotNull((Object)((Object)fXGLScene));
            mainWindow.setScene(fXGLScene);
        }

        private final dummyScene.1 getDummyScene() {
            Lazy lazy = this.dummyScene$delegate;
            return (Object)lazy.getValue();
        }

        public final void gotoMainMenu() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (!readOnlyGameSettings.isMainMenuEnabled()) {
                this.log.warning("Ignoring gotoMainMenu() because main menu is not enabled");
                return;
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.setScene(this.getDummyScene());
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow2 = null;
            }
            SubScene subScene2 = this.mainMenu;
            Intrinsics.checkNotNull((Object)subScene2);
            mainWindow2.pushState(subScene2);
        }

        public final void gotoGameMenu() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            if (!readOnlyGameSettings.isGameMenuEnabled()) {
                this.log.warning("Ignoring gotoGameMenu() because game menu is not enabled");
                return;
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            SubScene subScene2 = this.gameMenu;
            Intrinsics.checkNotNull((Object)subScene2);
            mainWindow.pushState(subScene2);
        }

        public final void gotoLoading(@NotNull Runnable loadingTask) {
            LoadingScene loadingScene;
            Intrinsics.checkNotNullParameter((Object)loadingTask, (String)"loadingTask");
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene2 = null;
            }
            loadingScene2.pushNewTask(loadingTask);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            if ((loadingScene = this.loadScene) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene = null;
            }
            mainWindow.setScene(loadingScene);
        }

        public final void gotoLoading(@NotNull Task<?> loadingTask) {
            LoadingScene loadingScene;
            Intrinsics.checkNotNullParameter(loadingTask, (String)"loadingTask");
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene2 = null;
            }
            loadingScene2.pushNewTask(loadingTask);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            if ((loadingScene = this.loadScene) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                loadingScene = null;
            }
            mainWindow.setScene(loadingScene);
        }

        public final void gotoPlay() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.setScene(this.getGameScene$fxgl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean saveScreenshot() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            Image fxImage = mainWindow.takeScreenshot();
            BufferedImage img = ImagesKt.toBufferedImage((Image)fxImage);
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings = null;
            }
            String string = readOnlyGameSettings.getTitle();
            ReadOnlyGameSettings readOnlyGameSettings2 = settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                readOnlyGameSettings2 = null;
            }
            Object fileName = "./" + string + readOnlyGameSettings2.getVersion() + LocalDateTime.now();
            fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
            try {
                Object name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : (String)fileName + ".png";
                Closeable closeable = Files.newOutputStream(Paths.get((String)name, new String[0]), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl = false;
                    boolean bl2 = ImageIO.write((RenderedImage)img, "png", it);
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.log.warning("saveScreenshot(" + (String)fileName + ".png) failed: " + e);
                return false;
            }
        }

        public void pushSubScene(@NotNull SubScene subScene2) {
            Intrinsics.checkNotNullParameter((Object)subScene2, (String)"subScene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.pushState(subScene2);
        }

        public void popSubScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                mainWindow = null;
            }
            mainWindow.popState();
        }

        private static final void onInit$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke((Object)p0, p1, p2);
        }

        private static final void initAppScenes$lambda$3$lambda$2(GameApplicationService this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.setSceneAfterIntro();
        }

        private static final void addClickFeedbackHandler$lambda$5$lambda$4(GameApplicationService this$0, Circle $circle) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$circle, (String)"$circle");
            ObservableList observableList = this$0.getOverlayRoot().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"overlayRoot.children");
            ((Collection)observableList).remove($circle);
        }

        private static final void addClickFeedbackHandler$lambda$5(GameApplicationService this$0, MouseEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Circle circle = new Circle(this$0.getGameScene$fxgl().getInput().getMouseXUI(), this$0.getGameScene$fxgl().getInput().getMouseYUI(), 5.0, null);
            circle.setStroke((Paint)Color.GOLD);
            circle.setStrokeWidth(2.0);
            circle.opacityProperty().bind((ObservableValue)new SimpleDoubleProperty(1.0).subtract((ObservableNumberValue)circle.radiusProperty().divide(35.0)));
            ObservableList observableList = this$0.getOverlayRoot().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"overlayRoot.children");
            ((Collection)observableList).add(circle);
            AnimationBuilder animationBuilder = FXGLForKtKt.animationBuilder().interpolator(Interpolators.SMOOTH.EASE_IN()).onFinished(() -> GameApplicationService.addClickFeedbackHandler$lambda$5$lambda$4(this$0, circle));
            Duration duration = Duration.seconds((double)0.33);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(0.33)");
            AnimationBuilder animationBuilder2 = animationBuilder.duration(duration);
            DoubleProperty doubleProperty = circle.radiusProperty();
            Intrinsics.checkNotNullExpressionValue((Object)doubleProperty, (String)"circle.radiusProperty()");
            animationBuilder2.animate((WritableValue)doubleProperty).to((Object)35.0).buildAndPlay();
        }

        private static final void showConfirmExitDialog$lambda$6(Boolean yes) {
            Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
            if (yes.booleanValue()) {
                FXGL.Companion.getGameController().exit();
            }
        }

        private static final void loadGame$lambda$7(GameApplicationService this$0, DataFile $dataFile) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$dataFile, (String)"$dataFile");
            new InitAppTask().run();
            SaveLoadService saveLoadService = this$0.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
                saveLoadService = null;
            }
            saveLoadService.load($dataFile);
        }

        public static final /* synthetic */ boolean access$canShowCloseDialog(GameApplicationService $this) {
            return $this.canShowCloseDialog();
        }

        public static final /* synthetic */ void access$showConfirmExitDialog(GameApplicationService $this) {
            $this.showConfirmExitDialog();
        }

        public static final /* synthetic */ Logger access$getLog$p(GameApplicationService $this) {
            return $this.log;
        }

        public static final /* synthetic */ void access$removeOverlay(GameApplicationService $this, Scene scene) {
            $this.removeOverlay(scene);
        }

        public static final /* synthetic */ void access$addOverlay(GameApplicationService $this, Scene scene) {
            $this.addOverlay(scene);
        }

        public static final /* synthetic */ SubScene access$getGameMenu$p(GameApplicationService $this) {
            return $this.gameMenu;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "()V", "call", "failed", "", "initGame", "fxgl"})
    @SourceDebugExtension(value={"SMAP\nFXGLApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication$InitAppTask\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,722:1\n31#2,6:723\n*S KotlinDebug\n*F\n+ 1 FXGLApplication.kt\ncom/almasb/fxgl/app/FXGLApplication$InitAppTask\n*L\n314#1:723,6\n*E\n"})
    public static final class InitAppTask
    extends Task<Void> {
        @Nullable
        protected Void call() {
            boolean $i$f$measureNanoTime = false;
            long start$iv = System.nanoTime();
            boolean bl = false;
            log.debug("Initializing game");
            this.updateMessage("Initializing game");
            this.initGame();
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication = null;
            }
            gameApplication.initPhysics();
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication2 = null;
            }
            gameApplication2.initUI();
            Engine engine = engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                engine = null;
            }
            engine.onGameReady(FXGL.Companion.getWorldProperties());
            long time = System.nanoTime() - start$iv;
            Object[] objectArray = new Object[]{(double)time / 1.0E9};
            log.infof("Game initialization took: %.3f sec", objectArray);
            return null;
        }

        private final void initGame() {
            HashMap<Object, Object> vars = new HashMap<Object, Object>();
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication = null;
            }
            gameApplication.initGameVars((Map<String, Object>)vars);
            vars.forEach((arg_0, arg_1) -> InitAppTask.initGame$lambda$1(initGame.1.INSTANCE, arg_0, arg_1));
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                gameApplication2 = null;
            }
            gameApplication2.initGame();
        }

        protected void failed() {
            throw new RuntimeException("Initialization failed", this.getException());
        }

        private static final void initGame$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }
}

