/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.MenuItem;
import com.almasb.fxgl.app.scene.FXGLMenu;
import com.almasb.fxgl.app.scene.MenuType;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.UpdatableRunner;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.util.InputPredicates;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.particle.ParticleEmitter;
import com.almasb.fxgl.particle.ParticleEmitters;
import com.almasb.fxgl.particle.ParticleSystem;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FXGLScrollPane;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.When;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javafx.util.StringConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0016\u0018\u0000 @2\u00020\u0001:\u0005@ABCDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0006H\u0004J\b\u0010&\u001a\u00020\u0006H\u0004J\b\u0010'\u001a\u00020\u0006H\u0004J\b\u0010(\u001a\u00020\u0006H\u0004J\b\u0010)\u001a\u00020\u0006H\u0004J\b\u0010*\u001a\u00020\u0006H\u0004J\b\u0010+\u001a\u00020\u0006H\u0004J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u0010\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u00020\u001bH\u0002J\b\u00107\u001a\u000203H\u0002J\b\u00108\u001a\u00020\u001bH\u0016J\b\u00109\u001a\u00020\u001bH\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u0015H\u0014J\b\u0010<\u001a\u00020\u001bH\u0002J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\fH\u0002J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;", "Lcom/almasb/fxgl/app/scene/FXGLMenu;", "type", "Lcom/almasb/fxgl/app/scene/MenuType;", "(Lcom/almasb/fxgl/app/scene/MenuType;)V", "EMPTY", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "animations", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/animation/Animation;", "Lkotlin/collections/ArrayList;", "menu", "Ljavafx/scene/Node;", "menuContentRoot", "Ljavafx/scene/layout/Pane;", "menuRoot", "particleSystem", "Lcom/almasb/fxgl/particle/ParticleSystem;", "pressAnyKeyState", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$PressAnyKeyState;", "t", "", "titleColor", "Ljavafx/beans/property/SimpleObjectProperty;", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "addNewInputBinding", "", "action", "Lcom/almasb/fxgl/input/UserAction;", "trigger", "Lcom/almasb/fxgl/input/Trigger;", "grid", "Ljavafx/scene/layout/GridPane;", "createBackground", "width", "height", "createContentAchievements", "createContentAudio", "createContentControls", "createContentCredits", "createContentGameplay", "createContentLoad", "createContentVideo", "createExtraMenu", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "createMenuBodyGameMenu", "createMenuBodyMainMenu", "createOptionsMenu", "createTitleView", "title", "", "createVersionView", "version", "initParticles", "makeVersionString", "onCreate", "onDestroy", "onUpdate", "tpf", "showProfileDialog", "switchMenuContentTo", "content", "switchMenuTo", "Companion", "MenuBox", "MenuButton", "MenuContent", "PressAnyKeyState", "fxgl"})
@SourceDebugExtension(value={"SMAP\nFXGLDefaultMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FXGLDefaultMenu.kt\ncom/almasb/fxgl/app/scene/FXGLDefaultMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,945:1\n1864#2,3:946\n1855#2,2:949\n1855#2,2:953\n215#3,2:951\n*S KotlinDebug\n*F\n+ 1 FXGLDefaultMenu.kt\ncom/almasb/fxgl/app/scene/FXGLDefaultMenu\n*L\n139#1:946,3\n172#1:949,2\n765#1:953,2\n574#1:951,2\n*E\n"})
public class FXGLDefaultMenu
extends FXGLMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParticleSystem particleSystem;
    @NotNull
    private final SimpleObjectProperty<Color> titleColor;
    private double t;
    @NotNull
    private final Pane menuRoot;
    @NotNull
    private final Pane menuContentRoot;
    @NotNull
    private final MenuContent EMPTY;
    @NotNull
    private final PressAnyKeyState pressAnyKeyState;
    @NotNull
    private final Node menu;
    @NotNull
    private final ArrayList<Animation<?>> animations;
    @NotNull
    private static final Logger log = Logger.Companion.get("FXGL.DefaultMenu");

    public FXGLDefaultMenu(@NotNull MenuType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(type);
        this.particleSystem = new ParticleSystem();
        this.titleColor = new SimpleObjectProperty((Object)Color.WHITE);
        this.menuRoot = new Pane();
        this.menuContentRoot = new Pane();
        this.EMPTY = new MenuContent(new Node[0]);
        this.pressAnyKeyState = new PressAnyKeyState();
        if (this.getAppWidth() < 800 || this.getAppHeight() < 600) {
            log.warning("FXGLDefaultMenu is not designed for resolutions < 800x600");
        }
        this.menu = type == MenuType.MAIN_MENU ? (Node)this.createMenuBodyMainMenu() : (Node)this.createMenuBodyGameMenu();
        double menuX = 50.0;
        double menuY = (double)this.getAppHeight() / 2.0 - ((MenuBox)this.menu).getLayoutHeight() / (double)2;
        this.menuRoot.setTranslateX(menuX);
        this.menuRoot.setTranslateY(menuY);
        this.menuContentRoot.setTranslateX((double)this.getAppWidth() - 500.0);
        this.menuContentRoot.setTranslateY(menuY);
        this.initParticles();
        Object[] objectArray = new Node[]{this.menu};
        this.menuRoot.getChildren().addAll(objectArray);
        this.menuContentRoot.getChildren().add((Object)this.EMPTY);
        objectArray = new Node[]{this.createBackground(FXGLForKtKt.getAppWidth(), FXGLForKtKt.getAppHeight()), this.createTitleView(FXGLForKtKt.getSettings().getTitle()), this.createVersionView(this.makeVersionString()), (Node)this.particleSystem.getPane(), (Node)this.menuRoot, (Node)this.menuContentRoot};
        this.getContentRoot().getChildren().addAll(objectArray);
        this.animations = new ArrayList();
    }

    private final void initParticles() {
        Texture t = FXGL.Companion.texture("particles/smoke.png", 128.0, 128.0).brighter().brighter();
        ParticleEmitter emitter = ParticleEmitters.newFireEmitter();
        emitter.setBlendMode(BlendMode.SRC_OVER);
        emitter.setSourceImage(t.getImage());
        emitter.setSize(150.0, 220.0);
        emitter.setNumParticles(10);
        emitter.setEmissionRate(0.01);
        emitter.setVelocityFunction(FXGLDefaultMenu::initParticles$lambda$0);
        emitter.setExpireFunction(FXGLDefaultMenu::initParticles$lambda$1);
        emitter.setScaleFunction(FXGLDefaultMenu::initParticles$lambda$2);
        emitter.setSpawnPointFunction(arg_0 -> FXGLDefaultMenu.initParticles$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)emitter, (String)"emitter");
        this.particleSystem.addParticleEmitter(emitter, 0.0, (double)FXGL.Companion.getAppHeight());
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate() {
        this.animations.clear();
        Object object = this.menuRoot.getChildren().get(0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.almasb.fxgl.app.scene.FXGLDefaultMenu.MenuBox");
        MenuBox menuBox = (MenuBox)((Object)object);
        ObservableList observableList = menuBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"menuBox.children");
        Iterable $this$forEachIndexed$iv = (Iterable)observableList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv;
            int index = n;
            boolean bl = false;
            node.setTranslateX(-250.0);
            AnimationBuilder animationBuilder = FXGL.Companion.animationBuilder();
            Duration duration = Duration.seconds((double)((double)index * 0.07));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(index * 0.07)");
            AnimationBuilder animationBuilder2 = animationBuilder.delay(duration).interpolator(Interpolators.EXPONENTIAL.EASE_OUT());
            Duration duration2 = Duration.seconds((double)0.66);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"seconds(0.66)");
            AnimationBuilder animationBuilder3 = animationBuilder2.duration(duration2);
            Node[] nodeArray = new Node[1];
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
            nodeArray[0] = node;
            Animation animation = animationBuilder3.translate(nodeArray).from(new Point2D(-250.0, 0.0)).to(new Point2D(0.0, 0.0)).build();
            ((Collection)this.animations).add(animation);
            animation.stop();
            animation.start();
        }
    }

    public void onDestroy() {
        this.switchMenuTo(this.menu);
        this.switchMenuContentTo((Node)this.EMPTY);
    }

    protected void onUpdate(double tpf) {
        if (this.getType() == MenuType.MAIN_MENU && FXGLForKtKt.getSettings().isUserProfileEnabled() && Intrinsics.areEqual((Object)FXGLForKtKt.getSettings().getProfileName().getValue(), (Object)"DEFAULT")) {
            this.showProfileDialog();
        }
        Iterable $this$forEach$iv = this.animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation it = (Animation)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
        double frequency = 1.7;
        this.t += tpf * frequency;
        this.particleSystem.onUpdate(tpf);
        Color color = Color.color((double)1.0, (double)1.0, (double)1.0, (double)FXGLMath.noise1D((double)this.t));
        this.titleColor.set((Object)color);
    }

    private final Node createBackground(double width, double height) {
        Rectangle bg = new Rectangle(width, height);
        bg.setFill((Paint)Color.rgb((int)10, (int)1, (int)1, (double)(this.getType() == MenuType.GAME_MENU ? 0.5 : 1.0)));
        return (Node)bg;
    }

    private final Node createTitleView(String title) {
        UIFactoryService uIFactoryService = FXGLForKtKt.getUIFactoryService();
        String string = title.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Text text = uIFactoryService.newText(string, 50.0);
        text.setFill(null);
        text.strokeProperty().bind((ObservableValue)this.titleColor);
        text.setStrokeWidth(1.5);
        UIFactoryService uIFactoryService2 = FXGLForKtKt.getUIFactoryService();
        String string2 = title.substring(1, title.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Text text2 = uIFactoryService2.newText(string2, 50.0);
        text2.setFill(null);
        text2.setStroke((Paint)this.titleColor.getValue());
        text2.setStrokeWidth(1.5);
        double textWidth = text.getLayoutBounds().getWidth() + text2.getLayoutBounds().getWidth();
        Rectangle border = new Rectangle(textWidth + (double)30, 65.0, null);
        border.setStroke((Paint)Color.WHITE);
        border.setStrokeWidth(4.0);
        border.setArcWidth(25.0);
        border.setArcHeight(25.0);
        ParticleEmitter emitter = ParticleEmitters.newExplosionEmitter((int)50);
        emitter.setBlendMode(BlendMode.ADD);
        emitter.setSourceImage(FXGLForKtKt.image("particles/trace_horizontal.png", 64.0, 64.0));
        emitter.setMaxEmissions(Integer.MAX_VALUE);
        emitter.setSize(18.0, 22.0);
        emitter.setNumParticles(2);
        emitter.setEmissionRate(0.2);
        emitter.setVelocityFunction(FXGLDefaultMenu::createTitleView$lambda$6);
        emitter.setExpireFunction(FXGLDefaultMenu::createTitleView$lambda$7);
        emitter.setScaleFunction(FXGLDefaultMenu::createTitleView$lambda$8);
        emitter.setSpawnPointFunction(FXGLDefaultMenu::createTitleView$lambda$9);
        emitter.setAccelerationFunction(FXGLDefaultMenu::createTitleView$lambda$10);
        Node[] nodeArray = new Node[]{(Node)text, (Node)text2};
        HBox box = new HBox(nodeArray);
        box.setAlignment(Pos.CENTER);
        Node[] nodeArray2 = new Node[]{(Node)border, (Node)box};
        StackPane titleRoot = new StackPane(nodeArray2);
        titleRoot.setTranslateX((double)this.getAppWidth() / 2.0 - (textWidth + (double)30) / (double)2);
        titleRoot.setTranslateY(50.0);
        if (!FXGL.Companion.getSettings().isNative()) {
            Intrinsics.checkNotNullExpressionValue((Object)emitter, (String)"emitter");
            this.particleSystem.addParticleEmitter(emitter, (double)this.getAppWidth() / 2.0 - (double)30, titleRoot.getTranslateY() + border.getHeight() - (double)16);
        }
        return (Node)titleRoot;
    }

    private final Node createVersionView(String version) {
        Text view2 = FXGL.Companion.getUIFactoryService().newText(version);
        view2.setTranslateY((double)(FXGL.Companion.getAppHeight() - 2));
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        return (Node)view2;
    }

    private final MenuBox createMenuBodyMainMenu() {
        log.debug("createMenuBodyMainMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGLForKtKt.getSettings().getEnabledMenuItems();
        MenuButton itemNewGame = new MenuButton("menu.newGame");
        itemNewGame.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyMainMenu$lambda$11(this, arg_0)));
        box.add(itemNewGame);
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        MenuButton itemExit = new MenuButton("menu.exit");
        itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyMainMenu$lambda$12(this, arg_0)));
        box.add(itemExit);
        return box;
    }

    private final MenuBox createMenuBodyGameMenu() {
        MenuButton itemExit;
        log.debug("createMenuBodyGameMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGLForKtKt.getSettings().getEnabledMenuItems();
        MenuButton itemResume = new MenuButton("menu.resume");
        itemResume.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyGameMenu$lambda$13(this, arg_0)));
        box.add(itemResume);
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemSave = new MenuButton("menu.save");
            itemSave.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyGameMenu$lambda$14(this, arg_0)));
            MenuButton itemLoad = new MenuButton("menu.load");
            itemLoad.setMenuContent(() -> FXGLDefaultMenu.createMenuBodyGameMenu$lambda$15(this), false);
            box.add(itemSave);
            box.add(itemLoad);
        }
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        if (FXGLForKtKt.getSettings().isMainMenuEnabled()) {
            itemExit = new MenuButton("menu.mainMenu");
            itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyGameMenu$lambda$16(this, arg_0)));
            box.add(itemExit);
        } else {
            itemExit = new MenuButton("menu.exit");
            itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createMenuBodyGameMenu$lambda$17(this, arg_0)));
            box.add(itemExit);
        }
        return box;
    }

    private final MenuBox createOptionsMenu() {
        log.debug("createOptionsMenu()");
        MenuButton itemGameplay = new MenuButton("menu.gameplay");
        MenuButton.setMenuContent$default(itemGameplay, () -> FXGLDefaultMenu.createOptionsMenu$lambda$18(this), false, 2, null);
        MenuButton itemControls = new MenuButton("menu.controls");
        MenuButton.setMenuContent$default(itemControls, () -> FXGLDefaultMenu.createOptionsMenu$lambda$19(this), false, 2, null);
        MenuButton itemVideo = new MenuButton("menu.video");
        MenuButton.setMenuContent$default(itemVideo, () -> FXGLDefaultMenu.createOptionsMenu$lambda$20(this), false, 2, null);
        MenuButton itemAudio = new MenuButton("menu.audio");
        MenuButton.setMenuContent$default(itemAudio, () -> FXGLDefaultMenu.createOptionsMenu$lambda$21(this), false, 2, null);
        MenuButton btnRestore = new MenuButton("menu.restore");
        btnRestore.setOnAction((EventHandler<ActionEvent>)((EventHandler)arg_0 -> FXGLDefaultMenu.createOptionsMenu$lambda$23(this, arg_0)));
        MenuButton[] menuButtonArray = new MenuButton[]{itemGameplay, itemControls, itemVideo, itemAudio, btnRestore};
        return new MenuBox(menuButtonArray);
    }

    private final MenuBox createExtraMenu() {
        log.debug("createExtraMenu()");
        MenuButton itemAchievements = new MenuButton("menu.trophies");
        MenuButton.setMenuContent$default(itemAchievements, () -> FXGLDefaultMenu.createExtraMenu$lambda$24(this), false, 2, null);
        MenuButton itemCredits = new MenuButton("menu.credits");
        MenuButton.setMenuContent$default(itemCredits, () -> FXGLDefaultMenu.createExtraMenu$lambda$25(this), false, 2, null);
        MenuButton[] menuButtonArray = new MenuButton[]{itemAchievements, itemCredits};
        return new MenuBox(menuButtonArray);
    }

    private final void switchMenuTo(Node menu) {
        Node oldMenu = (Node)this.menuRoot.getChildren().get(0);
        FadeTransition ft = new FadeTransition(Duration.seconds((double)0.33), oldMenu);
        ft.setToValue(0.0);
        ft.setOnFinished(arg_0 -> FXGLDefaultMenu.switchMenuTo$lambda$26(menu, this, oldMenu, arg_0));
        ft.play();
    }

    private final void switchMenuContentTo(Node content) {
        this.menuContentRoot.getChildren().set(0, (Object)content);
    }

    private final String makeVersionString() {
        return "v" + FXGLForKtKt.getSettings().getVersion() + (String)(FXGLForKtKt.getSettings().getApplicationMode() == ApplicationMode.RELEASE ? "" : "-" + FXGLForKtKt.getSettings().getApplicationMode());
    }

    @NotNull
    protected final MenuContent createContentLoad() {
        log.debug("createContentLoad()");
        ListView list = FXGLForKtKt.getUIFactoryService().newListView();
        double FONT_SIZE = 16.0;
        list.setCellFactory(arg_0 -> FXGLDefaultMenu.createContentLoad$lambda$27(FONT_SIZE, arg_0));
        IOTask task2 = this.getSaveLoadService().readSaveFilesTask("./", FXGLForKtKt.getSettings().getSaveFileExt()).onSuccess(arg_0 -> FXGLDefaultMenu.createContentLoad$lambda$28(list, arg_0));
        IOTaskExecutorService iOTaskExecutorService = FXGL.Companion.getTaskService();
        Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"task");
        iOTaskExecutorService.runAsyncFXWithDialog(task2, FXGLForKtKt.localize("menu.load"));
        list.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)list.getItems()).multiply(FONT_SIZE).add(16));
        Button btnLoad = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.load"));
        btnLoad.disableProperty().bind((ObservableValue)list.getSelectionModel().selectedItemProperty().isNull());
        btnLoad.setOnAction(arg_0 -> FXGLDefaultMenu.createContentLoad$lambda$29(list, this, arg_0));
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        btnDelete.disableProperty().bind((ObservableValue)list.getSelectionModel().selectedItemProperty().isNull());
        btnDelete.setOnAction(arg_0 -> FXGLDefaultMenu.createContentLoad$lambda$30(list, this, arg_0));
        Node[] nodeArray = new Node[]{(Node)btnLoad, (Node)btnDelete};
        HBox hbox = new HBox(50.0, nodeArray);
        hbox.setAlignment(Pos.CENTER);
        nodeArray = new Node[2];
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        nodeArray[0] = (Node)list;
        nodeArray[1] = (Node)hbox;
        return new MenuContent(nodeArray);
    }

    @NotNull
    protected final MenuContent createContentGameplay() {
        log.debug("createContentGameplay()");
        return new MenuContent(new Node[0]);
    }

    @NotNull
    protected final MenuContent createContentControls() {
        log.debug("createContentControls()");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0, 200.0, 200.0, Priority.ALWAYS, HPos.LEFT, true));
        grid.getRowConstraints().add((Object)new RowConstraints(40.0, 40.0, 40.0, Priority.ALWAYS, VPos.CENTER, true));
        grid.setUserData((Object)0);
        Map $this$forEach$iv = FXGLForKtKt.getInput().getAllBindings();
        boolean $i$f$forEach = false;
        Node[] nodeArray = $this$forEach$iv.entrySet().iterator();
        while (nodeArray.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = nodeArray.next();
            boolean bl = false;
            UserAction action = (UserAction)entry.getKey();
            Trigger trigger = (Trigger)entry.getValue();
            this.addNewInputBinding(action, trigger, grid);
        }
        FXGLScrollPane scroll = new FXGLScrollPane((Node)grid);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scroll.setMaxHeight((double)FXGLForKtKt.getAppHeight() / 2.5);
        nodeArray = new Node[]{(Node)scroll};
        HBox hbox = new HBox(nodeArray);
        hbox.setAlignment(Pos.CENTER);
        nodeArray = new Node[]{(Node)hbox};
        return new MenuContent(nodeArray);
    }

    private final void addNewInputBinding(UserAction action, Trigger trigger, GridPane grid) {
        Text actionName = FXGLForKtKt.getUIFactoryService().newText(action.getName(), Color.WHITE, 18.0);
        TriggerView triggerView = new TriggerView(trigger, null, 0.0, 6, null);
        triggerView.triggerProperty().bind((ObservableValue)FXGLForKtKt.getInput().triggerProperty(action));
        triggerView.setOnMouseClicked(new EventHandler(this, action){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ UserAction $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
            }

            public final void handle(MouseEvent it) {
                if (FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).isActive()) {
                    return;
                }
                FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).setActive(true);
                FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).setActionContext(this.$action);
                FXGL.Companion.getSceneService().pushSubScene((SubScene)FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0));
            }
        });
        HBox hBox = new HBox();
        hBox.setPrefWidth(100.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add((Object)triggerView);
        Object object = grid.getUserData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int controlsRow = (Integer)object;
        int n = controlsRow++;
        Node[] nodeArray = new Node[]{(Node)actionName, (Node)hBox};
        grid.addRow(n, nodeArray);
        grid.setUserData((Object)controlsRow);
    }

    @NotNull
    protected final MenuContent createContentVideo() {
        Node[] nodeArray;
        log.debug("createContentVideo()");
        ChoiceBox languageBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList((Collection)FXGLForKtKt.getSettings().getSupportedLanguages()));
        languageBox.setValue(FXGLForKtKt.getSettings().getLanguage().getValue());
        languageBox.setConverter((StringConverter)new StringConverter<Language>(){

            @NotNull
            public String toString(@NotNull Language object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                return object.getNativeName();
            }

            @NotNull
            public Language fromString(@NotNull String string) {
                Language language;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                    Iterable iterable = FXGLForKtKt.getSettings().getSupportedLanguages();
                    for (T t : iterable) {
                        Language it = (Language)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getNativeName(), (Object)string)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                if ((language = (Language)v0) == null) {
                    language = Language.NONE;
                }
                return language;
            }
        });
        FXGLForKtKt.getSettings().getLanguage().bindBidirectional((Property)languageBox.valueProperty());
        VBox vbox = new VBox();
        if (FXGLForKtKt.getSettings().isFullScreenAllowed()) {
            CheckBox cbFullScreen = FXGLForKtKt.getUIFactoryService().newCheckBox();
            cbFullScreen.selectedProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().getFullScreen());
            nodeArray = new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localize("menu.fullscreen") + ": "), (Node)cbFullScreen};
            vbox.getChildren().add((Object)new HBox(25.0, nodeArray));
        }
        Node[] nodeArray2 = new Node[2];
        nodeArray = new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.language").concat((Object)":")), (Node)languageBox};
        nodeArray2[0] = (Node)new HBox(25.0, nodeArray);
        nodeArray2[1] = (Node)vbox;
        return new MenuContent(nodeArray2);
    }

    @NotNull
    protected final MenuContent createContentAudio() {
        log.debug("createContentAudio()");
        Slider sliderMusic = new Slider(0.0, 1.0, 1.0);
        sliderMusic.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalMusicVolumeProperty());
        Text textMusic = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.music.volume").concat((Object)": "));
        Text percentMusic = FXGLForKtKt.getUIFactoryService().newText("");
        percentMusic.textProperty().bind((ObservableValue)sliderMusic.valueProperty().multiply(100).asString("%.0f"));
        Slider sliderSound = new Slider(0.0, 1.0, 1.0);
        sliderSound.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalSoundVolumeProperty());
        Text textSound = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.sound.volume").concat((Object)": "));
        Text percentSound = FXGLForKtKt.getUIFactoryService().newText("");
        percentSound.textProperty().bind((ObservableValue)sliderSound.valueProperty().multiply(100).asString("%.0f"));
        Node[] nodeArray = new Node[]{(Node)textMusic, (Node)sliderMusic, (Node)percentMusic};
        HBox hboxMusic = new HBox(15.0, nodeArray);
        Node[] nodeArray2 = new Node[]{(Node)textSound, (Node)sliderSound, (Node)percentSound};
        HBox hboxSound = new HBox(15.0, nodeArray2);
        hboxMusic.setAlignment(Pos.CENTER_RIGHT);
        hboxSound.setAlignment(Pos.CENTER_RIGHT);
        nodeArray2 = new Node[]{(Node)hboxMusic, (Node)hboxSound};
        return new MenuContent(nodeArray2);
    }

    @NotNull
    protected final MenuContent createContentCredits() {
        log.debug("createContentCredits()");
        FXGLScrollPane pane = new FXGLScrollPane();
        pane.setPrefWidth(500.0);
        pane.setPrefHeight((double)(FXGLForKtKt.getAppHeight() / 2));
        pane.setStyle("-fx-background:black;");
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPrefWidth(pane.getPrefWidth() - (double)15);
        ArrayList<Object> credits = new ArrayList<Object>((Collection)FXGLForKtKt.getSettings().getCredits());
        credits.add("");
        credits.add("Powered by FXGL " + FXGL.Companion.getVersion());
        credits.add("Author: Almas Baimagambetov");
        credits.add("https://github.com/AlmasB/FXGL");
        credits.add("");
        for (String string : credits) {
            if (string.length() > 45) {
                log.warning("Credit name length > 45: " + string);
            }
            vbox.getChildren().add((Object)FXGLForKtKt.getUIFactoryService().newText(string));
        }
        pane.setContent((Node)vbox);
        Node[] nodeArray = new Node[]{(Node)pane};
        return new MenuContent(nodeArray);
    }

    @NotNull
    protected final MenuContent createContentAchievements() {
        log.debug("createContentAchievements()");
        MenuContent content = new MenuContent(new Node[0]);
        Iterable $this$forEach$iv = FXGLForKtKt.getAchievementService().getAchievementsCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            CheckBox checkBox = new CheckBox();
            checkBox.setDisable(true);
            checkBox.selectedProperty().bind((ObservableValue)a.achievedProperty());
            Text text = FXGLForKtKt.getUIFactoryService().newText(a.getName());
            Tooltip tooltip = new Tooltip(a.getDescription());
            tooltip.setShowDelay(Duration.seconds((double)0.1));
            Tooltip.install((Node)((Node)text), (Tooltip)tooltip);
            Node[] nodeArray = new Node[]{(Node)text, (Node)checkBox};
            HBox box = new HBox(25.0, nodeArray);
            box.setAlignment(Pos.CENTER_RIGHT);
            content.getChildren().add((Object)box);
        }
        return content;
    }

    private final void showProfileDialog() {
        ChoiceBox profilesBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList());
        Button btnNew = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.new"));
        Button btnSelect = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.select"));
        btnSelect.disableProperty().bind((ObservableValue)profilesBox.valueProperty().isNull());
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        btnDelete.disableProperty().bind((ObservableValue)profilesBox.valueProperty().isNull());
        btnNew.setOnAction(FXGLDefaultMenu::showProfileDialog$lambda$34);
        btnSelect.setOnAction(arg_0 -> FXGLDefaultMenu.showProfileDialog$lambda$35(profilesBox, arg_0));
    }

    private static final Point2D initParticles$lambda$0(Integer it) {
        return new Point2D(FXGL.Companion.random() * 2.5, -FXGL.Companion.random() * (double)FXGL.Companion.random(80, 120));
    }

    private static final Duration initParticles$lambda$1(Integer it) {
        return Duration.seconds((double)FXGL.Companion.random(4, 7));
    }

    private static final Point2D initParticles$lambda$2(Integer it) {
        return new Point2D(0.15, 0.1);
    }

    private static final Point2D initParticles$lambda$3(FXGLDefaultMenu this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new Point2D(FXGL.Companion.random(0.0, (double)this$0.getAppWidth() - 200.0), 120.0);
    }

    private static final Point2D createTitleView$lambda$6(Integer i) {
        return i % 2 == 0 ? new Point2D(FXGL.Companion.random(-10.0, 0.0), 0.0) : new Point2D(FXGL.Companion.random(0.0, 10.0), 0.0);
    }

    private static final Duration createTitleView$lambda$7(Integer it) {
        return Duration.seconds((double)FXGL.Companion.random(4.0, 6.0));
    }

    private static final Point2D createTitleView$lambda$8(Integer it) {
        return new Point2D(-0.03, -0.03);
    }

    private static final Point2D createTitleView$lambda$9(Integer it) {
        return Point2D.ZERO;
    }

    private static final Point2D createTitleView$lambda$10() {
        return new Point2D(FXGL.Companion.random(-1.0, 1.0), FXGL.Companion.random(0.0, 0.0));
    }

    private static final void createMenuBodyMainMenu$lambda$11(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireNewGame();
    }

    private static final void createMenuBodyMainMenu$lambda$12(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireExit();
    }

    private static final void createMenuBodyGameMenu$lambda$13(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireResume();
    }

    private static final void createMenuBodyGameMenu$lambda$14(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireSave();
    }

    private static final MenuContent createMenuBodyGameMenu$lambda$15(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentLoad();
    }

    private static final void createMenuBodyGameMenu$lambda$16(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireExitToMainMenu();
    }

    private static final void createMenuBodyGameMenu$lambda$17(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fireExit();
    }

    private static final MenuContent createOptionsMenu$lambda$18(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentGameplay();
    }

    private static final MenuContent createOptionsMenu$lambda$19(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentControls();
    }

    private static final MenuContent createOptionsMenu$lambda$20(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentVideo();
    }

    private static final MenuContent createOptionsMenu$lambda$21(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentAudio();
    }

    private static final void createOptionsMenu$lambda$23$lambda$22(FXGLDefaultMenu this$0, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            this$0.switchMenuContentTo((Node)this$0.EMPTY);
            this$0.restoreDefaultSettings();
        }
    }

    private static final void createOptionsMenu$lambda$23(FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FXGL.Companion.getDialogService().showConfirmationBox(FXGLForKtKt.localize("menu.settingsRestore"), arg_0 -> FXGLDefaultMenu.createOptionsMenu$lambda$23$lambda$22(this$0, arg_0));
    }

    private static final MenuContent createExtraMenu$lambda$24(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentAchievements();
    }

    private static final MenuContent createExtraMenu$lambda$25(FXGLDefaultMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.createContentCredits();
    }

    private static final void switchMenuTo$lambda$26(Node $menu, FXGLDefaultMenu this$0, Node $oldMenu, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$menu, (String)"$menu");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $menu.setOpacity(0.0);
        this$0.menuRoot.getChildren().set(0, (Object)$menu);
        $oldMenu.setOpacity(1.0);
        FadeTransition ft2 = new FadeTransition(Duration.seconds((double)0.33), $menu);
        ft2.setToValue(1.0);
        ft2.play();
    }

    private static final ListCell createContentLoad$lambda$27(double $FONT_SIZE, ListView it) {
        return (ListCell)new ListCell<SaveFile>($FONT_SIZE){
            final /* synthetic */ double $FONT_SIZE;
            {
                this.$FONT_SIZE = $FONT_SIZE;
            }

            protected void updateItem(@Nullable SaveFile item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    String string = "%-25.25s %s";
                    Object[] objectArray = new Object[]{item.getName(), item.getDateTime().format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH-mm"))};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                    String nameDate = string2;
                    Text text = FXGLForKtKt.getUIFactoryService().newText(nameDate, Color.WHITE, FontType.MONO, this.$FONT_SIZE);
                    this.setGraphic((Node)text);
                }
            }
        };
    }

    private static final void createContentLoad$lambda$28(ListView $list, List it) {
        ObservableList observableList = $list.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        observableList.addAll((Collection)it);
    }

    private static final void createContentLoad$lambda$29(ListView $list, FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SaveFile saveFile = (SaveFile)$list.getSelectionModel().getSelectedItem();
        Intrinsics.checkNotNullExpressionValue((Object)saveFile, (String)"saveFile");
        this$0.fireLoad(saveFile);
    }

    private static final void createContentLoad$lambda$30(ListView $list, FXGLDefaultMenu this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SaveFile saveFile = (SaveFile)$list.getSelectionModel().getSelectedItem();
        Intrinsics.checkNotNullExpressionValue((Object)saveFile, (String)"saveFile");
        this$0.fireDelete(saveFile);
    }

    private static final void showProfileDialog$lambda$34$lambda$33(String name) {
    }

    private static final void showProfileDialog$lambda$34(ActionEvent it) {
        FXGLForKtKt.getDialogService().showInputBox(FXGLForKtKt.localize("profile.new"), InputPredicates.ALPHANUM, FXGLDefaultMenu::showProfileDialog$lambda$34$lambda$33);
    }

    private static final void showProfileDialog$lambda$35(ChoiceBox $profilesBox, ActionEvent it) {
        String name = (String)$profilesBox.getValue();
        FXGLForKtKt.getSettings().getProfileName().set(name);
    }

    public static final /* synthetic */ void access$switchMenuContentTo(FXGLDefaultMenu $this, Node content) {
        $this.switchMenuContentTo(content);
    }

    public static final /* synthetic */ void access$switchMenuTo(FXGLDefaultMenu $this, Node menu) {
        $this.switchMenuTo(menu);
    }

    public static final /* synthetic */ PressAnyKeyState access$getPressAnyKeyState$p(FXGLDefaultMenu $this) {
        return $this.pressAnyKeyState;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0004R\u00020\u00050\u0003\"\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0004R\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "Ljavafx/scene/layout/VBox;", "items", "", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;", "([Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;)V", "layoutHeight", "", "getLayoutHeight", "()D", "add", "", "item", "fxgl"})
    private static final class MenuBox
    extends VBox {
        public MenuBox(MenuButton ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            for (MenuButton item : items) {
                this.add(item);
            }
        }

        public final double getLayoutHeight() {
            return 10 * this.getChildren().size();
        }

        public final void add(@NotNull MenuButton item) {
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            item.setParent(this);
            Object[] objectArray = new Node[]{(Node)item};
            this.getChildren().addAll(objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u001e\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\b\b\u0002\u0010\u0017\u001a\u00020\fJ\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;", "Ljavafx/scene/layout/Pane;", "stringKey", "", "(Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;Ljava/lang/String;)V", "btn", "Ljavafx/scene/control/Button;", "getBtn", "()Ljavafx/scene/control/Button;", "cachedContent", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "isAnimating", "", "p", "Ljavafx/scene/shape/Polygon;", "parent", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "setChild", "", "menu", "setMenuContent", "contentSupplier", "Ljava/util/function/Supplier;", "isCached", "setOnAction", "e", "Ljavafx/event/EventHandler;", "Ljavafx/event/ActionEvent;", "setParent", "fxgl"})
    private final class MenuButton
    extends Pane {
        @Nullable
        private MenuBox parent;
        @Nullable
        private MenuContent cachedContent;
        @NotNull
        private final Polygon p;
        @NotNull
        private final Button btn;
        private boolean isAnimating;

        public MenuButton(String stringKey) {
            Intrinsics.checkNotNullParameter((Object)stringKey, (String)"stringKey");
            double[] dArray = new double[]{0.0, 0.0, 220.0, 0.0, 250.0, 35.0, 0.0, 35.0};
            this.p = new Polygon(dArray);
            Button button = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty(stringKey));
            Intrinsics.checkNotNullExpressionValue((Object)button, (String)"getUIFactoryService().ne\u2026tringProperty(stringKey))");
            this.btn = button;
            this.btn.setAlignment(Pos.CENTER_LEFT);
            this.btn.setStyle("-fx-background-color: transparent");
            this.p.setMouseTransparent(true);
            Object[] objectArray = new Stop[]{new Stop(0.6, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.34)), new Stop(0.85, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.74)), new Stop(1.0, Color.WHITE)};
            LinearGradient g = new LinearGradient(0.0, 1.0, 1.0, 0.2, true, CycleMethod.NO_CYCLE, (Stop[])objectArray);
            ObjectProperty objectProperty = this.p.fillProperty();
            When when = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.btn.pressedProperty()));
            Color color = Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.75);
            Intrinsics.checkNotNull((Object)color, (String)"null cannot be cast to non-null type javafx.scene.paint.Paint");
            objectProperty.bind((ObservableValue)when.then((Object)((Paint)color)).otherwise((Object)g));
            this.p.setStroke((Paint)Color.color((double)0.1, (double)0.1, (double)0.1, (double)0.15));
            if (!FXGLForKtKt.getSettings().isNative()) {
                this.p.setEffect((Effect)new GaussianBlur());
            }
            this.p.visibleProperty().bind((ObservableValue)this.btn.hoverProperty());
            objectArray = new Node[]{(Node)this.btn, (Node)this.p};
            this.getChildren().addAll(objectArray);
            this.btn.focusedProperty().addListener((arg_0, arg_1, arg_2) -> MenuButton._init_$lambda$0((Function3)new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(){

                public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean isFocused) {
                    Intrinsics.checkNotNullExpressionValue((Object)isFocused, (String)"isFocused");
                    if (isFocused.booleanValue()) {
                        boolean isOK;
                        boolean bl2;
                        block5: {
                            Iterable $this$none$iv = FXGLDefaultMenu.this.animations;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    Animation it = (Animation)element$iv;
                                    boolean bl3 = false;
                                    if (!it.isAnimating()) continue;
                                    bl2 = false;
                                    break block5;
                                }
                                bl2 = true;
                            }
                        }
                        boolean bl4 = isOK = bl2 && !isAnimating;
                        if (isOK) {
                            isAnimating = true;
                            FXGL.Companion.animationBuilder().onFinished(() -> 1.invoke$lambda$1(this)).bobbleDown((Node)this).buildAndPlay((UpdatableRunner)FXGLDefaultMenu.this);
                        }
                    }
                }

                private static final void invoke$lambda$1(MenuButton this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    this$0.isAnimating = false;
                }
            }, arg_0, arg_1, arg_2));
        }

        @NotNull
        public final Button getBtn() {
            return this.btn;
        }

        public final void setOnAction(@NotNull EventHandler<ActionEvent> e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            this.btn.setOnAction(e);
        }

        public final void setParent(@NotNull MenuBox menu) {
            Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
            this.parent = menu;
        }

        public final void setMenuContent(@NotNull Supplier<MenuContent> contentSupplier, boolean isCached) {
            Intrinsics.checkNotNullParameter(contentSupplier, (String)"contentSupplier");
            this.btn.addEventHandler(ActionEvent.ACTION, new EventHandler(this, isCached, contentSupplier, FXGLDefaultMenu.this){
                final /* synthetic */ MenuButton this$0;
                final /* synthetic */ boolean $isCached;
                final /* synthetic */ Supplier<MenuContent> $contentSupplier;
                final /* synthetic */ FXGLDefaultMenu this$1;
                {
                    this.this$0 = $receiver;
                    this.$isCached = $isCached;
                    this.$contentSupplier = $contentSupplier;
                    this.this$1 = $receiver2;
                }

                public final void handle(ActionEvent it) {
                    if (MenuButton.access$getCachedContent$p(this.this$0) == null || !this.$isCached) {
                        MenuButton.access$setCachedContent$p(this.this$0, this.$contentSupplier.get());
                    }
                    MenuContent menuContent = MenuButton.access$getCachedContent$p(this.this$0);
                    Intrinsics.checkNotNull((Object)((Object)menuContent));
                    FXGLDefaultMenu.access$switchMenuContentTo(this.this$1, (Node)menuContent);
                }
            });
        }

        public static /* synthetic */ void setMenuContent$default(MenuButton menuButton, Supplier supplier, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            menuButton.setMenuContent(supplier, bl);
        }

        public final void setChild(@NotNull MenuBox menu) {
            Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
            MenuButton back = new MenuButton("menu.back");
            menu.getChildren().add(0, (Object)back);
            back.addEventHandler(ActionEvent.ACTION, new EventHandler(FXGLDefaultMenu.this, this){
                final /* synthetic */ FXGLDefaultMenu this$0;
                final /* synthetic */ MenuButton this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final void handle(ActionEvent it) {
                    MenuBox menuBox = MenuButton.access$getParent$p(this.this$1);
                    Intrinsics.checkNotNull((Object)((Object)menuBox));
                    FXGLDefaultMenu.access$switchMenuTo(this.this$0, (Node)menuBox);
                }
            });
            this.btn.addEventHandler(ActionEvent.ACTION, new EventHandler(FXGLDefaultMenu.this, menu){
                final /* synthetic */ FXGLDefaultMenu this$0;
                final /* synthetic */ MenuBox $menu;
                {
                    this.this$0 = $receiver;
                    this.$menu = $menu;
                }

                public final void handle(ActionEvent it) {
                    FXGLDefaultMenu.access$switchMenuTo(this.this$0, (Node)this.$menu);
                }
            });
        }

        private static final void _init_$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke((Object)p0, p1, p2);
        }

        public static final /* synthetic */ MenuContent access$getCachedContent$p(MenuButton $this) {
            return $this.cachedContent;
        }

        public static final /* synthetic */ void access$setCachedContent$p(MenuButton $this, MenuContent menuContent) {
            $this.cachedContent = menuContent;
        }

        public static final /* synthetic */ MenuBox access$getParent$p(MenuButton $this) {
            return $this.parent;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u000fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "Ljavafx/scene/layout/VBox;", "items", "", "Ljavafx/scene/Node;", "([Ljavafx/scene/Node;)V", "maxW", "", "getMaxW", "()I", "setMaxW", "(I)V", "onClose", "Ljava/lang/Runnable;", "onOpen", "", "setOnClose", "onCloseAction", "setOnOpen", "onOpenAction", "fxgl"})
    public static final class MenuContent
    extends VBox {
        @Nullable
        private Runnable onOpen;
        @Nullable
        private Runnable onClose;
        private int maxW;

        public MenuContent(Node ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            if (!(items.length == 0)) {
                this.maxW = (int)items[0].getLayoutBounds().getWidth();
                for (Node n : items) {
                    int w = (int)n.getLayoutBounds().getWidth();
                    if (w <= this.maxW) continue;
                    this.maxW = w;
                }
                for (Node item : items) {
                    Object[] objectArray = new Node[]{item};
                    this.getChildren().addAll(objectArray);
                }
            }
            this.sceneProperty().addListener((arg_0, arg_1, arg_2) -> MenuContent._init_$lambda$0((Function3)new Function3<ObservableValue<? extends Scene>, Scene, Scene, Unit>(){

                public final void invoke(ObservableValue<? extends Scene> observableValue, Scene scene, Scene newScene) {
                    if (newScene != null) {
                        this.onOpen();
                    } else {
                        this.onClose();
                    }
                }
            }, arg_0, arg_1, arg_2));
        }

        public final int getMaxW() {
            return this.maxW;
        }

        public final void setMaxW(int n) {
            this.maxW = n;
        }

        public final void setOnOpen(@NotNull Runnable onOpenAction) {
            Intrinsics.checkNotNullParameter((Object)onOpenAction, (String)"onOpenAction");
            this.onOpen = onOpenAction;
        }

        public final void setOnClose(@NotNull Runnable onCloseAction) {
            Intrinsics.checkNotNullParameter((Object)onCloseAction, (String)"onCloseAction");
            this.onClose = onCloseAction;
        }

        private final void onOpen() {
            if (this.onOpen != null) {
                Runnable runnable = this.onOpen;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        private final void onClose() {
            if (this.onClose != null) {
                Runnable runnable = this.onClose;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        private static final void _init_$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke((Object)p0, p1, p2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$PressAnyKeyState;", "Lcom/almasb/fxgl/scene/SubScene;", "(Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;)V", "actionContext", "Lcom/almasb/fxgl/input/UserAction;", "getActionContext", "()Lcom/almasb/fxgl/input/UserAction;", "setActionContext", "(Lcom/almasb/fxgl/input/UserAction;)V", "isActive", "", "()Z", "setActive", "(Z)V", "fxgl"})
    private final class PressAnyKeyState
    extends SubScene {
        @Nullable
        private UserAction actionContext;
        private boolean isActive;

        public PressAnyKeyState() {
            Input input = this.getInput();
            EventType eventType = KeyEvent.KEY_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"KEY_PRESSED");
            input.addEventFilter(eventType, arg_0 -> PressAnyKeyState._init_$lambda$0(this, arg_0));
            Input input2 = this.getInput();
            EventType eventType2 = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"MOUSE_PRESSED");
            input2.addEventFilter(eventType2, arg_0 -> PressAnyKeyState._init_$lambda$1(this, arg_0));
            Rectangle rect = new Rectangle(250.0, 100.0);
            rect.setStroke((Paint)Color.color((double)0.85, (double)0.9, (double)0.9, (double)0.95));
            rect.setStrokeWidth(10.0);
            rect.setArcWidth(15.0);
            rect.setArcHeight(15.0);
            Text text = FXGLForKtKt.getUIFactoryService().newText("", 24.0);
            text.textProperty().bind((ObservableValue)FXGLForKtKt.localizedStringProperty("menu.pressAnyKey"));
            Node[] nodeArray = new Node[]{(Node)rect, (Node)text};
            StackPane pane = new StackPane(nodeArray);
            pane.setTranslateX((double)FXGLForKtKt.getAppWidth() / 2.0 - (double)125);
            pane.setTranslateY((double)FXGLForKtKt.getAppHeight() / 2.0 - (double)50);
            this.getContentRoot().getChildren().add((Object)pane);
        }

        @Nullable
        public final UserAction getActionContext() {
            return this.actionContext;
        }

        public final void setActionContext(@Nullable UserAction userAction) {
            this.actionContext = userAction;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public final void setActive(boolean bl) {
            this.isActive = bl;
        }

        private static final void _init_$lambda$0(PressAnyKeyState this$0, KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            KeyCode keyCode = e.getCode();
            Intrinsics.checkNotNullExpressionValue((Object)keyCode, (String)"e.code");
            if (Input.Companion.isIllegal(keyCode)) {
                return;
            }
            Input input = FXGLForKtKt.getInput();
            UserAction userAction = this$0.actionContext;
            Intrinsics.checkNotNull((Object)userAction);
            KeyCode keyCode2 = e.getCode();
            Intrinsics.checkNotNullExpressionValue((Object)keyCode2, (String)"e.code");
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            boolean rebound = input.rebind(userAction, keyCode2, InputModifier.Companion.from(e));
            if (rebound) {
                FXGL.Companion.getSceneService().popSubScene();
                this$0.isActive = false;
            }
        }

        private static final void _init_$lambda$1(PressAnyKeyState this$0, MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Input input = FXGLForKtKt.getInput();
            UserAction userAction = this$0.actionContext;
            Intrinsics.checkNotNull((Object)userAction);
            MouseButton mouseButton = e.getButton();
            Intrinsics.checkNotNullExpressionValue((Object)mouseButton, (String)"e.button");
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            boolean rebound = input.rebind(userAction, mouseButton, InputModifier.Companion.from(e));
            if (rebound) {
                FXGL.Companion.getSceneService().popSubScene();
                this$0.isActive = false;
            }
        }
    }
}

