/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.io.FileSystemService;
import com.almasb.fxgl.logging.Logger;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/app/services/SystemBundleService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "getBundle$fxgl", "()Lcom/almasb/fxgl/core/serialization/Bundle;", "setBundle$fxgl", "(Lcom/almasb/fxgl/core/serialization/Bundle;)V", "fs", "Lcom/almasb/fxgl/io/FileSystemService;", "isFileSystemWriteAllowed", "", "isNative", "log", "Lcom/almasb/fxgl/logging/Logger;", "createRequiredDirs", "", "loadDefaultSystemData", "loadSystemData", "onExit", "onInit", "saveSystemData", "fxgl"})
public final class SystemBundleService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @Inject(value="isNative")
    private boolean isNative;
    @Inject(value="isFileSystemWriteAllowed")
    private boolean isFileSystemWriteAllowed = true;
    private FileSystemService fs;
    public Bundle bundle;

    @NotNull
    public final Bundle getBundle$fxgl() {
        Bundle bundle = this.bundle;
        if (bundle != null) {
            return bundle;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        return null;
    }

    public final void setBundle$fxgl(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"<set-?>");
        this.bundle = bundle;
    }

    public void onInit() {
        boolean isFirstRun;
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        boolean bl = isFirstRun = !fileSystemService.exists("system/");
        if (!this.isNative && this.isFileSystemWriteAllowed) {
            if (isFirstRun) {
                this.createRequiredDirs();
                this.loadDefaultSystemData();
            } else {
                this.loadSystemData();
            }
        } else {
            this.loadDefaultSystemData();
        }
    }

    public void onExit() {
        if (!this.isFileSystemWriteAllowed) {
            return;
        }
        if (!this.isNative) {
            this.saveSystemData();
        }
    }

    private final void createRequiredDirs() {
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        fileSystemService.createDirectoryTask("system/").then(arg_0 -> SystemBundleService.createRequiredDirs$lambda$0(this, arg_0)).onFailure(arg_0 -> SystemBundleService.createRequiredDirs$lambda$1(this, arg_0)).run();
    }

    private final void saveSystemData() {
        this.log.debug("Saving FXGL system data");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        fileSystemService.writeDataTask((Serializable)this.getBundle$fxgl(), "system/fxgl.bundle").onFailure(arg_0 -> SystemBundleService.saveSystemData$lambda$2(this, arg_0)).run();
    }

    private final void loadSystemData() {
        this.log.debug("Loading FXGL system data");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        fileSystemService.readDataTask("system/fxgl.bundle").onSuccess(arg_0 -> SystemBundleService.loadSystemData$lambda$3(this, arg_0)).onFailure(arg_0 -> SystemBundleService.loadSystemData$lambda$4(this, arg_0)).run();
    }

    private final void loadDefaultSystemData() {
        this.log.debug("Loading default FXGL system data");
        this.setBundle$fxgl(new Bundle("FXGL"));
    }

    private static final IOTask createRequiredDirs$lambda$0(SystemBundleService this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FileSystemService fileSystemService = this$0.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        return fileSystemService.writeDataTask(CollectionsKt.listOf((Object)"This directory contains FXGL system data files."), "system/Readme.txt");
    }

    private static final void createRequiredDirs$lambda$1(SystemBundleService this$0, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.log.warning("Failed to create system dir: " + e);
        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
    }

    private static final void saveSystemData$lambda$2(SystemBundleService this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.log.warning("Failed to save: " + it);
    }

    private static final void loadSystemData$lambda$3(SystemBundleService this$0, Bundle it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setBundle$fxgl(it);
        this$0.log.debug(String.valueOf(this$0.getBundle$fxgl()));
    }

    private static final void loadSystemData$lambda$4(SystemBundleService this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.log.warning("Failed to load: " + it);
        this$0.loadDefaultSystemData();
    }
}

