/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.effects;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.dsl.components.Effect;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.texture.Texture;
import java.util.ArrayList;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001aH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0013j\b\u0012\u0004\u0012\u00020\u0003`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/dsl/effects/WobbleEffect;", "Lcom/almasb/fxgl/dsl/components/Effect;", "texture", "Lcom/almasb/fxgl/texture/Texture;", "duration", "Ljavafx/util/Duration;", "radius", "", "numChunks", "orientation", "Ljavafx/geometry/Orientation;", "(Lcom/almasb/fxgl/texture/Texture;Ljavafx/util/Duration;IILjavafx/geometry/Orientation;)V", "newView", "Ljavafx/scene/Group;", "getNumChunks", "()I", "getOrientation", "()Ljavafx/geometry/Orientation;", "quads", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getRadius", "getTexture", "()Lcom/almasb/fxgl/texture/Texture;", "tick", "getChunkSize", "", "getMaxDimension", "onEnd", "", "entity", "Lcom/almasb/fxgl/entity/Entity;", "onStart", "onUpdate", "tpf", "fxgl"})
@SourceDebugExtension(value={"SMAP\nWobbleEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WobbleEffect.kt\ncom/almasb/fxgl/dsl/effects/WobbleEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1855#2,2:108\n1864#2,3:110\n1855#2,2:113\n*S KotlinDebug\n*F\n+ 1 WobbleEffect.kt\ncom/almasb/fxgl/dsl/effects/WobbleEffect\n*L\n82#1:108,2\n90#1:110,3\n105#1:113,2\n*E\n"})
public final class WobbleEffect
extends Effect {
    @NotNull
    private final Texture texture;
    private final int radius;
    private final int numChunks;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final ArrayList<Texture> quads;
    @NotNull
    private final Group newView;
    private int tick;

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius, int numChunks, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        super(duration);
        this.texture = texture;
        this.radius = radius;
        this.numChunks = numChunks;
        this.orientation = orientation;
        this.quads = new ArrayList();
        this.newView = new Group();
        double chunkSize = this.getChunkSize();
        double endVal = this.getMaxDimension();
        double minVal = 0.0;
        while (minVal < endVal) {
            double maxVal;
            Texture quad = null;
            double d = maxVal = minVal + chunkSize > endVal ? endVal : (double)((int)(minVal + chunkSize));
            if (this.orientation == Orientation.HORIZONTAL) {
                quad = this.texture.subTexture(new Rectangle2D(0.0, minVal, this.texture.getImage().getWidth(), maxVal - minVal));
                quad.setTranslateY(minVal);
            } else {
                quad = this.texture.subTexture(new Rectangle2D(minVal, 0.0, maxVal - minVal, this.texture.getImage().getHeight()));
                quad.setTranslateX(minVal);
            }
            minVal = maxVal;
            this.quads.add(quad);
            this.newView.getChildren().add((Object)quad);
        }
    }

    public /* synthetic */ WobbleEffect(Texture texture, Duration duration, int n, int n2, Orientation orientation, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 2;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        if ((n3 & 0x10) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        this(texture, duration, n, n2, orientation);
    }

    @NotNull
    public final Texture getTexture() {
        return this.texture;
    }

    public final int getRadius() {
        return this.radius;
    }

    public final int getNumChunks() {
        return this.numChunks;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    private final double getMaxDimension() {
        return this.orientation == Orientation.HORIZONTAL ? this.texture.getImage().getHeight() : this.texture.getImage().getWidth();
    }

    private final double getChunkSize() {
        return this.orientation == Orientation.HORIZONTAL ? this.texture.getImage().getHeight() / (double)this.numChunks : this.texture.getImage().getWidth() / (double)this.numChunks;
    }

    @Override
    public void onStart(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.tick = 0;
        Iterable $this$forEach$iv = entity.getViewComponent().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setVisible(false);
        }
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        ViewComponent.addChild$default((ViewComponent)viewComponent, (Node)((Node)this.newView), (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ++this.tick;
        Iterable $this$forEachIndexed$iv = this.quads;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void quad;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Texture texture = (Texture)item$iv;
            int index = n;
            boolean bl = false;
            double value = FXGLMath.sin((double)((double)this.tick + (double)index / 0.5)) * (double)this.radius;
            if (this.orientation == Orientation.HORIZONTAL) {
                quad.setTranslateX(value);
                continue;
            }
            quad.setTranslateY(value);
        }
    }

    @Override
    public void onEnd(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.getViewComponent().removeChild((Node)this.newView);
        Iterable $this$forEach$iv = entity.getViewComponent().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setVisible(true);
        }
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius, int numChunks) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this(texture, duration, radius, numChunks, null, 16, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this(texture, duration, radius, 0, null, 24, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this(texture, duration, 0, 0, null, 28, null);
    }
}

