/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgora.rpnlibrary;

import com.github.bgora.rpnlibrary.CalculatorInterface;
import com.github.bgora.rpnlibrary.DefaultChecker;
import com.github.bgora.rpnlibrary.DefaultExecutioner;
import com.github.bgora.rpnlibrary.RPNChecking;
import com.github.bgora.rpnlibrary.RPNExecuting;
import com.github.bgora.rpnlibrary.exceptions.NoSuchFunctionFound;
import com.github.bgora.rpnlibrary.exceptions.WrongArgumentException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;

public class Calculator
implements CalculatorInterface {
    protected RPNChecking checker;
    protected RPNExecuting executioner;
    protected RoundingMode roundingMode;

    public static Calculator createDefaultCalculator() {
        return Calculator.createDefaultCalculator(RoundingMode.HALF_EVEN);
    }

    public static Calculator createDefaultCalculator(RoundingMode mode) {
        return new Calculator(new DefaultChecker(), new DefaultExecutioner(), mode);
    }

    public static Calculator createCalculator(RoundingMode mode, RPNChecking checker, RPNExecuting executioner) {
        return new Calculator(checker, executioner, mode);
    }

    protected Calculator(RPNChecking checker, RPNExecuting executioner, RoundingMode mode) {
        this.checker = checker;
        this.executioner = executioner;
        this.roundingMode = mode;
    }

    @Override
    public BigDecimal calculate(String input) throws WrongArgumentException, NoSuchFunctionFound {
        String temp = this.prepareInput(input);
        String result = this.createRPN(temp);
        return this.getResult(result);
    }

    private String prepareInput(String input) throws WrongArgumentException {
        StringBuilder result = new StringBuilder();
        String inputValue = input.trim();
        int length = inputValue.length();
        char c = '\u0000';
        boolean lastWasDigit = false;
        boolean lastWasOperator = false;
        boolean lastWasWhiteSpace = false;
        boolean lastWasLetter = false;
        for (int i = 0; i < length; ++i) {
            c = inputValue.charAt(i);
            if (this.isDigitOrSeparator(c) && (lastWasDigit || !lastWasOperator)) {
                lastWasDigit = true;
                result.append(c);
                lastWasWhiteSpace = false;
                lastWasLetter = false;
                continue;
            }
            if (Character.isDigit(c)) {
                lastWasDigit = true;
                lastWasLetter = false;
                lastWasOperator = false;
                if (!lastWasWhiteSpace) {
                    result.append(" ");
                }
                result.append(c);
                lastWasWhiteSpace = false;
                continue;
            }
            if (this.checker.isOperatorOrBracket(String.valueOf(c))) {
                lastWasDigit = false;
                lastWasLetter = false;
                lastWasOperator = true;
                if (!lastWasWhiteSpace) {
                    result.append(" ");
                }
                result.append(c);
                lastWasWhiteSpace = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (!lastWasWhiteSpace && !lastWasDigit) {
                    result.append(" ");
                    lastWasWhiteSpace = true;
                }
                lastWasDigit = false;
                lastWasOperator = false;
                continue;
            }
            if (Character.isLetter(c)) {
                lastWasDigit = false;
                lastWasOperator = false;
                if (!lastWasLetter && !lastWasWhiteSpace) {
                    result.append(" ").append(c);
                } else {
                    result.append(c);
                }
                lastWasWhiteSpace = false;
                lastWasLetter = true;
                continue;
            }
            throw new WrongArgumentException("Element \"" + c + "\" is not recognized by the Checker");
        }
        return result.toString().trim();
    }

    private boolean isDigitOrSeparator(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    private String createRPN(String input) throws WrongArgumentException {
        String trimmed = input.trim();
        StringBuilder result = new StringBuilder();
        LinkedList<String> stack = new LinkedList<String>();
        String[] factors = trimmed.split(" ");
        int length = factors.length;
        String temp = null;
        String stackOper = null;
        for (int i = 0; i < length; ++i) {
            temp = factors[i];
            if (this.checker.isDigit(temp)) {
                result.append(" ").append(temp);
                continue;
            }
            if (this.checker.isFunction(temp)) {
                stack.push(temp);
                continue;
            }
            if (",".equals(temp)) {
                do {
                    if (this.checker.isLeftBracket(stackOper = (String)stack.pop())) continue;
                    result.append(" ").append(stackOper);
                } while (!stack.isEmpty() && !this.checker.isLeftBracket(stackOper));
                continue;
            }
            if (this.checker.isOperator(temp)) {
                while (!stack.isEmpty() && this.checker.isOperator((String)stack.peek())) {
                    stackOper = (String)stack.peek();
                    if (this.checker.isLeftAssociativity(stackOper) && this.checker.compareOperators(stackOper, temp) >= 0) {
                        stack.pop();
                        result.append(" ").append(stackOper);
                        continue;
                    }
                    if (!this.checker.isRightAssociativity(stackOper) || this.checker.compareOperators(stackOper, temp) <= 0) break;
                    stack.pop();
                    result.append(" ").append(stackOper);
                }
                stack.push(temp);
                continue;
            }
            if (this.checker.isLeftBracket(temp)) {
                stack.push(temp);
                continue;
            }
            if (this.checker.isRightBracket(temp)) {
                do {
                    if (this.checker.isLeftBracket(temp = (String)stack.pop())) continue;
                    result.append(" ").append(temp);
                } while (!this.checker.isLeftBracket(temp));
                if (stack.isEmpty() || !this.checker.isFunction((String)stack.peek())) continue;
                result.append(" ").append((String)stack.pop());
                continue;
            }
            throw new WrongArgumentException("Element \"" + temp + "\" is not recognized by the Checker");
        }
        while (!stack.isEmpty()) {
            result.append(" ").append((String)stack.pop());
        }
        return result.toString().trim();
    }

    private BigDecimal getResult(String result) throws WrongArgumentException, NoSuchFunctionFound {
        String[] factors = result.trim().split(" ");
        LinkedList<String> stack = new LinkedList<String>();
        String temp = null;
        String var1 = null;
        String var2 = null;
        BigDecimal value = null;
        for (int i = 0; i < factors.length; ++i) {
            temp = factors[i];
            if (this.checker.isDigit(temp)) {
                stack.push(temp);
                continue;
            }
            if (this.checker.isOperator(temp)) {
                var1 = (String)stack.pop();
                var2 = !stack.isEmpty() ? (String)stack.pop() : "0.0";
                value = this.executioner.executeOperator(temp, var2, var1, this.roundingMode);
                stack.push(value.toPlainString());
                continue;
            }
            if (!this.checker.isFunction(temp)) continue;
            int count = this.checker.getFunctionParamsCount(temp);
            String[] table = new String[count];
            String params = (String)stack.pop();
            String[] paramsTable = params.split(",");
            for (int j = 0; j < count; ++j) {
                table[j] = paramsTable[j];
            }
            value = this.executioner.executeFunction(temp, this.roundingMode, table);
            stack.push(value.toPlainString());
        }
        return new BigDecimal((String)stack.pop());
    }
}

