/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgora.rpnlibrary;

import com.github.bgora.rpnlibrary.CalculationEngine;
import com.github.bgora.rpnlibrary.DefaultChecker;
import com.github.bgora.rpnlibrary.advanced.functions.AbstractFunctionStrategy;
import com.github.bgora.rpnlibrary.advanced.operators.AbstractOperatorStrategy;
import com.github.bgora.rpnlibrary.exceptions.NoSuchFunctionFound;
import com.github.bgora.rpnlibrary.exceptions.WrongArgumentException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class CalculatorEngine
extends DefaultChecker
implements CalculationEngine {
    private Map<String, AbstractOperatorStrategy> operators;
    private Map<String, AbstractFunctionStrategy> functions;

    public CalculatorEngine() {
    }

    public CalculatorEngine(Map<String, AbstractOperatorStrategy> operators, Map<String, AbstractFunctionStrategy> functions) {
        this.operators = operators;
        this.functions = functions;
    }

    @Override
    public boolean isOperator(String input) {
        return this.operators.containsKey(input);
    }

    @Override
    public int compareOperators(String operato1, String operator2) {
        AbstractOperatorStrategy strategy1 = this.operators.get(operato1);
        AbstractOperatorStrategy strategy2 = this.operators.get(operator2);
        return strategy1.getPriority() - strategy2.getPriority();
    }

    @Override
    public boolean isFunction(String input) {
        return this.functions.containsKey(input);
    }

    @Override
    public int getFunctionParamsCount(String functionName) {
        return this.functions.get(functionName).getParamCount();
    }

    @Override
    public BigDecimal executeOperator(String operator, String var1, String var2, RoundingMode mode) throws WrongArgumentException {
        return this.operators.get(operator).execute(var1, var2);
    }

    @Override
    public BigDecimal executeFunction(String functionName, RoundingMode mode, String ... arguments) throws NoSuchFunctionFound {
        return this.functions.get(functionName).execute(arguments);
    }

    public Map<String, AbstractOperatorStrategy> getOperators() {
        return this.operators;
    }

    public Map<String, AbstractFunctionStrategy> getFunctions() {
        return this.functions;
    }

    @Override
    public void addOperator(AbstractOperatorStrategy abstractOperatorStrategy) {
        this.operators.put(abstractOperatorStrategy.getOperator(), abstractOperatorStrategy);
    }

    @Override
    public void addFunctionStartegy(AbstractFunctionStrategy abstractFunctionStrategy) {
        this.functions.put(abstractFunctionStrategy.getName(), abstractFunctionStrategy);
    }
}

