/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgora.rpnlibrary;

import com.github.bgora.rpnlibrary.RPNChecking;
import java.util.HashMap;
import java.util.Map;

public class DefaultChecker
implements RPNChecking {
    private Map<String, Integer> operators = new HashMap<String, Integer>();
    private Map<String, Integer> functions;

    public DefaultChecker() {
        this.operators.put("+", 1);
        this.operators.put("-", 1);
        this.operators.put("*", 2);
        this.operators.put("/", 2);
        this.operators.put("^", 3);
        this.functions = new HashMap<String, Integer>();
        this.functions.put("sin", 1);
        this.functions.put("cos", 1);
        this.functions.put("tg", 1);
        this.functions.put("ctg", 1);
    }

    @Override
    public boolean isDigit(String input) {
        return Character.isDigit(input.charAt(0));
    }

    @Override
    public boolean isLeftBracket(String input) {
        return "(".equals(input);
    }

    @Override
    public boolean isOperator(String input) {
        return this.operators.containsKey(input);
    }

    @Override
    public boolean isRightBracket(String input) {
        return ")".equals(input);
    }

    @Override
    public boolean isOperatorOrBracket(String c) {
        return this.isOperator(c) || this.isRightBracket(c) || this.isLeftBracket(c);
    }

    @Override
    public boolean isLeftAssociativity(String c) {
        return "*".equals(c) || "+".equals(c) || "/".equals(c) || "-".equals(c);
    }

    @Override
    public boolean isRightAssociativity(String c) {
        return "^".equals(c);
    }

    @Override
    public int compareOperators(String operato1, String operator2) {
        Integer i1 = this.operators.get(operato1);
        Integer i2 = this.operators.get(operator2);
        return i1 - i2;
    }

    @Override
    public boolean isFunction(String input) {
        return this.functions.keySet().contains(input);
    }

    @Override
    public int getFunctionParamsCount(String functionName) {
        return this.functions.get(functionName);
    }
}

