/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgora.rpnlibrary;

import com.github.bgora.rpnlibrary.RPNExecuting;
import com.github.bgora.rpnlibrary.exceptions.NoSuchFunctionFound;
import com.github.bgora.rpnlibrary.exceptions.WrongArgumentException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DefaultExecutioner
implements RPNExecuting {
    private static final String ONE = "1";

    @Override
    public BigDecimal executeOperator(String operator, String var1, String var2, RoundingMode mode) throws WrongArgumentException {
        assert (operator != null) : "Operator cannot be null!";
        if ("+".equals(operator)) {
            return this.add(var1, var2);
        }
        if ("-".equals(operator)) {
            return this.sub(var1, var2);
        }
        if ("*".equals(operator)) {
            return this.mull(var1, var2);
        }
        if ("/".equals(operator)) {
            return this.div(var1, var2);
        }
        if ("^".equals(operator)) {
            return this.pow(var1, var2);
        }
        throw new WrongArgumentException("Unrecognized operator: " + operator);
    }

    private BigDecimal div(String var1, String var2) {
        Double big1 = new Double(var1);
        Double big2 = new Double(var2);
        return BigDecimal.valueOf(big1 / big2);
    }

    private BigDecimal mull(String var1, String var2) {
        Double big1 = new Double(var1);
        Double big2 = new Double(var2);
        return BigDecimal.valueOf(big1 * big2);
    }

    private BigDecimal sub(String var1, String var2) {
        Double big1 = new Double(var1);
        Double big2 = new Double(var2);
        return BigDecimal.valueOf(big1 - big2);
    }

    private BigDecimal add(String var1, String var2) {
        Double big1 = new Double(var1);
        Double big2 = new Double(var2);
        return BigDecimal.valueOf(big1 + big2);
    }

    private BigDecimal pow(String var1, String var2) {
        Double big1 = new Double(var1);
        Double big2 = new Double(var2);
        return BigDecimal.valueOf(Math.pow(big1, big2));
    }

    @Override
    public BigDecimal executeFunction(String functionName, RoundingMode mode, String ... arguments) throws NoSuchFunctionFound {
        if ("sin".equals(functionName)) {
            Double dec = new Double(arguments[0]);
            return BigDecimal.valueOf(Math.sin(dec));
        }
        if ("cos".equals(functionName)) {
            Double dec = new Double(arguments[0]);
            return BigDecimal.valueOf(Math.cos(dec));
        }
        if ("tg".equals(functionName)) {
            Double dec = new Double(arguments[0]);
            return BigDecimal.valueOf(Math.tan(dec));
        }
        if ("ctg".equals(functionName)) {
            Double dec = new Double(arguments[0]);
            Double tan = Math.tan(dec);
            Double one = new Double(ONE);
            return BigDecimal.valueOf(one / tan);
        }
        throw new NoSuchFunctionFound("There is no function named " + functionName);
    }
}

