/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgora.rpnlibrary.advanced.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class AbstractFunctionStrategy {
    private String name;
    private int paramCount;
    private volatile int hashCode = 0;
    protected RoundingMode roundingMode;

    public AbstractFunctionStrategy(String name, int paramCount, RoundingMode roundingMode) {
        this.name = name;
        this.paramCount = paramCount;
        this.roundingMode = roundingMode;
    }

    public String getName() {
        return this.name;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public abstract BigDecimal execute(String ... var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractFunctionStrategy) {
            AbstractFunctionStrategy rpn = (AbstractFunctionStrategy)obj;
            return this.name != null && this.name.equals(rpn.name) && this.paramCount == rpn.paramCount;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + this.name.hashCode();
            this.hashCode = result = 31 * result + this.paramCount;
        }
        return this.hashCode;
    }
}

