/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;

final class Dragons {
    public final Pattern MAILBOX_PATTERN;
    public final Pattern ADDR_SPEC_PATTERN;
    public final Pattern MAILBOX_LIST_PATTERN;
    public final Pattern ADDRESS_PATTERN;
    public final Pattern COMMENT_PATTERN;
    public final Pattern QUOTED_STRING_WO_CFWS_PATTERN;
    public final Pattern RETURN_PATH_PATTERN;
    public final Pattern GROUP_PREFIX_PATTERN;
    public final Pattern ESCAPED_QUOTE_PATTERN;
    public final Pattern ESCAPED_BSLASH_PATTERN;
    private static final Map<EnumSet<EmailAddressCriteria>, Dragons> cache = new HashMap<EnumSet<EmailAddressCriteria>, Dragons>();

    protected static Dragons fromCriteria(EnumSet<EmailAddressCriteria> criteria) {
        if (!cache.containsKey(criteria)) {
            cache.put(criteria, new Dragons(criteria));
        }
        return cache.get(criteria);
    }

    private Dragons(EnumSet<EmailAddressCriteria> criteria) {
        String crlf = "\\r\\n";
        String wsp = "[ \\t]";
        String fwsp = String.format("(?:%s*%s)?%s+", "[ \\t]", "\\r\\n", "[ \\t]");
        String dquote = "\"";
        String noWsCtl = "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F";
        String asciiText = "[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]";
        String quotedPair = String.format("(?:\\\\%s)", "[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]");
        String ctext = String.format("[%s!-'*-\\[\\]-~]", "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F");
        String ccontent = String.format("%s|%s", ctext, quotedPair);
        String comment = String.format("\\((?:(?:%s)?%s)*(?:%s)?\\)", fwsp, ccontent, fwsp);
        String cfws = String.format("(?:(?:%s)?%s)*(?:(?:(?:%s)?%s)|(?:%s))", fwsp, comment, fwsp, comment, fwsp);
        String atext = String.format("[a-zA-Z0-9!#-'*+\\-/=?^-`{-~%s%s]", criteria.contains((Object)EmailAddressCriteria.ALLOW_DOT_IN_A_TEXT) ? "." : "", criteria.contains((Object)EmailAddressCriteria.ALLOW_SQUARE_BRACKETS_IN_A_TEXT) ? "\\[]" : "");
        String regularAtext = "[a-zA-Z0-9!#-'*+\\-/=?^-`{-~]";
        String atom = String.format("(?:%s)?%s+(?:%s)?", cfws, atext, cfws);
        String dotAtomText = String.format("%s+(?:\\.%s+)*", "[a-zA-Z0-9!#-'*+\\-/=?^-`{-~]", "[a-zA-Z0-9!#-'*+\\-/=?^-`{-~]");
        String capDotAtomNoCFWS = String.format("(?:%s)?(%s)(?:%s)?", cfws, dotAtomText, cfws);
        String capDotAtomTrailingCFWS = String.format("(?:%s)?(%s)(%s)?", cfws, dotAtomText, cfws);
        String qtext = String.format("[%s!#-\\[\\]-~]", "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F");
        String localPartqtext = String.format("[%s%s", "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F", criteria.contains((Object)EmailAddressCriteria.ALLOW_PARENS_IN_LOCALPART) ? "!#-\\[\\]-~]" : "!#-'\\*-\\[]-~]");
        String qcontent = String.format("(?:%s|%s)", qtext, quotedPair);
        String localPartqcontent = String.format("(?>%s|%s)", localPartqtext, quotedPair);
        String quotedStringWOCFWS = String.format("%s(?>(?:%s)?%s)*(?:%s)?%s", "\"", fwsp, qcontent, fwsp, "\"");
        String quotedString = String.format("(?:%s)?%s(?:%s)?", cfws, quotedStringWOCFWS, cfws);
        String localPartQuotedString = String.format("(?:%s)?(%s(?:(?:%s)?%s)*(?:%s)?%s)(?:%s)?", cfws, "\"", fwsp, localPartqcontent, fwsp, "\"", cfws);
        String word = String.format("(?:(?:%s)|(?:%s))", atom, quotedString);
        String phrase = String.format("%s(?:(?:%s)%s)*", word, fwsp, word);
        String letter = "[a-zA-Z]";
        String letDig = "[a-zA-Z0-9]";
        String letDigHyp = "[a-zA-Z0-9-]";
        String rfcLabel = String.format("%s(?:%s{0,61}%s)?", "[a-zA-Z0-9]", "[a-zA-Z0-9-]", "[a-zA-Z0-9]");
        String rfc1035DomainName = String.format("%s(?:\\.%s)*\\.%s{2,26}", rfcLabel, rfcLabel, "[a-zA-Z]");
        String dtext = String.format("[%s!-Z^-~]", "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F");
        String dcontent = String.format("%s|%s", dtext, quotedPair);
        String capDomainLiteralNoCFWS = String.format("(?:%s)?(\\[(?:(?:%s)?(?:%s)+)*(?:%s)?])(?:%s)?", cfws, fwsp, dcontent, fwsp, cfws);
        String capDomainLiteralTrailingCFWS = String.format("(?:%s)?(\\[(?:(?:%s)?(?:%s)+)*(?:%s)?])(%s)?", cfws, fwsp, dcontent, fwsp, cfws);
        String rfc2822Domain = String.format("(?:%s|%s)", capDotAtomNoCFWS, capDomainLiteralNoCFWS);
        String capCFWSRfc2822Domain = String.format("(?:%s|%s)", capDotAtomTrailingCFWS, capDomainLiteralTrailingCFWS);
        String domain = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS) ? rfc2822Domain : "(?:" + cfws + ")?(" + rfc1035DomainName + ")(?:" + cfws + ")?";
        String capCFWSDomain = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS) ? capCFWSRfc2822Domain : String.format("(?:%s)?(%s)(%s)?", cfws, rfc1035DomainName, cfws);
        String localPart = String.format("(%s|%s)", capDotAtomNoCFWS, localPartQuotedString);
        String addrSpec = String.format("%s@%s", localPart, domain);
        String uniqueAddrSpec = localPart + "@" + capCFWSDomain;
        String angleAddr = String.format("(?:%s)?<%s>(%s)?", cfws, addrSpec, cfws);
        String nameAddr = String.format("(%s)??(%s)", phrase, angleAddr);
        String mailboxName = criteria.contains((Object)EmailAddressCriteria.ALLOW_QUOTED_IDENTIFIERS) ? String.format("(%s)|", nameAddr) : "";
        String mailbox = String.format("%s(%s)", mailboxName, uniqueAddrSpec);
        String returnPath = String.format("(?:(?:%s)?<((?:%s)?|%s)>(?:%s)?)", cfws, cfws, addrSpec, cfws);
        String mailboxList = String.format("(?:(?:%s)(?:,(?:%s))*)", mailbox, mailbox);
        String groupPostfix = String.format("(?:%s|(?:%s))?;(?:%s)?", cfws, mailboxList, cfws);
        String groupPrefix = phrase + ":";
        String group = groupPrefix + groupPostfix;
        String address = String.format("(?:(?:%s)|(?:%s))", mailbox, group);
        this.MAILBOX_PATTERN = Pattern.compile(mailbox);
        this.ADDR_SPEC_PATTERN = Pattern.compile(addrSpec);
        this.MAILBOX_LIST_PATTERN = Pattern.compile(mailboxList);
        this.ADDRESS_PATTERN = Pattern.compile(address);
        this.COMMENT_PATTERN = Pattern.compile(comment);
        this.QUOTED_STRING_WO_CFWS_PATTERN = Pattern.compile(quotedStringWOCFWS);
        this.RETURN_PATH_PATTERN = Pattern.compile(returnPath);
        this.GROUP_PREFIX_PATTERN = Pattern.compile(groupPrefix);
        this.ESCAPED_QUOTE_PATTERN = Pattern.compile("\\\\\"");
        this.ESCAPED_BSLASH_PATTERN = Pattern.compile("\\\\\\\\");
    }
}

