/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FilenameInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.HtmlModifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.ProcessingResult;
import com.github.blutorange.maven.plugin.closurecompiler.common.TextFileModification;
import com.github.blutorange.maven.plugin.closurecompiler.common.TextFileModifications;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.HtmlUpdate;
import com.github.blutorange.maven.plugin.closurecompiler.shared.HtmlUpdateConfig;
import com.github.blutorange.maven.plugin.closurecompiler.shared.MojoMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Range;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public final class HtmlUpdater {
    private final Log log;
    private final HtmlUpdateConfig updateConfig;

    public HtmlUpdater(MojoMetadata mojoMeta, HtmlUpdateConfig updateConfig) {
        this.log = mojoMeta.getLog();
        this.updateConfig = updateConfig;
    }

    private static Elements toElements(Element element) {
        return element != null ? new Elements(new Element[]{element}) : new Elements();
    }

    private static boolean isHtml(File file) {
        return HtmlUpdater.isHtml(file.getName());
    }

    private static boolean isHtml(String file) {
        String extension = FilenameUtils.getExtension((String)file);
        return "html".equals(extension) || "htm".equals(extension);
    }

    private static String formatPosition(Range.Position position) {
        return position.lineNumber() + ":" + position.columnNumber();
    }

    private static String toWebPath(String relativePath) {
        String unixRelativePath = FilenameUtils.separatorsToUnix((String)relativePath);
        return new File(unixRelativePath).isAbsolute() || StringUtils.startsWith((CharSequence)unixRelativePath, (CharSequence)".") ? unixRelativePath : "./" + unixRelativePath;
    }

    public void process(List<ProcessingResult> processingResults) throws MojoExecutionException {
        for (HtmlUpdate htmlUpdate : this.updateConfig.getHtmlUpdates()) {
            this.processHtmlUpdate(processingResults, htmlUpdate);
        }
    }

    private void processHtmlUpdate(List<ProcessingResult> processingResults, HtmlUpdate htmlUpdate) throws MojoExecutionException {
        List<File> htmlFiles = this.resolveHtmlFiles(htmlUpdate);
        for (File htmlFile : htmlFiles) {
            this.processHtmlFile(processingResults, htmlUpdate, htmlFile);
        }
    }

    private void processHtmlFile(List<ProcessingResult> processingResults, HtmlUpdate htmlUpdate, File htmlFile) throws MojoExecutionException {
        this.log.debug((CharSequence)("Processing HTML file <" + String.valueOf(htmlFile) + ">"));
        Charset encoding = Charset.forName(htmlUpdate.getEncoding());
        Document htmlDocument = this.parseHtmlFile(htmlFile, encoding);
        if (htmlDocument == null) {
            return;
        }
        String relativeHtmlPath = this.relativizeHtmlFile(htmlUpdate, htmlFile);
        ArrayList<TextFileModification> modifications = new ArrayList<TextFileModification>();
        for (ProcessingResult processingResult : processingResults) {
            if (processingResult.getOutput() == null) continue;
            modifications.addAll(this.processProcessingResult(processingResult, htmlUpdate, htmlDocument, relativeHtmlPath));
        }
        this.applyModifications(htmlFile, encoding, modifications);
    }

    private void applyModifications(File htmlFile, Charset encoding, List<TextFileModification> modifications) throws MojoExecutionException {
        if (modifications.isEmpty()) {
            this.log.info((CharSequence)("HTML file <" + String.valueOf(htmlFile) + "> is already up-to-date"));
        } else {
            try {
                List<TextFileModification> adjustedModifications = this.adjustModifications(htmlFile, encoding, modifications);
                boolean hasChanges = TextFileModifications.applyAndWrite(htmlFile, encoding, adjustedModifications);
                if (hasChanges) {
                    this.log.info((CharSequence)("Updated HTML file <" + String.valueOf(htmlFile) + ">"));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to apply modifications to <" + String.valueOf(htmlFile) + ">", e);
            }
        }
    }

    private List<TextFileModification> adjustModifications(File htmlFile, Charset encoding, List<TextFileModification> modifications) throws IOException {
        boolean startsWithBom = FileHelper.startsWithBom(htmlFile, encoding);
        if (startsWithBom) {
            return modifications.stream().map(modification -> modification.withOffset(1)).collect(Collectors.toList());
        }
        return modifications;
    }

    private List<TextFileModification> processProcessingResult(ProcessingResult processingResult, HtmlUpdate htmlUpdate, Document htmlDocument, String relativeHtmlPath) throws MojoExecutionException {
        File scriptFile = FileHelper.absoluteFileToCanonicalFile(processingResult.getOutput());
        String relativeScriptPath = this.relativizeScriptFile(htmlUpdate, scriptFile);
        String resolvedSourcePath = this.resolveSourcePath(htmlUpdate, relativeHtmlPath, relativeScriptPath, scriptFile);
        return this.updateHtmlFile(htmlUpdate, htmlDocument, resolvedSourcePath);
    }

    private String resolveSourcePath(HtmlUpdate htmlUpdate, String relativeHtmlPath, String relativeScriptPath, File scriptFile) {
        String sourcePath = (String)StringUtils.defaultIfBlank((CharSequence)this.updateConfig.getHtmlSourcePath(), (CharSequence)htmlUpdate.getSourcePath());
        if (sourcePath.isBlank()) {
            File relativeHtmlDirPath = new File(relativeHtmlPath).getParentFile();
            String relativePath = FileHelper.relativizeRelativePath(relativeHtmlDirPath, new File(relativeScriptPath));
            return HtmlUpdater.toWebPath(relativePath);
        }
        FilenameInterpolator interpolator = new FilenameInterpolator(sourcePath);
        boolean usePhysicalRoot = this.resolveUsePhysicalRoot(htmlUpdate);
        File scriptBaseDir = usePhysicalRoot ? scriptFile : FileHelper.getAbsoluteFile(this.updateConfig.getHtmlScriptRoot(), htmlUpdate.getScriptRoot());
        String path = interpolator.interpolateRelative(scriptFile, scriptBaseDir);
        return FilenameUtils.separatorsToUnix((String)path);
    }

    private String relativizeHtmlFile(HtmlUpdate htmlUpdate, File htmlFile) throws MojoExecutionException {
        boolean usePhysicalRoot = this.resolveUsePhysicalRoot(htmlUpdate);
        if (usePhysicalRoot) {
            return htmlFile.getPath();
        }
        File htmlRoot = FileHelper.getAbsoluteFile(this.updateConfig.getHtmlRoot(), htmlUpdate.getRoot());
        return FileHelper.relativizePath(htmlRoot, htmlFile);
    }

    private String relativizeScriptFile(HtmlUpdate htmlUpdate, File scriptFile) throws MojoExecutionException {
        boolean usePhysicalRoot = this.resolveUsePhysicalRoot(htmlUpdate);
        if (usePhysicalRoot) {
            return scriptFile.getPath();
        }
        File htmlScriptRoot = FileHelper.getAbsoluteFile(this.updateConfig.getHtmlScriptRoot(), htmlUpdate.getScriptRoot());
        return FileHelper.relativizePath(htmlScriptRoot, scriptFile);
    }

    private boolean resolveUsePhysicalRoot(HtmlUpdate htmlUpdate) {
        Boolean resolved = (Boolean)ObjectUtils.defaultIfNull((Object)htmlUpdate.isUsePhysicalRoot(), (Object)this.updateConfig.isHtmlUsePhysicalRoot());
        return Boolean.TRUE.equals(resolved);
    }

    private List<TextFileModification> updateHtmlFile(HtmlUpdate htmlUpdate, Document document, String sourcePath) {
        Elements scripts = this.findScripts(htmlUpdate, document);
        if (scripts.isEmpty()) {
            this.log.warn((CharSequence)("Did not find any script elements to update for document <" + document.location() + "> via selector <" + htmlUpdate.getScripts() + ">"));
            return List.of();
        }
        ArrayList<TextFileModification> modifications = new ArrayList<TextFileModification>();
        for (Element script : scripts) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Updating script element " + String.valueOf(script) + " at position " + HtmlUpdater.formatPosition(script.sourceRange().start())));
            }
            for (String attributeName : htmlUpdate.getAttributes()) {
                boolean isHtml = HtmlUpdater.isHtml(document.location());
                TextFileModification setAttribute = HtmlModifier.setAttribute(script, attributeName, sourcePath, isHtml);
                TextFileModification clearTextContent = HtmlModifier.clearTextContent(script);
                if (setAttribute != null) {
                    modifications.add(setAttribute);
                }
                if (clearTextContent == null) continue;
                modifications.add(clearTextContent);
            }
        }
        return modifications;
    }

    private Elements findScripts(HtmlUpdate htmlUpdate, Document document) {
        String selector = htmlUpdate.getScripts();
        if (selector.isEmpty()) {
            Elements scripts = document.getElementsByTag("SCRIPT");
            return scripts.isEmpty() ? scripts : new Elements(new Element[]{(Element)scripts.get(0)});
        }
        int colon = selector.indexOf(58);
        if (colon < 1) {
            this.log.warn((CharSequence)("Invalid selector <" + selector + ">, must starts with a type (<id:>, <css:>, or <xpath:>)"));
            return new Elements();
        }
        String type = selector.substring(0, colon);
        String value = selector.substring(colon + 1);
        switch (type) {
            case "id": {
                return HtmlUpdater.toElements(document.getElementById(value));
            }
            case "css": {
                return this.findByCssQuery(document, value);
            }
            case "xpath": {
                return this.findByXPath(document, value);
            }
        }
        this.log.warn((CharSequence)("Invalid selector <" + selector + ">, type must be one of 'id', 'css', or 'xpath'"));
        return new Elements();
    }

    private Elements findByXPath(Document document, String xPath) {
        try {
            return document.selectXpath(xPath);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not select element by XPath <" + xPath + "> in document <" + document.location() + ">"), (Throwable)e);
            return new Elements();
        }
    }

    private Elements findByCssQuery(Document document, String cssQuery) {
        try {
            return document.select(cssQuery);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not select element by CSS query <" + cssQuery + "> in document <" + document.location() + ">"), (Throwable)e);
            return new Elements();
        }
    }

    private Document parseHtmlFile(File file, Charset encoding) {
        Parser parser = HtmlUpdater.isHtml(file) ? Parser.htmlParser() : Parser.xmlParser();
        parser.setTrackErrors(100);
        parser.setTrackPosition(true);
        try {
            Document document = Jsoup.parse((File)file, (String)encoding.name(), (String)file.toURI().toASCIIString(), (Parser)parser);
            for (ParseError error : parser.getErrors()) {
                this.log.error((CharSequence)("Encountered error while parsing <" + String.valueOf(file) + "> at position <" + error.getCursorPos() + "> : " + error.getErrorMessage()));
            }
            return document;
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not update (X)HTML file, file <" + String.valueOf(file) + "could not be parsed"), (Throwable)e);
            return null;
        }
    }

    private List<File> resolveHtmlFiles(HtmlUpdate htmlUpdate) {
        File base = FileHelper.getAbsoluteFile(this.updateConfig.getHtmlDir(), htmlUpdate.getDir());
        List<File> htmlFiles = htmlUpdate.getFiles().getFiles(base);
        if (htmlFiles.isEmpty()) {
            this.log.warn((CharSequence)("Did not find any HTML files to update in directory <" + String.valueOf(base) + "> with " + String.valueOf(htmlUpdate.getFiles())));
        }
        return htmlFiles;
    }
}

