/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.v5.config;

import com.github.cloudyrock.mongock.config.MongockConfiguration;
import com.github.cloudyrock.mongock.config.MongockSpringConfiguration;
import com.github.cloudyrock.mongock.driver.api.driver.ConnectionDriver;
import com.github.cloudyrock.spring.v5.MongockSpring5;
import com.github.cloudyrock.spring.v5.config.MongockDriverContextSelector;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={MongockDriverContextSelector.class})
@ConditionalOnExpression(value="${mongock.enabled:true}")
public class MongockContext {
    @Bean
    @ConditionalOnExpression(value="'${mongock.runner-type:ApplicationRunner}'.equals('ApplicationRunner')")
    public MongockSpring5.MongockApplicationRunner applicationRunner(ConnectionDriver connectionDriver, MongockSpringConfiguration springConfiguration, ApplicationContext springContext, ApplicationEventPublisher applicationEventPublisher) {
        return this.getBuilder(connectionDriver, springConfiguration, springContext, applicationEventPublisher).buildApplicationRunner();
    }

    @Bean
    @ConditionalOnExpression(value="'${mongock.runner-type:null}'.equals('InitializingBean')")
    public MongockSpring5.MongockInitializingBeanRunner initializingBeanRunner(ConnectionDriver connectionDriver, MongockSpringConfiguration springConfiguration, ApplicationContext springContext, ApplicationEventPublisher applicationEventPublisher) {
        return this.getBuilder(connectionDriver, springConfiguration, springContext, applicationEventPublisher).buildInitializingBeanRunner();
    }

    private MongockSpring5.Builder getBuilder(ConnectionDriver connectionDriver, MongockSpringConfiguration springConfiguration, ApplicationContext springContext, ApplicationEventPublisher applicationEventPublisher) {
        return (MongockSpring5.Builder)((Object)((MongockSpring5.Builder)((Object)((MongockSpring5.Builder)MongockSpring5.builder().setDriver(connectionDriver).setConfig((MongockConfiguration)springConfiguration)).setSpringContext(springContext))).setEventPublisher(applicationEventPublisher));
    }
}

