/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.v5.config.importers;

import com.github.cloudyrock.mongock.config.MongockSpringConfiguration;
import com.github.cloudyrock.spring.v5.config.importers.ArtifactDescriptor;
import com.github.cloudyrock.spring.v5.config.importers.ContextImporter;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.env.Environment;

public class MongoSpringDataImporter
implements ContextImporter {
    private static final String PACKAGE_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.";
    private static final String DRIVER_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.SpringDataMongoV%sDriver";
    private static final String CONTEXT_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.SpringDataMongoV%sContext";

    @Override
    public String[] getPaths(Environment environment) {
        try {
            return this.loadSpringDataContextByVersion("3");
        }
        catch (ClassNotFoundException e) {
            try {
                return this.loadSpringDataContextByVersion("2");
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        }
    }

    @Override
    public List<ArtifactDescriptor> getArtifacts() {
        return Arrays.asList(this.getArtifactDescriptor("3"), this.getArtifactDescriptor("2"));
    }

    private ArtifactDescriptor getArtifactDescriptor(String v) {
        return new ArtifactDescriptor("MongoDB Spring data " + v, "com.github.cloudyrock.mongock:mongodb-springdata-v" + v + "-driver");
    }

    private String[] loadSpringDataContextByVersion(String v) throws ClassNotFoundException {
        Class.forName(String.format(DRIVER_TEMPLATE, v, v));
        return new String[]{MongockSpringConfiguration.class.getCanonicalName(), String.format(CONTEXT_TEMPLATE, v, v)};
    }
}

