/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core;

import com.github.database.rider.core.AbstractRiderTestContext;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.util.AnnotationUtils;
import com.github.database.rider.core.util.EntityManagerProvider;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.runner.Description;

public class JUnit4RiderTestContext
extends AbstractRiderTestContext {
    private final Description description;

    public JUnit4RiderTestContext(DataSetExecutor executor, Description description) {
        super(executor);
        this.description = description;
    }

    @Override
    public String getMethodName() {
        return this.description.getMethodName();
    }

    @Override
    public <T extends Annotation> T getMethodAnnotation(Class<T> clazz) {
        if (this.description.isTest()) {
            return AnnotationUtils.findAnnotation(this.description, clazz);
        }
        return null;
    }

    @Override
    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return AnnotationUtils.findAnnotation(this.description.getTestClass(), clazz);
    }

    @Override
    public void commit() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive() && EntityManagerProvider.em().getTransaction().isActive()) {
            EntityManagerProvider.em().getTransaction().commit();
        } else {
            Connection connection = this.executor.getRiderDataSource().getDBUnitConnection().getConnection();
            connection.commit();
            connection.setAutoCommit(false);
        }
    }

    @Override
    public void beginTransaction() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().getTransaction().begin();
        } else {
            Connection connection = this.executor.getRiderDataSource().getDBUnitConnection().getConnection();
            connection.setAutoCommit(false);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive() && EntityManagerProvider.em().getTransaction().isActive()) {
            EntityManagerProvider.em().getTransaction().rollback();
        } else {
            Connection connection = this.executor.getRiderDataSource().getDBUnitConnection().getConnection();
            connection.rollback();
        }
    }

    @Override
    public void clearEntityManager() {
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().clear();
        }
    }
}

