/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class ScriptableTable
implements ITable {
    private static final Logger log = Logger.getLogger(ScriptableTable.class.getName());
    private final ScriptEngineManager manager;
    private final Map<String, ScriptEngine> engines;
    private final ITable delegate;

    public ScriptableTable(ITable delegate) {
        this.delegate = delegate;
        this.engines = new HashMap<String, ScriptEngine>();
        this.manager = new ScriptEngineManager();
    }

    public ITableMetaData getTableMetaData() {
        return this.delegate.getTableMetaData();
    }

    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        ScriptEngine engine;
        Object value = this.delegate.getValue(row, column);
        if (this.rowValueContainsScriptEngine(value) && (engine = this.getScriptEngine(value.toString().trim())) != null) {
            try {
                return this.getScriptResult(value.toString(), engine);
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("Could not evaluate script expression for table '%s', column '%s'. The original value will be used.", this.getTableMetaData().getTableName(), column), e);
            }
        }
        return value;
    }

    private boolean rowValueContainsScriptEngine(Object value) {
        if (value == null || value.toString().length() == 0) {
            return false;
        }
        String rowValueLowerCase = value.toString().toLowerCase();
        return rowValueLowerCase.startsWith("js:") || rowValueLowerCase.startsWith("groovy:");
    }

    private ScriptEngine getScriptEngine(String value) {
        String engineName = value.substring(0, value.indexOf(58));
        if (this.engines.containsKey(engineName)) {
            return this.engines.get(engineName);
        }
        ScriptEngine engine = this.manager.getEngineByName(engineName);
        if (engine != null) {
            this.engines.put(engineName, engine);
        } else {
            log.warning(String.format("Could not find script engine by name '%s'", engineName));
        }
        return engine;
    }

    private Object getScriptResult(String script, ScriptEngine engine) throws ScriptException {
        String scriptToExecute = script.substring(script.indexOf(58) + 1);
        return engine.eval(scriptToExecute);
    }
}

