/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.connection;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.filter.RiderPrimaryKeyFilter;
import com.github.database.rider.core.util.DriverUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.db2.Db2MetadataHandler;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlMetadataHandler;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;

public class RiderDataSource {
    private final ConnectionHolder connectionHolder;
    private final DBUnitConfig dbUnitConfig;
    private Connection connection;
    private DatabaseConnection dbUnitConnection;
    private DBType dbType;
    private Boolean autoCommit;

    public RiderDataSource(ConnectionHolder connectionHolder) {
        this(connectionHolder, DBUnitConfig.fromGlobalConfig());
    }

    public RiderDataSource(ConnectionHolder connectionHolder, DBUnitConfig dbUnitConfig) {
        this.connectionHolder = connectionHolder;
        this.dbUnitConfig = dbUnitConfig;
        try {
            this.init();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not initialize database rider datasource.", e);
        }
    }

    public DatabaseConnection getDBUnitConnection() {
        return this.dbUnitConnection;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public void setConnectionAutoCommit(Boolean autoCommit) throws SQLException {
        this.getDBUnitConnection().getConnection().setAutoCommit(autoCommit);
    }

    public void resetConnectionAutoCommit() throws SQLException {
        this.getDBUnitConnection().getConnection().setAutoCommit(this.autoCommit);
    }

    private Connection getConnection() throws SQLException {
        if (!this.dbUnitConfig.isCacheConnection().booleanValue() || this.connection == null || this.connection.isClosed()) {
            this.connection = this.connectionHolder.getConnection();
        }
        return this.connection;
    }

    private void init() throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null) {
            this.checkDbType(conn);
            this.initDBUnitConnection(conn);
        }
    }

    private void initDBUnitConnection(Connection connection) throws SQLException {
        try {
            this.dbUnitConnection = new DatabaseConnection(connection, this.dbUnitConfig.getSchema());
            this.autoCommit = connection.getAutoCommit();
            this.configDatabaseProperties();
        }
        catch (DatabaseUnitException e) {
            throw new SQLException(e);
        }
    }

    private void configDatabaseProperties() {
        IMetadataHandler metadataHandler;
        IDataTypeFactory dataTypeFactory;
        DatabaseConfig config = this.dbUnitConnection.getConfig();
        for (Map.Entry<String, Object> p : this.dbUnitConfig.getProperties().entrySet()) {
            DatabaseConfig.ConfigProperty byShortName = DatabaseConfig.findByShortName((String)p.getKey());
            if (byShortName == null) continue;
            String[] propertyValue = p.getValue();
            if (propertyValue instanceof List) {
                propertyValue = ((List)propertyValue).toArray(new String[((List)propertyValue).size()]);
            }
            config.setProperty(byShortName.getProperty(), (Object)propertyValue);
        }
        if (!this.dbUnitConfig.getProperties().containsKey("datatypeFactory") && (dataTypeFactory = this.getDataTypeFactory(this.dbType)) != null) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
        }
        if (!this.dbUnitConfig.getProperties().containsKey("metadataHandler") && (metadataHandler = this.getMetadataHandler(this.dbType)) != null) {
            config.setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)metadataHandler);
        }
        if (this.dbUnitConfig.getDisablePKCheckFor() != null && this.dbUnitConfig.getDisablePKCheckFor().length > 0) {
            config.setProperty("http://www.dbunit.org/properties/primaryKeyFilter", (Object)new RiderPrimaryKeyFilter(Arrays.asList(this.dbUnitConfig.getDisablePKCheckFor())));
        }
    }

    private IDataTypeFactory getDataTypeFactory(DBType dbType) {
        switch (dbType) {
            case HSQLDB: {
                return new HsqldbDataTypeFactory();
            }
            case H2: {
                return new H2DataTypeFactory();
            }
            case MYSQL: {
                return new MySqlDataTypeFactory();
            }
            case POSTGRESQL: {
                return new PostgresqlDataTypeFactory();
            }
            case ORACLE: {
                return new Oracle10DataTypeFactory();
            }
            case MSSQL: {
                return new MsSqlDataTypeFactory();
            }
            case DB2: {
                return new Db2DataTypeFactory();
            }
        }
        return null;
    }

    private IMetadataHandler getMetadataHandler(DBType dbType) {
        switch (dbType) {
            case MYSQL: {
                return new MySqlMetadataHandler();
            }
            case DB2: {
                return new Db2MetadataHandler();
            }
        }
        return null;
    }

    private void checkDbType(Connection conn) throws SQLException {
        this.dbType = this.resolveDBType(DriverUtils.getDriverName(conn));
        if (this.dbUnitConfig.getExpectedDbType() != DBType.UNKNOWN && this.dbUnitConfig.getExpectedDbType() != this.dbType) {
            throw new SQLException(String.format("Expect %s database, but actually %s database.", new Object[]{this.dbUnitConfig.getExpectedDbType(), this.dbType}));
        }
    }

    private DBType resolveDBType(String driverName) {
        if (DriverUtils.isHsql(driverName)) {
            return DBType.HSQLDB;
        }
        if (DriverUtils.isH2(driverName)) {
            return DBType.H2;
        }
        if (DriverUtils.isMysql(driverName)) {
            return DBType.MYSQL;
        }
        if (DriverUtils.isPostgre(driverName)) {
            return DBType.POSTGRESQL;
        }
        if (DriverUtils.isOracle(driverName)) {
            return DBType.ORACLE;
        }
        if (DriverUtils.isDB2(driverName)) {
            return DBType.DB2;
        }
        if (DriverUtils.isMsSql(driverName)) {
            return DBType.MSSQL;
        }
        return DBType.UNKNOWN;
    }

    public static enum DBType {
        HSQLDB,
        H2,
        MYSQL,
        ORACLE,
        POSTGRESQL,
        DB2,
        MSSQL,
        UNKNOWN;

    }
}

