/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static final String DBUNIT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DBUNIT_DATE_FORMAT = "yyyy-MM-dd";

    public static String format(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(10) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            return DateUtils.formatDate(calendar);
        }
        return DateUtils.formatDateTime(calendar);
    }

    public static String format(Calendar calendar) {
        if (calendar.get(10) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            return DateUtils.formatDate(calendar);
        }
        return DateUtils.formatDateTime(calendar);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat(DBUNIT_DATE_FORMAT).format(date);
    }

    public static String formatDate(Calendar date) {
        return DateUtils.formatDate(date.getTime());
    }

    public static String formatDateTime(Date date) {
        return new SimpleDateFormat(DBUNIT_DATE_TIME_FORMAT).format(date);
    }

    public static String formatDateTime(Calendar date) {
        return DateUtils.formatDateTime(date.getTime());
    }
}

