/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONWriter
implements IDataSetConsumer {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String DOUBLE_SPACES = "  ";
    private static final String FOUR_SPACES = "    ";
    private static final Logger logger = LoggerFactory.getLogger(JSONWriter.class);
    private IDataSet dataSet;
    private OutputStreamWriter out;
    private ITableMetaData metaData;
    private int tableCount;
    private int rowCount;

    public JSONWriter(OutputStream outputStream, IDataSet dataSet) {
        this.out = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.dataSet = dataSet;
    }

    public void startDataSet() throws DataSetException {
        try {
            this.tableCount = 0;
            this.out.write("{" + NEW_LINE);
        }
        catch (IOException e) {
            logger.warn("Could not start dataset.", (Throwable)e);
        }
    }

    public void endDataSet() throws DataSetException {
        try {
            this.out.write("}");
            this.out.flush();
        }
        catch (IOException e) {
            logger.warn("Could not end dataset.", (Throwable)e);
        }
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        this.metaData = metaData;
        this.rowCount = 0;
        try {
            this.out.write("  \"" + metaData.getTableName() + "\": [" + NEW_LINE);
        }
        catch (IOException e) {
            logger.warn("Could not start table.", (Throwable)e);
        }
    }

    public void endTable() throws DataSetException {
        try {
            ++this.tableCount;
            if (this.dataSet.getTableNames().length == this.tableCount) {
                this.out.write("  ]" + NEW_LINE);
            } else {
                this.out.write("  ]," + NEW_LINE);
            }
        }
        catch (IOException e) {
            logger.warn("Could end table.", (Throwable)e);
        }
    }

    public void row(Object[] values) throws DataSetException {
        ++this.rowCount;
        try {
            this.out.write("    {" + NEW_LINE);
            String sb = this.createSetFromValues(values);
            this.out.write(sb);
            if (this.dataSet.getTable(this.metaData.getTableName()).getRowCount() != this.rowCount) {
                this.out.write("    }," + NEW_LINE);
            } else {
                this.out.write("    }" + NEW_LINE);
            }
        }
        catch (Exception e) {
            logger.warn("Could not write row.", (Throwable)e);
        }
    }

    private String createSetFromValues(Object[] values) throws DataSetException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            Object currentValue = values[i];
            if (currentValue == null) continue;
            Column currentColumn = this.metaData.getColumns()[i];
            sb.append("      \"").append(this.metaData.getColumns()[i].getColumnName()).append("\": ");
            boolean isNumber = currentColumn.getDataType().isNumber();
            if (!isNumber) {
                sb.append('\"');
            }
            if (values[i] instanceof byte[]) {
                sb.append(DatatypeConverter.printBase64Binary((byte[])((byte[])values[i])).replace(NEW_LINE, "\\n"));
            } else {
                sb.append(currentValue.toString().replace("\\", "\\\\").replace("\"", "\\\"").replace(NEW_LINE, "\\n"));
            }
            if (!isNumber) {
                sb.append('\"');
            }
            if (i != values.length - 1) {
                sb.append(',');
            }
            sb.append(NEW_LINE);
        }
        return this.replaceExtraCommaInTheEnd(sb);
    }

    private String replaceExtraCommaInTheEnd(StringBuilder sb) {
        int indexOfPenultimateSymbol = sb.length() - 2;
        if (sb.length() > 1 && sb.charAt(indexOfPenultimateSymbol) == ',') {
            sb.deleteCharAt(indexOfPenultimateSymbol);
        }
        return sb.toString();
    }

    public synchronized void write() throws DataSetException {
        DataSetProducerAdapter provider = new DataSetProducerAdapter(this.dataSet);
        provider.setConsumer((IDataSetConsumer)this);
        provider.produce();
    }
}

