/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowFilterTable;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsFilterTable
implements ITable {
    private final ITable originalTable;
    private final List<Integer> filteredRowIndexes;
    private final Logger logger = LoggerFactory.getLogger(RowFilterTable.class);

    public ContainsFilterTable(ITable actualTable, ITable expectedTable, List<String> ignoredCols) throws DataSetException {
        if (expectedTable == null || actualTable == null) {
            throw new IllegalArgumentException("Constructor cannot receive null arguments");
        }
        this.originalTable = actualTable;
        this.filteredRowIndexes = this.setRows(expectedTable, this.toUpper(ignoredCols));
    }

    private List<String> toUpper(List<String> ignoredCols) {
        ArrayList<String> upperCaseColumns = new ArrayList<String>();
        for (String ignoredCol : ignoredCols) {
            upperCaseColumns.add(ignoredCol.toUpperCase());
        }
        return upperCaseColumns;
    }

    private List<Integer> setRows(ITable expectedTable, List<String> ignoredCols) throws DataSetException {
        ITableMetaData tableMetadata = this.originalTable.getTableMetaData();
        this.logger.debug("Setting rows for table {}", (Object)tableMetadata.getTableName());
        int fullSize = expectedTable.getRowCount();
        ArrayList<String> columns = new ArrayList<String>();
        if (fullSize > 0) {
            for (Column column : expectedTable.getTableMetaData().getColumns()) {
                columns.add(column.getColumnName());
            }
        }
        ArrayList<Integer> filteredRowIndexes = new ArrayList<Integer>();
        for (int row = 0; row < fullSize; ++row) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String column : columns) {
                values.add(expectedTable.getValue(row, column));
            }
            Integer actualRowIndex = this.tableContains(columns, values, filteredRowIndexes, ignoredCols);
            if (actualRowIndex == null) {
                this.logger.debug("Discarding row {}", (Object)row);
                continue;
            }
            this.logger.debug("Adding row {}", (Object)row);
            filteredRowIndexes.add(actualRowIndex);
        }
        return filteredRowIndexes;
    }

    private Integer tableContains(List<String> columns, List<Object> values, List<Integer> filteredRowIndexes, List<String> ignoredCols) throws DataSetException {
        int fullSize = this.originalTable.getRowCount();
        for (int row = 0; row < fullSize; ++row) {
            boolean match = true;
            for (int column = 0; column < columns.size(); ++column) {
                if (ignoredCols != null && ignoredCols.contains(columns.get(column).toUpperCase())) continue;
                if (values.get(column) != null && values.get(column).toString().startsWith("regex:")) {
                    if (this.regexMatches(values.get(column).toString(), this.originalTable.getValue(row, columns.get(column)).toString())) continue;
                    match = false;
                    break;
                }
                int columnIndex = this.originalTable.getTableMetaData().getColumnIndex(columns.get(column));
                DataType dataType = this.originalTable.getTableMetaData().getColumns()[columnIndex].getDataType();
                if (dataType.compare(values.get(column), this.originalTable.getValue(row, columns.get(column))) == 0) continue;
                match = false;
                break;
            }
            if (!match || filteredRowIndexes.contains(row)) continue;
            return row;
        }
        return null;
    }

    private boolean regexMatches(String expectedValue, String actualValue) {
        Pattern pattern = Pattern.compile(expectedValue.substring(expectedValue.indexOf(58) + 1).trim());
        return pattern.matcher(actualValue).matches();
    }

    public ITableMetaData getTableMetaData() {
        this.logger.debug("getTableMetaData() - start");
        return this.originalTable.getTableMetaData();
    }

    public int getRowCount() {
        this.logger.debug("getRowCount() - start");
        return this.filteredRowIndexes.size();
    }

    public Object getValue(int row, String column) throws DataSetException {
        int max;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        if (row < (max = this.filteredRowIndexes.size())) {
            int realRow = this.filteredRowIndexes.get(row);
            return this.originalTable.getValue(realRow, column);
        }
        throw new RowOutOfBoundsException("tried to access row " + row + " but rowCount is " + max);
    }
}

