/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.operators;

import com.github.davidmoten.rx.subjects.SingleSubscribeSubject;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.observers.Subscribers;

public final class OperatorFromTransformer<R, T>
implements Observable.Operator<R, T> {
    private final Func1<Observable<T>, Observable<R>> operation;

    public static <R, T> Observable.Operator<R, T> toOperator(Func1<Observable<T>, Observable<R>> operation) {
        return new OperatorFromTransformer<R, T>(operation);
    }

    public OperatorFromTransformer(Func1<Observable<T>, Observable<R>> operation) {
        this.operation = operation;
    }

    public Subscriber<? super T> call(Subscriber<? super R> subscriber) {
        SingleSubscribeSubject subject = SingleSubscribeSubject.create();
        Subscriber result = Subscribers.from(subject);
        subscriber.add((Subscription)result);
        ((Observable)this.operation.call(subject)).unsafeSubscribe(subscriber);
        return result;
    }
}

