/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class SecurityCodeValidation
implements Message {
    private final int codeNumber;
    private final int authorityLevel;

    @Override
    public int getMessageType() {
        return 39;
    }

    public static SecurityCodeValidationBuilder builder() {
        return new SecurityCodeValidationBuilder();
    }

    public int getCodeNumber() {
        return this.codeNumber;
    }

    public int getAuthorityLevel() {
        return this.authorityLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityCodeValidation)) {
            return false;
        }
        SecurityCodeValidation other = (SecurityCodeValidation)o;
        if (this.getCodeNumber() != other.getCodeNumber()) {
            return false;
        }
        return this.getAuthorityLevel() == other.getAuthorityLevel();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCodeNumber();
        result = result * 59 + this.getAuthorityLevel();
        return result;
    }

    public String toString() {
        return "SecurityCodeValidation(codeNumber=" + this.getCodeNumber() + ", authorityLevel=" + this.getAuthorityLevel() + ")";
    }

    private SecurityCodeValidation(int codeNumber, int authorityLevel) {
        this.codeNumber = codeNumber;
        this.authorityLevel = authorityLevel;
    }

    public static class SecurityCodeValidationBuilder {
        private int codeNumber;
        private int authorityLevel;

        SecurityCodeValidationBuilder() {
        }

        public SecurityCodeValidationBuilder codeNumber(int codeNumber) {
            this.codeNumber = codeNumber;
            return this;
        }

        public SecurityCodeValidationBuilder authorityLevel(int authorityLevel) {
            this.authorityLevel = authorityLevel;
            return this;
        }

        public SecurityCodeValidation build() {
            return new SecurityCodeValidation(this.codeNumber, this.authorityLevel);
        }

        public String toString() {
            return "SecurityCodeValidation.SecurityCodeValidationBuilder(codeNumber=" + this.codeNumber + ", authorityLevel=" + this.authorityLevel + ")";
        }
    }
}

