/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.statuses;

import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;

public class AreaStatus
extends Status {
    private final int mode;
    private final int alarms;
    private final int entryTimer;
    private final int exitTimer;

    private AreaStatus(int number, int mode, int alarms, int entryTimer, int exitTimer) {
        super(number);
        this.mode = mode;
        this.alarms = alarms;
        this.entryTimer = entryTimer;
        this.exitTimer = exitTimer;
    }

    public static AreaStatusBuilder builder() {
        return new AreaStatusBuilder();
    }

    public int getMode() {
        return this.mode;
    }

    public int getAlarms() {
        return this.alarms;
    }

    public int getEntryTimer() {
        return this.entryTimer;
    }

    public int getExitTimer() {
        return this.exitTimer;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AreaStatus)) {
            return false;
        }
        AreaStatus other = (AreaStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getAlarms() != other.getAlarms()) {
            return false;
        }
        if (this.getEntryTimer() != other.getEntryTimer()) {
            return false;
        }
        return this.getExitTimer() == other.getExitTimer();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AreaStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMode();
        result = result * 59 + this.getAlarms();
        result = result * 59 + this.getEntryTimer();
        result = result * 59 + this.getExitTimer();
        return result;
    }

    @Override
    public String toString() {
        return "AreaStatus(super=" + super.toString() + ", mode=" + this.getMode() + ", alarms=" + this.getAlarms() + ", entryTimer=" + this.getEntryTimer() + ", exitTimer=" + this.getExitTimer() + ")";
    }

    public static class AreaStatusBuilder {
        private int number;
        private int mode;
        private int alarms;
        private int entryTimer;
        private int exitTimer;

        AreaStatusBuilder() {
        }

        public AreaStatusBuilder number(int number) {
            this.number = number;
            return this;
        }

        public AreaStatusBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public AreaStatusBuilder alarms(int alarms) {
            this.alarms = alarms;
            return this;
        }

        public AreaStatusBuilder entryTimer(int entryTimer) {
            this.entryTimer = entryTimer;
            return this;
        }

        public AreaStatusBuilder exitTimer(int exitTimer) {
            this.exitTimer = exitTimer;
            return this;
        }

        public AreaStatus build() {
            return new AreaStatus(this.number, this.mode, this.alarms, this.entryTimer, this.exitTimer);
        }

        public String toString() {
            return "AreaStatus.AreaStatusBuilder(number=" + this.number + ", mode=" + this.mode + ", alarms=" + this.alarms + ", entryTimer=" + this.entryTimer + ", exitTimer=" + this.exitTimer + ")";
        }
    }
}

