/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.systemevents;

import com.digitaldan.jomnilinkII.MessageTypes.systemevents.AcPowerOffEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.AcPowerRestoredEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.AllOnOffEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.BatteryLowEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.BatteryOkEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.ButtonEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera1TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera2TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera3TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera4TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera5TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.Camera6TriggerEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.CentralightSwitchEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.ComposeCodeReceivedEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.DCMOkEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.DCMTroubleEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.EnergyCostCriticalEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.EnergyCostHighEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.EnergyCostLowEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.EnergyCostMidEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.PhoneLineDeadEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.PhoneLineOffHookEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.PhoneLineOnHookEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.PhoneLineRingEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.ProLinkMessageEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.SwitchPressEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.UPBLinkEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.X10CodeReceivedEvent;

public enum SystemEventType {
    BUTTON(0, 65280, ButtonEvent.class),
    PROLINK_MESSAGE(256, 65408, ProLinkMessageEvent.class),
    CENTRALITE_SWITCH(384, 65408, CentralightSwitchEvent.class),
    COMPOSE_CODE_RECEIVED(28672, 61440, ComposeCodeReceivedEvent.class),
    X10_CODE_RECEIVED(3072, 64512, X10CodeReceivedEvent.class),
    UPB_LINK(64512, 64512, UPBLinkEvent.class),
    ALC_UPB_RADIORA_STARLITE_SWITCH_PRESS(61440, 61440, SwitchPressEvent.class),
    ALL_ON_OFF(992, 131008, AllOnOffEvent.class),
    PHONE_LINE_DEAD(768, 65535, PhoneLineDeadEvent.class),
    PHONE_LINE_RING(769, 65535, PhoneLineRingEvent.class),
    PHONE_LINE_OFF_HOOK(770, 65535, PhoneLineOffHookEvent.class),
    PHONE_LINE_ON_HOOK(771, 65535, PhoneLineOnHookEvent.class),
    AC_POWER_OFF(772, 65535, AcPowerOffEvent.class),
    AC_POWER_RESTORED(773, 65535, AcPowerRestoredEvent.class),
    BATTERY_LOW(774, 65535, BatteryLowEvent.class),
    BATTERY_OK(775, 65535, BatteryOkEvent.class),
    DCM_TROUBLE(776, 65535, DCMTroubleEvent.class),
    DCM_OK(777, 65535, DCMOkEvent.class),
    ENERGY_COST_LOW(778, 65535, EnergyCostLowEvent.class),
    ENERGY_COST_MID(779, 65535, EnergyCostMidEvent.class),
    ENERGY_COST_HIGH(780, 65535, EnergyCostHighEvent.class),
    ENERGY_COST_CRITICAL(781, 65535, EnergyCostCriticalEvent.class),
    CAMERA_1_TRIGGER(782, 65535, Camera1TriggerEvent.class),
    CAMERA_2_TRIGGER(783, 65535, Camera2TriggerEvent.class),
    CAMERA_3_TRIGGER(784, 65535, Camera3TriggerEvent.class),
    CAMERA_4_TRIGGER(785, 65535, Camera4TriggerEvent.class),
    CAMERA_5_TRIGGER(786, 65535, Camera5TriggerEvent.class),
    CAMERA_6_TRIGGER(787, 65535, Camera6TriggerEvent.class);

    private final int bitTemplate;
    private final int bitMask;
    private final Class<?> systemEventClass;

    private SystemEventType(int bitTemplate, int bitMask, Class<?> systemEventClass) {
        this.bitTemplate = bitTemplate;
        this.bitMask = bitMask;
        this.systemEventClass = systemEventClass;
    }

    public Class<?> getSystemEventClass() {
        return this.systemEventClass;
    }

    public static SystemEventType fromInt(int number) {
        for (SystemEventType st : SystemEventType.values()) {
            if ((number & st.bitMask) != st.bitTemplate) continue;
            return st;
        }
        return null;
    }
}

