/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.dozer.MapIdField;

public class MappedFieldsTracker {
    private final Map<Object, Map<Integer, MapIdField>> mappedFields = new IdentityHashMap<Object, Map<Integer, MapIdField>>();

    public void put(Object src, Object dest, String mapId) {
        MapIdField destMapIdField;
        int destId = System.identityHashCode(dest);
        Map<Integer, MapIdField> mappedTo = this.mappedFields.get(src);
        if (mappedTo == null) {
            mappedTo = new HashMap<Integer, MapIdField>();
            this.mappedFields.put(src, mappedTo);
        }
        if ((destMapIdField = mappedTo.get(destId)) == null) {
            destMapIdField = new MapIdField();
            mappedTo.put(destId, destMapIdField);
        }
        if (!destMapIdField.containsMapId(mapId)) {
            destMapIdField.put(mapId, dest);
        }
    }

    public void put(Object src, Object dest) {
        this.put(src, dest, null);
    }

    public Object getMappedValue(Object src, Class<?> destType, String mapId) {
        Map<Integer, MapIdField> alreadyMappedFields = this.mappedFields.get(src);
        if (alreadyMappedFields != null) {
            for (MapIdField alreadyMappedField : alreadyMappedFields.values()) {
                Object mappedValue = alreadyMappedField.get(mapId);
                if (mappedValue == null || !destType.isAssignableFrom(mappedValue.getClass())) continue;
                return mappedValue;
            }
        }
        return null;
    }

    public Object getMappedValue(Object src, Class<?> destType) {
        return this.getMappedValue(src, destType, null);
    }
}

