/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.dozer.config.BeanContainer;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.DozerConstants;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalSettings {
    private final Logger log = LoggerFactory.getLogger(GlobalSettings.class);
    private static final GlobalSettings instance = new GlobalSettings();
    private String loadedByFileName;
    private boolean statisticsEnabled = false;
    private int converterByDestTypeCacheMaxSize = 10000;
    private int superTypesCacheMaxSize = 10000;
    private boolean autoregisterJMXBeans = true;
    private boolean elEnabled = false;
    private String classLoaderBeanName = DozerConstants.DEFAULT_CLASS_LOADER_BEAN;
    private String proxyResolverBeanName = DozerConstants.DEFAULT_PROXY_RESOLVER_BEAN;

    public static GlobalSettings getInstance() {
        return instance;
    }

    static GlobalSettings createNew() {
        return new GlobalSettings();
    }

    private GlobalSettings() {
        this.loadGlobalSettings();
    }

    protected String getLoadedByFileName() {
        return this.loadedByFileName;
    }

    public boolean isAutoregisterJMXBeans() {
        return this.autoregisterJMXBeans;
    }

    public int getConverterByDestTypeCacheMaxSize() {
        return this.converterByDestTypeCacheMaxSize;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public int getSuperTypesCacheMaxSize() {
        return this.superTypesCacheMaxSize;
    }

    public String getClassLoaderName() {
        return this.classLoaderBeanName;
    }

    public String getProxyResolverName() {
        return this.proxyResolverBeanName;
    }

    public boolean isElEnabled() {
        return this.elEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadGlobalSettings() {
        String propFileName = System.getProperty("dozer.configuration");
        if (MappingUtils.isBlankOrNull(propFileName)) {
            propFileName = "dozer.properties";
        }
        this.log.info("Trying to find Dozer configuration file: {}", (Object)propFileName);
        DozerClassLoader classLoader = BeanContainer.getInstance().getClassLoader();
        URL url = classLoader.loadResource(propFileName);
        if (url == null) {
            this.log.warn("Dozer configuration file not found: {}.  Using defaults for all Dozer global properties.", (Object)propFileName);
            return;
        }
        this.log.info("Using URL [{}] for Dozer global property configuration", (Object)url);
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            this.log.info("Reading Dozer properties from URL [{}]", (Object)url);
            inputStream = url.openStream();
            props.load(inputStream);
        }
        catch (IOException e) {
            MappingUtils.throwMappingException("Problem loading Dozer properties from URL [" + propFileName + "]", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.populateSettings(props);
        this.loadedByFileName = propFileName;
        this.log.debug("Finished configuring Dozer global properties");
    }

    private void populateSettings(Properties props) {
        String propValue = props.getProperty("dozer.statistics.enabled");
        if (propValue != null) {
            this.statisticsEnabled = Boolean.valueOf(propValue);
        }
        if ((propValue = props.getProperty("dozer.cache.converter.by.dest.type.maxsize")) != null) {
            this.converterByDestTypeCacheMaxSize = Integer.parseInt(propValue);
        }
        if ((propValue = props.getProperty("dozer.cache.super.type.maxsize")) != null) {
            this.superTypesCacheMaxSize = Integer.parseInt(propValue);
        }
        if ((propValue = props.getProperty("dozer.autoregister.jmx.beans")) != null) {
            this.autoregisterJMXBeans = Boolean.valueOf(propValue);
        }
        if ((propValue = props.getProperty("org.dozer.util.DozerClassLoader")) != null) {
            this.classLoaderBeanName = propValue;
        }
        if ((propValue = props.getProperty("org.dozer.util.DozerProxyResolver")) != null) {
            this.proxyResolverBeanName = propValue;
        }
        if ((propValue = props.getProperty("dozer.el.enabled")) != null) {
            this.elEnabled = Boolean.valueOf(propValue);
        }
    }
}

