/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap;

import com.github.dozermapper.core.Mapping;
import com.github.dozermapper.core.OptionValue;
import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.ClassMappings;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.DozerClass;
import com.github.dozermapper.core.classmap.generator.BeanMappingGenerator;
import com.github.dozermapper.core.classmap.generator.ClassLevelFieldMappingGenerator;
import com.github.dozermapper.core.classmap.generator.GeneratorUtils;
import com.github.dozermapper.core.classmap.generator.MappingType;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.DozerField;
import com.github.dozermapper.core.fieldmap.GenericFieldMap;
import com.github.dozermapper.core.fieldmap.MapFieldMap;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.MappingOptions;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.ReflectionUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassMapBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClassMapBuilder.class);
    private final List<ClassMappingGenerator> buildTimeGenerators = new ArrayList<ClassMappingGenerator>();
    private final List<ClassMappingGenerator> runTimeGenerators = new ArrayList<ClassMappingGenerator>();
    private final BeanContainer beanContainer;

    public ClassMapBuilder(BeanContainer beanContainer, DestBeanCreator destBeanCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.buildTimeGenerators.add(new ClassLevelFieldMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.buildTimeGenerators.add(new AnnotationPropertiesGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.buildTimeGenerators.add(new AnnotationFieldsGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.buildTimeGenerators.add(new AnnotationClassesGenerator());
        this.buildTimeGenerators.add(new MapMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.buildTimeGenerators.add(beanMappingGenerator);
        this.buildTimeGenerators.add(new CollectionMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.runTimeGenerators.add(new ClassLevelFieldMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.runTimeGenerators.add(new AnnotationPropertiesGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.runTimeGenerators.add(new AnnotationFieldsGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.runTimeGenerators.add(new AnnotationClassesGenerator());
        this.runTimeGenerators.add(new MapMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.runTimeGenerators.add(beanMappingGenerator);
    }

    public ClassMap createDefaultClassMap(Configuration globalConfiguration, Class<?> srcClass, Class<?> destClass) {
        return this.createDefaultClassMap(globalConfiguration, srcClass, destClass, true);
    }

    public ClassMap createDefaultClassMap(Configuration globalConfiguration, Class<?> srcClass, Class<?> destClass, Boolean shouldGenerateMapping) {
        DozerClass srcDozerClass = new DozerClass(srcClass.getName(), srcClass, globalConfiguration.getBeanFactory(), null, null, null, null, globalConfiguration.getMapNull(), globalConfiguration.getMapEmptyString(), false, null, this.beanContainer);
        DozerClass destDozerClass = new DozerClass(destClass.getName(), destClass, globalConfiguration.getBeanFactory(), null, null, null, null, globalConfiguration.getMapNull(), globalConfiguration.getMapEmptyString(), false, null, this.beanContainer);
        ClassMap classMap = new ClassMap(globalConfiguration);
        classMap.setSrcClass(srcDozerClass);
        classMap.setDestClass(destDozerClass);
        if (shouldGenerateMapping.booleanValue()) {
            this.generateMapping(classMap, globalConfiguration, this.buildTimeGenerators);
        }
        return classMap;
    }

    public void addDefaultFieldMappings(ClassMappings classMappings, Configuration globalConfiguration) {
        Set<Map.Entry<String, ClassMap>> entries = classMappings.getAll().entrySet();
        for (Map.Entry<String, ClassMap> entry : entries) {
            ClassMap classMap = entry.getValue();
            this.generateMapping(classMap, globalConfiguration, this.runTimeGenerators);
        }
    }

    private void generateMapping(ClassMap classMap, Configuration configuration, List<ClassMappingGenerator> mappingGenerators) {
        if (!classMap.isWildcard()) {
            return;
        }
        for (ClassMappingGenerator generator : mappingGenerators) {
            if (!generator.accepts(classMap) || !generator.apply(classMap, configuration)) continue;
            return;
        }
    }

    private static boolean requireMapping(Mapping mapping, Class<?> clazz, String fieldName, String pairName) {
        try {
            return !mapping.optional() || mapping.optional() && clazz.getDeclaredField(pairName.isEmpty() ? fieldName : pairName) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static class AnnotationFieldsGenerator
    implements ClassMappingGenerator {
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public AnnotationFieldsGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        @Override
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            Class<?> srcType = classMap.getSrcClassToMap();
            do {
                for (Field field : srcType.getDeclaredFields()) {
                    Mapping mapping = field.getAnnotation(Mapping.class);
                    String fieldName = field.getName();
                    if (mapping == null) continue;
                    String pairName = mapping.value().trim();
                    if (!ClassMapBuilder.requireMapping(mapping, classMap.getDestClassToMap(), fieldName, pairName)) continue;
                    GeneratorUtils.addGenericMapping(MappingType.FIELD_TO_FIELD, classMap, configuration, fieldName, pairName.isEmpty() ? fieldName : pairName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                }
            } while ((srcType = srcType.getSuperclass()) != null);
            Class<?> destType = classMap.getDestClassToMap();
            do {
                for (Field field : destType.getDeclaredFields()) {
                    Mapping mapping = field.getAnnotation(Mapping.class);
                    String fieldName = field.getName();
                    if (mapping == null) continue;
                    String pairName = mapping.value().trim();
                    if (!ClassMapBuilder.requireMapping(mapping, classMap.getSrcClassToMap(), fieldName, pairName)) continue;
                    GeneratorUtils.addGenericMapping(MappingType.FIELD_TO_FIELD, classMap, configuration, pairName.isEmpty() ? fieldName : pairName, fieldName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                }
            } while ((destType = destType.getSuperclass()) != null);
            return false;
        }
    }

    public static class AnnotationPropertiesGenerator
    implements ClassMappingGenerator {
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public AnnotationPropertiesGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        @Override
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] destProperties;
            PropertyDescriptor[] srcProperties;
            Class<?> srcType = classMap.getSrcClassToMap();
            for (PropertyDescriptor property : srcProperties = ReflectionUtils.getPropertyDescriptors(srcType)) {
                Mapping mapping;
                Method readMethod = property.getReadMethod();
                if (readMethod == null || (mapping = readMethod.getAnnotation(Mapping.class)) == null) continue;
                String propertyName = property.getName();
                String pairName = mapping.value().trim();
                if (!ClassMapBuilder.requireMapping(mapping, classMap.getDestClassToMap(), propertyName, pairName)) continue;
                GeneratorUtils.addGenericMapping(MappingType.GETTER_TO_SETTER, classMap, configuration, propertyName, pairName.isEmpty() ? propertyName : pairName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
            }
            Class<?> destType = classMap.getDestClassToMap();
            for (PropertyDescriptor property : destProperties = ReflectionUtils.getPropertyDescriptors(destType)) {
                Mapping mapping;
                Method readMethod = property.getReadMethod();
                if (readMethod == null || (mapping = readMethod.getAnnotation(Mapping.class)) == null) continue;
                String propertyName = property.getName();
                String pairName = mapping.value().trim();
                if (!ClassMapBuilder.requireMapping(mapping, classMap.getSrcClassToMap(), propertyName, pairName)) continue;
                GeneratorUtils.addGenericMapping(MappingType.GETTER_TO_SETTER, classMap, configuration, pairName.isEmpty() ? propertyName : pairName, propertyName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
            }
            return false;
        }
    }

    public static class AnnotationClassesGenerator
    implements ClassMappingGenerator {
        @Override
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            Class<?> srcType = classMap.getSrcClassToMap();
            Class<?> dstType = classMap.getDestClassToMap();
            AnnotationClassesGenerator.applyClassMappingOptions(classMap, AnnotationClassesGenerator.reconcileOptions(srcType, dstType));
            return false;
        }

        private static MappingOptions reconcileOptions(final Class<?> srcClass, final Class<?> dstClass) {
            final MappingOptions srcOpts = srcClass.getAnnotation(MappingOptions.class);
            final MappingOptions dstOpts = dstClass.getAnnotation(MappingOptions.class);
            if (srcOpts == null) {
                return dstOpts;
            }
            if (dstOpts == null) {
                return srcOpts;
            }
            return new MappingOptions(){

                private OptionValue reconcile(String fieldName, OptionValue srcOption, OptionValue dstOption) {
                    if (srcOption == dstOption) {
                        return srcOption;
                    }
                    if (srcOption == OptionValue.INHERITED) {
                        return dstOption;
                    }
                    if (dstOption == OptionValue.INHERITED) {
                        return srcOption;
                    }
                    log.info("Conflicting class annotations for " + fieldName + " on src class " + srcClass.getCanonicalName() + " and dst class " + dstClass.getCanonicalName());
                    return dstOption;
                }

                private String reconcile(String fieldName, String srcOption, String dstOption) {
                    if (srcOption.equals(dstOption)) {
                        return srcOption;
                    }
                    if (srcOption.isEmpty()) {
                        return dstOption;
                    }
                    if (dstOption.isEmpty()) {
                        return srcOption;
                    }
                    log.info("Conflicting class annotations for " + fieldName + " on src class " + srcClass.getCanonicalName() + " and dst class " + dstClass.getCanonicalName());
                    return dstOption;
                }

                @Override
                public OptionValue wildCard() {
                    return this.reconcile("wildCard", srcOpts.wildCard(), dstOpts.wildCard());
                }

                @Override
                public OptionValue wildCardCaseInsensitive() {
                    return this.reconcile("wildCardCaseInsensitive", srcOpts.wildCardCaseInsensitive(), dstOpts.wildCardCaseInsensitive());
                }

                @Override
                public OptionValue stopOnErrors() {
                    return this.reconcile("stopOnErrors", srcOpts.stopOnErrors(), dstOpts.stopOnErrors());
                }

                @Override
                public OptionValue mapNull() {
                    return this.reconcile("mapNull", srcOpts.mapNull(), dstOpts.mapNull());
                }

                @Override
                public OptionValue mapEmptyString() {
                    return this.reconcile("mapEmptyString", srcOpts.mapEmptyString(), dstOpts.mapEmptyString());
                }

                @Override
                public String dateFormat() {
                    return this.reconcile("dateFormat", srcOpts.dateFormat(), dstOpts.dateFormat());
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return MappingOptions.class;
                }
            };
        }

        private static void applyClassMappingOptions(ClassMap classMap, MappingOptions mappingOptions) {
            if (mappingOptions != null) {
                classMap.setWildcard(mappingOptions.wildCard().toBoolean());
                classMap.setWildcardCaseInsensitive(mappingOptions.wildCardCaseInsensitive().toBoolean());
                classMap.setStopOnErrors(mappingOptions.stopOnErrors().toBoolean());
                Boolean mapNull = mappingOptions.mapNull().toBoolean();
                classMap.getDestClass().setMapNull(mapNull);
                classMap.getSrcClass().setMapNull(mapNull);
                Boolean mapEmptyString = mappingOptions.mapEmptyString().toBoolean();
                classMap.getDestClass().setMapEmptyString(mapEmptyString);
                classMap.getSrcClass().setMapEmptyString(mapEmptyString);
                String dateFormat = mappingOptions.dateFormat();
                if (!dateFormat.isEmpty()) {
                    classMap.setDateFormat(dateFormat);
                }
            }
        }
    }

    public static class CollectionMappingGenerator
    implements ClassMappingGenerator {
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public CollectionMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        @Override
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedCollection(srcClass) && MappingUtils.isSupportedCollection(destClass);
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            GenericFieldMap fieldMap = new GenericFieldMap(classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
            DozerField selfReference = new DozerField("this", null);
            fieldMap.setSrcField(selfReference);
            fieldMap.setDestField(selfReference);
            classMap.addFieldMapping(fieldMap);
            return true;
        }
    }

    public static class MapMappingGenerator
    implements ClassMappingGenerator {
        private final BeanContainer beanContainer;
        private final DestBeanCreator destBeanCreator;
        private final PropertyDescriptorFactory propertyDescriptorFactory;

        public MapMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
            this.beanContainer = beanContainer;
            this.destBeanCreator = destBeanCreator;
            this.propertyDescriptorFactory = propertyDescriptorFactory;
        }

        @Override
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null || MappingUtils.isSupportedMap(destClass) || classMap.getDestClassMapGetMethod() != null;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] properties;
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            boolean destinationIsMap = false;
            if (MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null) {
                properties = ReflectionUtils.getPropertyDescriptors(destClass);
            } else {
                properties = ReflectionUtils.getPropertyDescriptors(srcClass);
                destinationIsMap = true;
            }
            for (PropertyDescriptor property : properties) {
                String fieldName = property.getName();
                if (GeneratorUtils.shouldIgnoreField(fieldName, srcClass, destClass, this.beanContainer) || destinationIsMap && classMap.getFieldMapUsingSrc(fieldName) != null || !destinationIsMap && classMap.getFieldMapUsingDest(fieldName, true) != null) continue;
                MapFieldMap fieldMap = new MapFieldMap(classMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                DozerField srcField = new DozerField(MappingUtils.isSupportedMap(srcClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((CharSequence)classMap.getSrcClassMapGetMethod()) || StringUtils.isNotEmpty((CharSequence)classMap.getSrcClassMapSetMethod())) {
                    srcField.setMapGetMethod(classMap.getSrcClassMapGetMethod());
                    srcField.setMapSetMethod(classMap.getSrcClassMapSetMethod());
                    srcField.setName("this");
                }
                DozerField destField = new DozerField(MappingUtils.isSupportedMap(destClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((CharSequence)classMap.getDestClassMapGetMethod()) || StringUtils.isNotEmpty((CharSequence)classMap.getDestClassMapSetMethod())) {
                    destField.setMapGetMethod(classMap.getDestClassMapGetMethod());
                    destField.setMapSetMethod(classMap.getDestClassMapSetMethod());
                    destField.setName("this");
                }
                fieldMap.setSrcField(srcField);
                fieldMap.setDestField(destField);
                classMap.addFieldMapping(fieldMap);
            }
            return true;
        }
    }

    public static interface ClassMappingGenerator {
        public boolean accepts(ClassMap var1);

        public boolean apply(ClassMap var1, Configuration var2);
    }
}

