/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap;

import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.util.MappingUtils;
import org.apache.commons.lang3.StringUtils;

public final class ClassMapKeyFactory {
    private final BeanContainer beanContainer;

    public ClassMapKeyFactory(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    public String createKey(Class<?> srcClass, Class<?> destClass) {
        return this.createKey(srcClass, destClass, null);
    }

    public String createKey(Class<?> srcClass, Class<?> destClass, String mapId) {
        Class<?> srcRealClass = MappingUtils.getRealClass(srcClass, this.beanContainer);
        Class<?> destRealClass = MappingUtils.getRealClass(destClass, this.beanContainer);
        StringBuilder result = new StringBuilder(140);
        result.append("SRC-CLASS->");
        result.append(srcRealClass.getName());
        result.append(" DST-CLASS->");
        result.append(destRealClass.getName());
        if (StringUtils.isNotEmpty((CharSequence)mapId)) {
            result.append(" MAP-ID->");
            result.append(mapId);
        }
        return result.toString();
    }
}

