/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader.api;

import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.classmap.MappingDirection;
import com.github.dozermapper.core.classmap.RelationshipType;
import com.github.dozermapper.core.loader.DozerBuilder;
import com.github.dozermapper.core.loader.api.FieldsMappingOption;
import org.apache.commons.lang3.StringUtils;

public final class FieldsMappingOptions {
    private FieldsMappingOptions() {
    }

    public static FieldsMappingOption copyByReference() {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.copyByReference(true);
            }
        };
    }

    public static FieldsMappingOption customConverter(Class<? extends CustomConverter> type) {
        return FieldsMappingOptions.customConverter(type, null);
    }

    public static FieldsMappingOption customConverter(Class<? extends CustomConverter> type, String parameter) {
        return FieldsMappingOptions.customConverter(type.getName(), parameter);
    }

    public static FieldsMappingOption customConverter(String type) {
        return FieldsMappingOptions.customConverter(type, null);
    }

    public static FieldsMappingOption customConverter(final String type, final String parameter) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.customConverter(type);
                fieldMappingBuilder.customConverterParam(parameter);
            }
        };
    }

    public static FieldsMappingOption customConverterId(final String id) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.customConverterId(id);
            }
        };
    }

    public static FieldsMappingOption customConverterId(final String id, final String parameter) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.customConverterId(id);
                fieldMappingBuilder.customConverterParam(parameter);
            }
        };
    }

    public static FieldsMappingOption useMapId(final String mapId) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.mapId(mapId);
            }
        };
    }

    public static FieldsMappingOption oneWay() {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.type(MappingDirection.ONE_WAY);
            }
        };
    }

    public static FieldsMappingOption hintA(final Class<?> ... type) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                String declaration = FieldsMappingOptions.mergeTypeNames(type);
                fieldMappingBuilder.srcHintContainer(declaration);
            }
        };
    }

    public static FieldsMappingOption hintB(final Class<?> ... type) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                String declaration = FieldsMappingOptions.mergeTypeNames(type);
                fieldMappingBuilder.destHintContainer(declaration);
            }
        };
    }

    public static FieldsMappingOption deepHintA(final Class<?> ... type) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                String declaration = FieldsMappingOptions.mergeTypeNames(type);
                fieldMappingBuilder.srcDeepIndexHintContainer(declaration);
            }
        };
    }

    public static FieldsMappingOption deepHintB(final Class<?> ... type) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                String declaration = FieldsMappingOptions.mergeTypeNames(type);
                fieldMappingBuilder.destDeepIndexHintContainer(declaration);
            }
        };
    }

    private static String mergeTypeNames(Class<?>[] type) {
        Object[] typeNames = new String[type.length];
        for (int i = 0; i < type.length; ++i) {
            Class<?> t = type[i];
            typeNames[i] = t.getName();
        }
        return StringUtils.join((Object[])typeNames, (String)",");
    }

    public static FieldsMappingOption removeOrphans() {
        return FieldsMappingOptions.removeOrphans(true);
    }

    public static FieldsMappingOption removeOrphans(final boolean removeOrphans) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.removeOrphans(removeOrphans);
            }
        };
    }

    public static FieldsMappingOption relationshipType(final RelationshipType relationshipType) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.relationshipType(relationshipType);
            }
        };
    }

    public static FieldsMappingOption collectionStrategy(final boolean removeOrphans, final RelationshipType relationshipType) {
        return new FieldsMappingOption(){

            @Override
            public void apply(DozerBuilder.FieldMappingBuilder fieldMappingBuilder) {
                fieldMappingBuilder.removeOrphans(removeOrphans);
                fieldMappingBuilder.relationshipType(relationshipType);
            }
        };
    }
}

