/*
 * Decompiled with CFR 0.152.
 */
package play.modules.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ResponseHeader;
import io.swagger.annotations.Scope;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PrimitiveType;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import play.Logger;
import play.api.mvc.EssentialAction;
import play.api.mvc.Result;
import play.modules.swagger.PlaySwaggerConfig;
import play.modules.swagger.RouteWrapper;
import play.modules.swagger.util.CrossUtil;
import play.routes.compiler.DynamicPart;
import play.routes.compiler.PathPattern;
import play.routes.compiler.Route;
import play.routes.compiler.StaticPart;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

public class PlayReader {
    private static final String SUCCESSFUL_OPERATION = "successful operation";
    private Swagger swagger;
    private PlaySwaggerConfig config;
    private RouteWrapper routes;

    public Swagger getSwagger() {
        return this.swagger;
    }

    public PlayReader(PlaySwaggerConfig playSwaggerConfig, RouteWrapper routeWrapper, Swagger swagger) {
        this.routes = routeWrapper;
        this.config = playSwaggerConfig;
        this.swagger = swagger == null ? new Swagger() : swagger;
    }

    public Swagger read(Set<Class<?>> set) {
        for (Class<?> clazz : set) {
            SwaggerDefinition swaggerDefinition = clazz.getAnnotation(SwaggerDefinition.class);
            if (swaggerDefinition == null) continue;
            this.readSwaggerConfig(clazz, swaggerDefinition);
        }
        for (Class<?> clazz : set) {
            this.read(clazz);
        }
        return this.swagger;
    }

    public Swagger read(Class<?> clazz) {
        return this.read(clazz, false);
    }

    private Swagger read(Class<?> clazz, boolean bl) {
        boolean bl2;
        Api api = clazz.getAnnotation(Api.class);
        HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
        ArrayList<SecurityRequirement> arrayList = new ArrayList<SecurityRequirement>();
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{};
        EnumSet<Scheme> enumSet = EnumSet.noneOf(Scheme.class);
        boolean bl3 = bl2 = api != null && bl || api != null && !api.hidden();
        if (bl2) {
            Method[] methodArray;
            Object object;
            Route route;
            Object object2;
            Set<String> set = this.extractTags(api);
            for (String methodArray2 : set) {
                Tag tag = new Tag().name(methodArray2);
                hashMap.put(methodArray2, tag);
            }
            java.util.Iterator<String> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.getSwagger().tag((Tag)hashMap.get(string));
            }
            if (!api.produces().isEmpty()) {
                stringArray2 = this.toArray(api.produces());
            }
            if (!api.consumes().isEmpty()) {
                stringArray = this.toArray(api.consumes());
            }
            enumSet.addAll(PlayReader.parseSchemes(api.protocols()));
            for (java.util.Iterator<String> iterator2 : iterator = api.authorizations()) {
                if (iterator2.value() == null || "".equals(iterator2.value())) continue;
                SecurityRequirement securityRequirement = new SecurityRequirement();
                securityRequirement.setName(iterator2.value());
                route = object2 = iterator2.scopes();
                int n = ((AuthorizationScope[])route).length;
                for (int i = 0; i < n; ++i) {
                    object = route[i];
                    if (object.scope() == null || "".equals(object.scope())) continue;
                    securityRequirement.addScope(object.scope());
                }
                arrayList.add(securityRequirement);
            }
            for (Method method : methodArray = clazz.getMethods()) {
                java.util.Iterator<Object> iterator3;
                int n;
                Scheme scheme;
                java.util.Iterator<Object> iterator4;
                String string;
                if (ReflectionUtils.isOverriddenMethod((Method)method, clazz) || !this.routes.exists((String)(object2 = this.getFullMethodName(clazz, method))) || (string = this.getPathFromRoute((route = this.routes.apply((String)object2)).path(), this.config.basePath())) == null) continue;
                ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
                object = this.extractOperationMethod(apiOperation, method, route);
                Operation operation = null;
                if (apiOperation != null || object != null) {
                    operation = this.parseMethod(clazz, method, route);
                }
                if (operation == null) continue;
                if (apiOperation != null) {
                    iterator4 = PlayReader.parseSchemes(apiOperation.protocols()).iterator();
                    while (iterator4.hasNext()) {
                        scheme = (Scheme)iterator4.next();
                        operation.scheme(scheme);
                    }
                }
                if (operation.getSchemes() == null || operation.getSchemes().isEmpty()) {
                    iterator4 = enumSet.iterator();
                    while (iterator4.hasNext()) {
                        scheme = (Scheme)iterator4.next();
                        operation.scheme(scheme);
                    }
                }
                if (object == null) continue;
                if (apiOperation != null) {
                    iterator4 = apiOperation.tags();
                    int n2 = ((java.util.Iterator<Object>)iterator4).length;
                    for (n = 0; n < n2; ++n) {
                        iterator3 = iterator4[n];
                        if ("".equals(iterator3)) continue;
                        operation.tag(iterator3);
                        this.getSwagger().tag(new Tag().name(iterator3));
                    }
                    operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions()));
                }
                if (operation.getConsumes() == null) {
                    iterator4 = stringArray;
                    int n3 = ((java.util.Iterator<Object>)iterator4).length;
                    for (n = 0; n < n3; ++n) {
                        iterator3 = iterator4[n];
                        operation.consumes(iterator3);
                    }
                }
                if (operation.getProduces() == null) {
                    iterator4 = stringArray2;
                    int n4 = ((java.util.Iterator<Object>)iterator4).length;
                    for (n = 0; n < n4; ++n) {
                        iterator3 = iterator4[n];
                        operation.produces(iterator3);
                    }
                }
                if (operation.getTags() == null) {
                    iterator4 = hashMap.keySet().iterator();
                    while (iterator4.hasNext()) {
                        String string2 = (String)iterator4.next();
                        operation.tag(string2);
                    }
                }
                if (operation.getSecurity() == null) {
                    iterator4 = arrayList.iterator();
                    while (iterator4.hasNext()) {
                        SecurityRequirement securityRequirement = (SecurityRequirement)iterator4.next();
                        operation.security(securityRequirement);
                    }
                }
                if ((iterator4 = this.getSwagger().getPath(string)) == null) {
                    iterator4 = new Path();
                    this.getSwagger().path(string, iterator4);
                }
                iterator4.set((String)object, operation);
                this.readImplicitParameters(method, operation, clazz);
            }
        }
        return this.getSwagger();
    }

    String getPathFromRoute(PathPattern pathPattern, String string) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : pathPattern.parts()) {
            if (object2 instanceof StaticPart) {
                stringBuilder.append(((StaticPart)object2).value());
                continue;
            }
            if (object2 instanceof DynamicPart) {
                stringBuilder.append("{");
                stringBuilder.append(((DynamicPart)object2).name());
                stringBuilder.append("}");
                continue;
            }
            try {
                stringBuilder.append(((StaticPart)object2).value());
            }
            catch (ClassCastException classCastException) {
                Logger.of((String)"swagger").warn(String.format("ClassCastException parsing path from route: %s", classCastException.getMessage()));
            }
        }
        object2 = new StringBuilder(string);
        if (string.startsWith("/")) {
            ((StringBuilder)object2).deleteCharAt(0);
        }
        if (!string.endsWith("/")) {
            ((StringBuilder)object2).append("/");
        }
        String string2 = ((StringBuilder)object2).toString();
        String string3 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (string3.startsWith("/") && string3.startsWith(string2, 1) || string3.startsWith(string2)) {
            stringBuilder2.append(string3.replaceFirst(string2, ""));
        } else {
            stringBuilder2.append(string3);
        }
        if (!stringBuilder2.toString().startsWith("/")) {
            stringBuilder2.insert(0, "/");
        }
        return stringBuilder2.toString();
    }

    protected void readSwaggerConfig(Class<?> clazz, SwaggerDefinition swaggerDefinition) {
        Tag tag;
        if (!swaggerDefinition.basePath().isEmpty()) {
            this.swagger.setBasePath(swaggerDefinition.basePath());
        }
        if (!swaggerDefinition.host().isEmpty()) {
            this.swagger.setHost(swaggerDefinition.host());
        }
        this.readInfoConfig(swaggerDefinition);
        for (String string : swaggerDefinition.consumes()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : swaggerDefinition.produces()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        if (!swaggerDefinition.externalDocs().value().isEmpty()) {
            ApiKeyAuthDefinition[] apiKeyAuthDefinitionArray = this.swagger.getExternalDocs();
            if (apiKeyAuthDefinitionArray == null) {
                apiKeyAuthDefinitionArray = new ExternalDocs();
                this.swagger.setExternalDocs((ExternalDocs)apiKeyAuthDefinitionArray);
            }
            apiKeyAuthDefinitionArray.setDescription(swaggerDefinition.externalDocs().value());
            if (!swaggerDefinition.externalDocs().url().isEmpty()) {
                apiKeyAuthDefinitionArray.setUrl(swaggerDefinition.externalDocs().url());
            }
        }
        for (ExternalDocs externalDocs : swaggerDefinition.tags()) {
            if (externalDocs.name().isEmpty()) continue;
            tag = new Tag();
            tag.setName(externalDocs.name());
            tag.setDescription(externalDocs.description());
            if (!externalDocs.externalDocs().value().isEmpty()) {
                tag.setExternalDocs(new ExternalDocs(externalDocs.externalDocs().value(), externalDocs.externalDocs().url()));
            }
            tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])externalDocs.extensions()));
            this.swagger.addTag(tag);
        }
        for (ApiKeyAuthDefinition apiKeyAuthDefinition : swaggerDefinition.securityDefinition().apiKeyAuthDefinitions()) {
            tag = new io.swagger.models.auth.ApiKeyAuthDefinition();
            tag.setName(apiKeyAuthDefinition.name());
            tag.setIn(In.forValue((String)apiKeyAuthDefinition.in().toValue()));
            tag.setDescription(apiKeyAuthDefinition.description());
            this.swagger.addSecurityDefinition(apiKeyAuthDefinition.key(), (SecuritySchemeDefinition)tag);
        }
        for (ApiKeyAuthDefinition apiKeyAuthDefinition : swaggerDefinition.securityDefinition().basicAuthDefinitions()) {
            tag = new BasicAuthDefinition();
            tag.setDescription(apiKeyAuthDefinition.description());
            this.swagger.addSecurityDefinition(apiKeyAuthDefinition.key(), (SecuritySchemeDefinition)tag);
        }
        for (ApiKeyAuthDefinition apiKeyAuthDefinition : swaggerDefinition.securityDefinition().oAuth2Definitions()) {
            tag = new OAuth2Definition();
            tag.setTokenUrl(apiKeyAuthDefinition.tokenUrl());
            tag.setAuthorizationUrl(apiKeyAuthDefinition.authorizationUrl());
            tag.setFlow(apiKeyAuthDefinition.flow().name().toLowerCase());
            for (Scope scope : apiKeyAuthDefinition.scopes()) {
                tag.addScope(scope.name(), scope.description());
            }
            this.swagger.addSecurityDefinition(apiKeyAuthDefinition.key(), (SecuritySchemeDefinition)tag);
        }
        for (ApiKeyAuthDefinition apiKeyAuthDefinition : swaggerDefinition.schemes()) {
            if (apiKeyAuthDefinition == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)apiKeyAuthDefinition.name()));
        }
    }

    protected void readInfoConfig(SwaggerDefinition swaggerDefinition) {
        Contact contact;
        io.swagger.annotations.Info info = swaggerDefinition.info();
        Info info2 = this.swagger.getInfo();
        if (info2 == null) {
            info2 = new Info();
            this.swagger.setInfo(info2);
        }
        if (!info.description().isEmpty()) {
            info2.setDescription(info.description());
        }
        if (!info.termsOfService().isEmpty()) {
            info2.setTermsOfService(info.termsOfService());
        }
        if (!info.title().isEmpty()) {
            info2.setTitle(info.title());
        }
        if (!info.version().isEmpty()) {
            info2.setVersion(info.version());
        }
        if (!info.contact().name().isEmpty()) {
            contact = info2.getContact();
            if (contact == null) {
                contact = new Contact();
                info2.setContact(contact);
            }
            contact.setName(info.contact().name());
            if (!info.contact().email().isEmpty()) {
                contact.setEmail(info.contact().email());
            }
            if (!info.contact().url().isEmpty()) {
                contact.setUrl(info.contact().url());
            }
        }
        if (!info.license().name().isEmpty()) {
            contact = info2.getLicense();
            if (contact == null) {
                contact = new License();
                info2.setLicense((License)contact);
            }
            contact.setName(info.license().name());
            if (!info.license().url().isEmpty()) {
                contact.setUrl(info.license().url());
            }
        }
        info2.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])info.extensions()));
    }

    private void readImplicitParameters(Method method, Operation operation, Class<?> clazz) {
        ApiImplicitParams apiImplicitParams = method.getAnnotation(ApiImplicitParams.class);
        if (apiImplicitParams != null && apiImplicitParams.value().length > 0) {
            for (ApiImplicitParam apiImplicitParam : apiImplicitParams.value()) {
                Parameter parameter = this.readImplicitParam(apiImplicitParam, clazz);
                if (parameter == null) continue;
                operation.addParameter(parameter);
            }
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam apiImplicitParam, Class<?> clazz) {
        PathParameter pathParameter;
        if (apiImplicitParam.paramType().equalsIgnoreCase("path")) {
            pathParameter = new PathParameter();
        } else if (apiImplicitParam.paramType().equalsIgnoreCase("query")) {
            pathParameter = new QueryParameter();
        } else if (apiImplicitParam.paramType().equalsIgnoreCase("form") || apiImplicitParam.paramType().equalsIgnoreCase("formData")) {
            pathParameter = new FormParameter();
        } else if (apiImplicitParam.paramType().equalsIgnoreCase("body")) {
            pathParameter = null;
        } else if (apiImplicitParam.paramType().equalsIgnoreCase("header")) {
            pathParameter = new HeaderParameter();
        } else {
            Logger.of((String)"swagger").warn("Unkown implicit parameter type: [" + apiImplicitParam.paramType() + "]");
            return null;
        }
        Type type = null;
        if (!("".equalsIgnoreCase(apiImplicitParam.dataType()) || "file".equalsIgnoreCase(apiImplicitParam.dataType()) || "array".equalsIgnoreCase(apiImplicitParam.dataType()))) {
            type = PlayReader.typeFromString(apiImplicitParam.dataType(), clazz);
        } else if (apiImplicitParam.dataTypeClass() != null && !PlayReader.isVoid(apiImplicitParam.dataTypeClass())) {
            type = apiImplicitParam.dataTypeClass();
        }
        Parameter parameter = ParameterProcessor.applyAnnotations((Swagger)this.getSwagger(), (Parameter)pathParameter, type == null ? String.class : type, Collections.singletonList(apiImplicitParam));
        if (parameter instanceof AbstractSerializableParameter && type != null) {
            Property property = this.createProperty(type);
            ((AbstractSerializableParameter)pathParameter).setProperty(property);
        }
        return parameter;
    }

    private static Type typeFromString(String string, Class<?> clazz) {
        PrimitiveType primitiveType = PrimitiveType.fromName((String)string);
        if (primitiveType != null) {
            return primitiveType.getKeyClass();
        }
        try {
            Type type = PlayReader.getOptionTypeFromString(string, clazz);
            if (type != null) {
                return type;
            }
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            Logger.of((String)"swagger").error(String.format("Failed to resolve '%s' into class", string), (Throwable)exception);
            return null;
        }
    }

    private Operation parseMethod(Class<?> clazz, Method method, Route route) {
        AuthorizationScope[] authorizationScopeArray;
        Response response;
        Authorization authorization;
        int n;
        Authorization[] authorizationArray;
        Object object;
        Operation operation = new Operation();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        ApiResponses apiResponses = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class);
        String string = method.getName();
        operation.operationId(string);
        String string2 = null;
        Type type = null;
        Map<Object, Object> map = new HashMap();
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!"".equals(apiOperation.nickname())) {
                string = apiOperation.nickname();
            }
            map = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (apiOperation.response() != null && !PlayReader.isVoid(apiOperation.response())) {
                type = apiOperation.response();
            }
            if (!"".equals(apiOperation.responseContainer())) {
                string2 = apiOperation.responseContainer();
            }
            if (apiOperation.authorizations() != null) {
                object = new ArrayList();
                authorizationArray = apiOperation.authorizations();
                n = authorizationArray.length;
                for (int i = 0; i < n; ++i) {
                    authorization = authorizationArray[i];
                    if (authorization.value() == null || "".equals(authorization.value())) continue;
                    response = new SecurityRequirement();
                    response.setName(authorization.value());
                    for (AuthorizationScope authorizationScope : authorizationScopeArray = authorization.scopes()) {
                        if (authorizationScope.scope() == null || "".equals(authorizationScope.scope())) continue;
                        response.addScope(authorizationScope.scope());
                    }
                    object.add(response);
                }
                if (object.size() > 0) {
                    object.forEach(arg_0 -> ((Operation)operation).security(arg_0));
                }
            }
            if (apiOperation.consumes() != null && !apiOperation.consumes().isEmpty()) {
                operation.consumes(Arrays.asList(this.toArray(apiOperation.consumes())));
            }
            if (apiOperation.produces() != null && !apiOperation.produces().isEmpty()) {
                operation.produces(Arrays.asList(this.toArray(apiOperation.produces())));
            }
        }
        if (apiOperation != null && StringUtils.isNotEmpty((CharSequence)apiOperation.responseReference())) {
            object = new Response().description(SUCCESSFUL_OPERATION);
            object.schema((Property)new RefProperty(apiOperation.responseReference()));
            operation.addResponse(String.valueOf(apiOperation.code()), (Response)object);
        } else if (type == null) {
            type = method.getGenericReturnType();
        }
        if (PlayReader.isValidResponse(type) && (object = ModelConverters.getInstance().readAsProperty(type)) != null) {
            authorizationArray = ContainerWrapper.wrapContainer(string2, (Property)object, new ContainerWrapper[0]);
            n = apiOperation == null ? 200 : apiOperation.code();
            operation.response(n, new Response().description(SUCCESSFUL_OPERATION).schema((Property)authorizationArray).headers(map));
            this.appendModels(type);
        }
        operation.operationId(string);
        if (apiResponses != null) {
            for (ApiResponse apiResponse : apiResponses.value()) {
                authorization = this.parseResponseHeaders(apiResponse.responseHeaders());
                response = new Response().description(apiResponse.message()).headers(authorization);
                if (apiResponse.code() == 0) {
                    operation.defaultResponse(response);
                } else {
                    operation.response(apiResponse.code(), response);
                }
                if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
                    response.schema((Property)new RefProperty(apiResponse.reference()));
                    continue;
                }
                if (PlayReader.isVoid(apiResponse.response())) continue;
                type = apiResponse.response();
                authorizationScopeArray = ModelConverters.getInstance().readAsProperty(type);
                if (authorizationScopeArray == null) continue;
                response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), (Property)authorizationScopeArray, new ContainerWrapper[0]));
                this.appendModels(type);
            }
        }
        if (ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null) {
            operation.setDeprecated(Boolean.valueOf(true));
        }
        object = this.getParameters(clazz, method, route);
        object.forEach(arg_0 -> ((Operation)operation).parameter(arg_0));
        if (operation.getResponses() == null) {
            Response response2 = new Response().description(SUCCESSFUL_OPERATION);
            operation.defaultResponse(response2);
        }
        return operation;
    }

    private static Type getOptionTypeFromString(String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        String string2 = "(Option|scala\\.Option)\\s*\\[\\s*(Int|Long|Float|Double|Byte|Short|Char|Boolean)\\s*\\]\\s*$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(2);
            return OptionTypeResolver.resolveOptionType(string3, clazz);
        }
        return null;
    }

    private Type getParamType(Class<?> clazz, Method method, String string, int n) {
        try {
            Type type = PlayReader.getOptionTypeFromString(string, clazz);
            if (type != null) {
                return type;
            }
            Type[] typeArray = method.getGenericParameterTypes();
            return Json.mapper().getTypeFactory().constructType(typeArray[n], clazz);
        }
        catch (Exception exception) {
            Logger.of((String)"swagger").error(String.format("Exception getting parameter type for method %s, param %s at position %d", method, string, n), (Throwable)exception);
            return null;
        }
    }

    private List<Annotation> getParamAnnotations(Class<?> clazz, Type[] typeArray, Annotation[][] annotationArray, String string, int n) {
        try {
            return Arrays.asList(annotationArray[n]);
        }
        catch (Exception exception) {
            Logger.of((String)"swagger").error(String.format("Exception getting parameter type for %s at position %d", string, n), (Throwable)exception);
            return null;
        }
    }

    private List<Annotation> getParamAnnotations(Class<?> clazz, Method method, String string, int n) {
        Annotation[][] annotationArray;
        Type[] typeArray = method.getGenericParameterTypes();
        List<Annotation> list = this.getParamAnnotations(clazz, typeArray, annotationArray = method.getParameterAnnotations(), string, n);
        if (list != null) {
            return list;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            list = this.getParamAnnotations(clazz, typeArray, annotationArray, string, i);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    private List<Parameter> getParameters(Class<?> clazz, Method method, Route route) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (!route.call().parameters().isDefined()) {
            return arrayList;
        }
        Iterator iterator = ((Seq)route.call().parameters().get()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PathParameter pathParameter;
            play.routes.compiler.Parameter parameter = (play.routes.compiler.Parameter)iterator.next();
            if (!parameter.fixed().isEmpty()) continue;
            String string = CrossUtil.getParameterDefaultField(parameter);
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            Type type = this.getParamType(clazz, method, parameter.typeName(), n);
            Property property = this.createProperty(type);
            if (route.path().has(parameter.name())) {
                pathParameter = new PathParameter();
                pathParameter.setDefaultValue(string);
                if (property != null) {
                    pathParameter.setProperty(property);
                }
            } else {
                pathParameter = new QueryParameter();
                ((QueryParameter)pathParameter).setDefaultValue(string);
                if (property != null) {
                    ((QueryParameter)pathParameter).setProperty(property);
                }
            }
            pathParameter.setName(parameter.name());
            List<Annotation> list = this.getParamAnnotations(clazz, method, parameter.typeName(), n);
            ParameterProcessor.applyAnnotations((Swagger)this.getSwagger(), (Parameter)pathParameter, (Type)type, list);
            arrayList.add((Parameter)pathParameter);
            ++n;
        }
        return arrayList;
    }

    private static Set<Scheme> parseSchemes(String string) {
        EnumSet<Scheme> enumSet = EnumSet.noneOf(Scheme.class);
        for (String string2 : StringUtils.trimToEmpty((String)string).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)string2));
            if (scheme == null) continue;
            enumSet.add(scheme);
        }
        return enumSet;
    }

    private static boolean isVoid(Type type) {
        Class clazz = Json.mapper().getTypeFactory().constructType(type).getRawClass();
        return Void.class.isAssignableFrom(clazz) || Void.TYPE.isAssignableFrom(clazz);
    }

    private static boolean isValidResponse(Type type) {
        if (type == null) {
            return false;
        }
        JavaType javaType = Json.mapper().getTypeFactory().constructType(type);
        if (PlayReader.isVoid((Type)javaType)) {
            return false;
        }
        Class clazz = javaType.getRawClass();
        if (EssentialAction.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (play.mvc.Result.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (Result.class.isAssignableFrom(clazz)) {
            return false;
        }
        return !PlayReader.isResourceClass(clazz);
    }

    private static boolean isResourceClass(Class<?> clazz) {
        return clazz.getAnnotation(Api.class) != null;
    }

    protected Set<String> extractTags(Api api) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        boolean bl = false;
        Object object = api.tags();
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string = object[i];
            if ("".equals(string)) continue;
            bl = true;
            linkedHashSet.add(string);
        }
        if (!bl && !"".equals(object = api.value().replace("/", ""))) {
            linkedHashSet.add((String)object);
        }
        return linkedHashSet;
    }

    private Property createProperty(Type type) {
        return this.enforcePrimitive(ModelConverters.getInstance().readAsProperty(type), 0);
    }

    private Property enforcePrimitive(Property property, int n) {
        if (property instanceof RefProperty) {
            return new StringProperty();
        }
        if (property instanceof ArrayProperty) {
            if (n == 0) {
                ArrayProperty arrayProperty = (ArrayProperty)property;
                arrayProperty.setItems(this.enforcePrimitive(arrayProperty.getItems(), n + 1));
            } else {
                return new StringProperty();
            }
        }
        return property;
    }

    private void appendModels(Type type) {
        Map map = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : map.entrySet()) {
            this.getSwagger().model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private Map<String, Property> parseResponseHeaders(ResponseHeader[] responseHeaderArray) {
        HashMap<String, Property> hashMap = null;
        if (responseHeaderArray != null && responseHeaderArray.length > 0) {
            for (ResponseHeader responseHeader : responseHeaderArray) {
                Property property;
                String string = responseHeader.name();
                if ("".equals(string)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, Property>();
                }
                String string2 = responseHeader.description();
                Class clazz = responseHeader.response();
                if (PlayReader.isVoid(clazz) || (property = ModelConverters.getInstance().readAsProperty((Type)clazz)) == null) continue;
                Property property2 = ContainerWrapper.wrapContainer(responseHeader.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
                property2.setDescription(string2);
                hashMap.put(string, property2);
                this.appendModels(clazz);
            }
        }
        return hashMap;
    }

    public String getFullMethodName(Class clazz, Method method) {
        if (!clazz.getCanonicalName().contains("$")) {
            return clazz.getCanonicalName() + "$." + method.getName();
        }
        return clazz.getCanonicalName() + "." + method.getName();
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Route route) {
        String string = null;
        if (route != null) {
            try {
                string = route.verb().toString().toLowerCase();
            }
            catch (Exception exception) {
                Logger.of((String)"swagger").error("http method not found for method: " + method.getName(), (Throwable)exception);
            }
        }
        if (string == null && !StringUtils.isEmpty((CharSequence)apiOperation.httpMethod())) {
            string = apiOperation.httpMethod();
        }
        return string;
    }

    private String[] toArray(String string) {
        String[] stringArray;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return new String[]{string};
        }
        int n = 0;
        for (String string2 : stringArray = string.split(",")) {
            stringArray[n] = string2.trim();
            ++n;
        }
        return stringArray;
    }

    static {
        Json.mapper().addMixIn(AbstractProperty.class, AbstractPropertyMixin.class);
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String string2) {
            this.container = string2;
        }

        public static Property wrapContainer(String string, Property property, ContainerWrapper ... containerWrapperArray) {
            EnumSet<ContainerWrapper> enumSet = containerWrapperArray.length > 0 ? EnumSet.copyOf(Arrays.asList(containerWrapperArray)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper containerWrapper : enumSet) {
                Property property2 = containerWrapper.wrap(string, property);
                if (property2 == null) continue;
                return property2;
            }
            return property;
        }

        public Property wrap(String string, Property property) {
            if (this.container.equalsIgnoreCase(string)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }

    static final class OptionTypeResolver {
        private Option<Integer> optionTypeInt;
        private Option<Long> optionTypeLong;
        private Option<Byte> optionTypeByte;
        private Option<Boolean> optionTypeBoolean;
        private Option<Character> optionTypeChar;
        private Option<Float> optionTypeFloat;
        private Option<Double> optionTypeDouble;
        private Option<Short> optionTypeShort;

        OptionTypeResolver() {
        }

        static Type resolveOptionType(String string, Class<?> clazz) {
            try {
                return Json.mapper().getTypeFactory().constructType(OptionTypeResolver.class.getDeclaredField("optionType" + string).getGenericType(), clazz);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
        }
    }

    private static interface AbstractPropertyMixin {
        @JsonIgnore
        public Property readOnly();
    }
}

