/*
 * Decompiled with CFR 0.152.
 */
package com.github.junit5docker;

import com.github.junit5docker.DefaultDockerClient;
import com.github.junit5docker.Docker;
import com.github.junit5docker.DockerClientAdapter;
import com.github.junit5docker.Environment;
import com.github.junit5docker.Port;
import com.github.junit5docker.PortBinding;
import com.github.junit5docker.WaitFor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class DockerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final DockerClientAdapter dockerClient;
    private String containerId;

    DockerExtension() {
        this(new DefaultDockerClient());
    }

    DockerExtension(DockerClientAdapter dockerClient) {
        this.dockerClient = dockerClient;
    }

    public void beforeAll(ExtensionContext containerExtensionContext) {
        Docker dockerAnnotation = this.findDockerAnnotation(containerExtensionContext);
        if (!dockerAnnotation.newForEachCase()) {
            this.startContainer(dockerAnnotation);
        }
    }

    public void beforeEach(ExtensionContext context) {
        Docker dockerAnnotation = this.findDockerAnnotation(context);
        if (dockerAnnotation.newForEachCase()) {
            this.startContainer(dockerAnnotation);
        }
    }

    private void startContainer(Docker dockerAnnotation) {
        PortBinding[] portBindings = this.createPortBindings(dockerAnnotation);
        Map<String, String> environmentMap = this.createEnvironmentMap(dockerAnnotation);
        String imageReference = this.findImageName(dockerAnnotation);
        WaitFor waitFor = dockerAnnotation.waitFor();
        this.containerId = this.dockerClient.startContainer(imageReference, environmentMap, portBindings);
        this.waitForLogAccordingTo(waitFor);
    }

    private void waitForLogAccordingTo(WaitFor waitFor) {
        String expectedLog = waitFor.value();
        if (!"".equals(expectedLog)) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            CompletableFuture<Boolean> logFound = CompletableFuture.supplyAsync(this.findFirstLogContaining(expectedLog), executor);
            executor.shutdown();
            try {
                boolean termination = executor.awaitTermination(waitFor.timeoutInMillis(), TimeUnit.MILLISECONDS);
                if (!termination) {
                    throw new AssertionError((Object)("Timeout while waiting for log : \"" + expectedLog + "\""));
                }
                if (!logFound.getNow(false).booleanValue()) {
                    throw new AssertionError((Object)("\"" + expectedLog + "\" not found in logs and container stopped"));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Supplier<Boolean> findFirstLogContaining(String logToFind) {
        return () -> {
            try (Stream<String> logs = this.dockerClient.logs(this.containerId);){
                Boolean bl = logs.anyMatch(log -> log.contains(logToFind));
                return bl;
            }
        };
    }

    private Docker findDockerAnnotation(ExtensionContext extensionContext) {
        Class testClass = (Class)extensionContext.getTestClass().get();
        return testClass.getAnnotation(Docker.class);
    }

    private String findImageName(Docker dockerAnnotation) {
        return dockerAnnotation.image();
    }

    private Map<String, String> createEnvironmentMap(Docker dockerAnnotation) {
        Environment[] environments;
        HashMap<String, String> environmentMap = new HashMap<String, String>();
        for (Environment environment : environments = dockerAnnotation.environments()) {
            environmentMap.put(environment.key(), environment.value());
        }
        return environmentMap;
    }

    private PortBinding[] createPortBindings(Docker dockerAnnotation) {
        Port[] ports = dockerAnnotation.ports();
        PortBinding[] portBindings = new PortBinding[ports.length];
        for (int i = 0; i < ports.length; ++i) {
            Port port = ports[i];
            portBindings[i] = new PortBinding(port.exposed(), port.inner());
        }
        return portBindings;
    }

    public void afterAll(ExtensionContext containerExtensionContext) {
        Docker dockerAnnotation = this.findDockerAnnotation(containerExtensionContext);
        if (!dockerAnnotation.newForEachCase()) {
            this.dockerClient.stopAndRemoveContainer(this.containerId);
        }
    }

    public void afterEach(ExtensionContext context) {
        Docker dockerAnnotation = this.findDockerAnnotation(context);
        if (dockerAnnotation.newForEachCase()) {
            this.dockerClient.stopAndRemoveContainer(this.containerId);
        }
    }
}

