/*
 * Decompiled with CFR 0.152.
 */
package com.github.junit5docker;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class QueueIterator
implements Iterator<String>,
AutoCloseable {
    private static final int POLL_TIMEOUT = 10;
    private final AtomicBoolean opened;
    private final BlockingQueue<String> lines;
    private Optional<String> lineRead = Optional.empty();

    QueueIterator(BlockingQueue<String> lines) {
        this.opened = new AtomicBoolean(true);
        this.lines = lines;
    }

    @Override
    public boolean hasNext() {
        while (this.opened.get() && !this.lineRead.isPresent()) {
            try {
                this.lineRead = Optional.ofNullable(this.lines.poll(10L, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                this.opened.set(false);
                Thread.currentThread().interrupt();
            }
        }
        return this.lineRead.isPresent();
    }

    @Override
    public String next() {
        if (!this.lineRead.isPresent()) {
            throw new NoSuchElementException("Line read is null");
        }
        String result = this.lineRead.get();
        this.lineRead = Optional.empty();
        return result;
    }

    @Override
    public void close() {
        this.opened.set(false);
    }
}

