/*
 * Copyright (c) 2014 - 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.ferstl.depgraph.dependency.dot.style.resource;


public enum BuiltInStyleResource {

  DEFAULT_STYLE("default-style.json"),
  GROUP_ID_ONLY_STYLE("group-id-only-style.json");

  private final String styleConfig;

  BuiltInStyleResource(String styleConfig) {
    this.styleConfig = styleConfig;
  }

  public ClasspathStyleResource createStyleResource(ClassLoader classLoader) {
    return new ClasspathStyleResource(this.styleConfig, classLoader);
  }
}
