/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.output;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;

public abstract class AbstractProcessOutput
implements Serializable {
    private static final long serialVersionUID = 1902809285333524039L;
    protected String[] m_Command;
    protected String[] m_Environment;
    protected int m_ExitCode;

    public AbstractProcessOutput() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Command = new String[0];
        this.m_Environment = null;
        this.m_ExitCode = 0;
    }

    public void monitor(ProcessBuilder builder) throws Exception {
        this.monitor(null, builder);
    }

    public void monitor(String input, ProcessBuilder builder) throws Exception {
        this.monitor(builder.command().toArray(new String[0]), null, input, builder.start());
    }

    public void monitor(String cmd, String[] env, Process process) throws Exception {
        this.monitor(cmd, env, null, process);
    }

    public void monitor(String cmd, String[] env, String input, Process process) throws Exception {
        this.monitor(new String[]{cmd}, env, input, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(String[] cmd, String[] env, String input, Process process) throws Exception {
        this.m_Command = cmd;
        this.m_Environment = env;
        Thread threade = new Thread(this.configureStdErr(process));
        threade.start();
        Thread threado = new Thread(this.configureStdOut(process));
        threado.start();
        if (input != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            writer.write(input);
            writer.close();
        }
        this.m_ExitCode = process.waitFor();
        while (threade.isAlive() || threado.isAlive()) {
            try {
                AbstractProcessOutput abstractProcessOutput = this;
                synchronized (abstractProcessOutput) {
                    this.wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    protected abstract Thread configureStdErr(Process var1);

    protected abstract Thread configureStdOut(Process var1);

    public String[] getCommand() {
        return this.m_Command;
    }

    public String[] getEnvironment() {
        return this.m_Environment;
    }

    public boolean hasSucceeded() {
        return this.m_ExitCode == 0;
    }

    public int getExitCode() {
        return this.m_ExitCode;
    }

    public String toString() {
        return "exit code=" + this.m_ExitCode;
    }
}

